/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.cenqua.fisheye.util.Timer;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ChangesetRevCountRepoUpgradeTask
extends AbstractRepositoryVersionUpgradeTask {
    private static final int COMMIT_BLOCK_SIZE = 1000;

    public ChangesetRevCountRepoUpgradeTask() {
        super((Map<ScmType, Integer>)ImmutableMap.of((Object)((Object)ScmType.CVS), (Object)16, (Object)((Object)ScmType.SVN), (Object)28, (Object)((Object)ScmType.P4), (Object)7, (Object)((Object)ScmType.HG), (Object)6, (Object)((Object)ScmType.GIT), (Object)14));
    }

    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        Timer upgrade = new Timer("Upgrade task - precompute rev count, repo = " + engine.getName());
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        int count = 0;
        for (ChangeSet changeSet : cache.getChangeSets()) {
            cache.getChangeSetDAO().setRevisionCount(changeSet.getId(), ChangesetRevCountRepoUpgradeTask.countChangeSetRevisions(cache, changeSet.getId()));
            if (++count % 1000 != 0) continue;
            cache.commit();
        }
        cache.commit();
        this.markUpgradeTaskComplete(cache, props);
        upgrade.end();
    }

    @Override
    public String getName() {
        return "Precompute revision count repository upgrade";
    }

    public static int countChangeSetRevisions(InternalRevisionCache<?> cache, String csid) throws DbException {
        if (csid != null) {
            final AtomicInteger count = new AtomicInteger(0);
            cache.getCommonRevInfoDAO().searchChangeSetRevids(csid, new Predicate<Integer>(){

                public boolean apply(Integer revid) {
                    count.incrementAndGet();
                    return false;
                }
            });
            return count.get();
        }
        return 0;
    }
}

