/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;

public class ChangesetDenormalisationUpgradeTask
extends AbstractRepositoryVersionUpgradeTask {
    private static final int INSERTS_PER_COMMIT = 2000;

    public ChangesetDenormalisationUpgradeTask() {
        super((Map<ScmType, Integer>)ImmutableMap.of((Object)((Object)ScmType.CVS), (Object)18, (Object)((Object)ScmType.SVN), (Object)30, (Object)((Object)ScmType.P4), (Object)9, (Object)((Object)ScmType.HG), (Object)8, (Object)((Object)ScmType.GIT), (Object)16));
    }

    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        Timer upgrade = new Timer("Upgrade task - denormalize changeset ids, repo = " + engine.getName());
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        this.upgradeCsidRevCountEntity(cache);
        this.upgradeIndexingStateEntity(cache);
        cache.commit();
        this.markUpgradeTaskComplete(cache, props);
        upgrade.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeCsidRevCountEntity(InternalRevisionCache cache) throws IOException {
        ac db = cache.getInfDb().get();
        y cu = y.a();
        y cu2 = y.a();
        try {
            int inserts = 0;
            cu.a(CommonSchema.E_DEPRECATED_CSID_TO_REV_COUNT);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                int offset = pl;
                long csdbid = cu.v(offset);
                String csid = cache.getStringTables().changeSetIdDB.get(csdbid);
                offset = cu.w(offset);
                long count = cu.v(offset);
                if (csid == null) {
                    Logs.APP_LOG.warn((Object)("missing changeset id for database id " + csdbid + ", ignoring"));
                    continue;
                }
                cu2.f().a(CommonSchema.E_CSID_TO_REV_COUNT).b(csid).b(count);
                if (db.a_(cu2)) continue;
                db.b(cu2);
                if (++inserts % 2000 != 0) continue;
                cache.getInfDb().commit();
            }
            cache.getInfDb().commit();
        }
        finally {
            y.c(cu);
            y.c(cu2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeIndexingStateEntity(InternalRevisionCache cache) throws IOException {
        ac db = cache.getInfDb().get();
        y cu = y.a();
        y cu2 = y.a();
        try {
            int inserts = 0;
            cu.a(CommonSchema.E_DEPRECATED_INDEXING_STATE_TO_CSID);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                int offset = pl;
                long state = cu.v(offset);
                long csdbid = cu.v(offset = cu.w(offset));
                String csid = cache.getStringTables().changeSetIdDB.get(csdbid);
                if (csid == null) {
                    Logs.APP_LOG.warn((Object)("missing changeset id for database id " + csdbid + ", ignoring"));
                    continue;
                }
                cu2.f().a(CommonSchema.E_INDEXING_STATE_TO_CSID).b(state).b(csid);
                if (db.a_(cu2)) continue;
                db.b(cu2);
                if (++inserts % 2000 != 0) continue;
                cache.getInfDb().commit();
            }
            cache.getInfDb().commit();
        }
        finally {
            y.c(cu);
            y.c(cu2);
        }
    }

    @Override
    public String getName() {
        return "Changeset denormalization repository upgrade";
    }
}

