/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.crossrepo.BranchIndexer;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.cenqua.fisheye.util.Timer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;

public class BranchIndexingRepoUpgradeTask
extends AbstractRepositoryVersionUpgradeTask {
    public BranchIndexingRepoUpgradeTask() {
        super((Map<ScmType, Integer>)ImmutableMap.of((Object)((Object)ScmType.CVS), (Object)20, (Object)((Object)ScmType.SVN), (Object)32, (Object)((Object)ScmType.P4), (Object)11, (Object)((Object)ScmType.HG), (Object)10, (Object)((Object)ScmType.GIT), (Object)18));
    }

    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        Timer upgrade = new Timer("Upgrade task - index branch names, last changeset, repo = " + engine.getName());
        this.doUpgrade(engine);
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        cache.commit();
        this.markUpgradeTaskComplete(cache, props);
        upgrade.end();
    }

    protected void doUpgrade(RepositoryEngine engine) {
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        BranchIndexer branchIndexer = new BranchIndexer(engine.getCrossRepLuceneIndex());
        branchIndexer.removeAllBranches(cache.getRepositoryName());
        branchIndexer.indexBranches(cache.getBranches(), cache, engine.getStatus());
    }

    @Override
    public String getName() {
        return "Branch indexing repository upgrade";
    }
}

