/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.atlassian.fecru.upgrade.RepositoryVersionUpgradeTask;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.rep.ChangeSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractRepositoryVersionUpgradeTask
implements RepositoryVersionUpgradeTask {
    private final Multimap<ScmType, Integer> upgradeFromMap;

    public AbstractRepositoryVersionUpgradeTask(Map<ScmType, Integer> upgradeFromMap) {
        this.upgradeFromMap = Multimaps.forMap(upgradeFromMap);
    }

    public AbstractRepositoryVersionUpgradeTask(Multimap<ScmType, Integer> upgradeFromMap) {
        this.upgradeFromMap = upgradeFromMap;
    }

    @Override
    public Integer canUpgrade(ScmType repoType, int fromVersion) {
        Collection upgradeFrom = this.upgradeFromMap.get((Object)repoType);
        return upgradeFrom != null && upgradeFrom.contains(fromVersion) ? Integer.valueOf(fromVersion + 1) : null;
    }

    public void markUpgradeTaskComplete(InternalRevisionCache<? extends ChangeSet> cache, RevisionCacheProperties props) throws IOException {
        Integer upgradedToVersion = this.canUpgrade(cache.getRepositoryType(), props.getVersion());
        props.setVersion(upgradedToVersion);
        props.store();
        cache.setVersion(upgradedToVersion);
    }
}

