/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.selectionhistory;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.selectionhistory.LineRanges;
import com.cenqua.fisheye.rep.selectionhistory.MatchableLineRanges;
import com.cenqua.fisheye.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class PerLineHistoryDiffHelper {
    boolean hunksAreOffByOne = true;

    public PerLineHistoryDiffHelper() {
    }

    public PerLineHistoryDiffHelper(boolean hunksAreOffByOne) {
        this.hunksAreOffByOne = hunksAreOffByOne;
    }

    public MatchableLineRanges getPrevLines(FileRevision currentFileRevision, LineRanges ranges) {
        List<Hunk> hunks = currentFileRevision.getHunks();
        return this.getPrevLinesByHunks(hunks, ranges);
    }

    public MatchableLineRanges getPrevLinesByHunks(List<Hunk> hunks, LineRanges ranges) {
        List<Section> sections = this.getPaddedSections(hunks, ranges.getMax());
        return this.getPrevLines(sections, ranges);
    }

    protected Pair<Integer, Integer> getPaddedFileLengths(List<Hunk> hunks, int to) {
        int toMax = -1;
        int fromMax = -1;
        for (Hunk hunk : hunks) {
            int hunkMax = hunk.getTo() + hunk.getToCount();
            if (this.hunksAreOffByOne && hunk.isAdd()) {
                --hunkMax;
            }
            if (hunkMax <= toMax) continue;
            toMax = hunkMax;
            fromMax = hunk.getFrom() + hunk.getFromCount();
            if (!this.hunksAreOffByOne || !hunk.isDelete()) continue;
            ++fromMax;
        }
        if (to > toMax) {
            fromMax += to - toMax;
            toMax = to;
        }
        return Pair.newInstance(fromMax, toMax);
    }

    protected List<Section> getPaddedSections(List<Hunk> hunks, int to) {
        Pair<Integer, Integer> lengths = this.getPaddedFileLengths(hunks, to + 1);
        HunkList hunkList = new HunkList(lengths.getFirst(), lengths.getSecond(), false);
        hunkList.setHunks(hunks);
        try {
            return hunkList.getSections();
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)("Exceptions determining sections from hunks: " + hunks));
            return Collections.emptyList();
        }
    }

    protected int getFromLineNumberEquiv(Section prevSection, Section section, int toLine) {
        int result = toLine + (section.getFromStart() - section.getToStart());
        if (this.hunksAreOffByOne && prevSection != null) {
            if (prevSection.getHunk().isAdd()) {
                ++result;
            } else if (prevSection.getHunk().isDelete()) {
                --result;
            }
        }
        return result;
    }

    protected MatchableLineRanges getPrevLines(List<Section> sections, LineRanges ranges) {
        ArrayList<Pair<Integer, Integer>> newRanges = new ArrayList<Pair<Integer, Integer>>();
        boolean match = false;
        for (Pair<Integer, Integer> range : ranges.ranges) {
            MatchableLineRanges prevLines = this.getPrevLines(sections, range.getFirst(), range.getSecond());
            match |= prevLines.isMatch();
            newRanges.addAll(prevLines.ranges);
        }
        return new MatchableLineRanges(match, new LineRanges(newRanges).flatten().ranges);
    }

    protected MatchableLineRanges getPrevLines(List<Section> sections, int from, int to) {
        LineRanges newRanges = new LineRanges();
        boolean match = false;
        Section prevSection = null;
        for (Section section : sections) {
            Hunk hunk = section.getHunk();
            if (!(hunk.getTo() + hunk.getToCount() - 1 >= from || hunk.getTo() + hunk.getToCount() == from && hunk.isDelete())) {
                prevSection = section;
                continue;
            }
            if (!(hunk.getTo() <= to || hunk.getTo() == to + 1 && hunk.isDelete())) {
                prevSection = section;
                continue;
            }
            int fromStart = this.getFromLineNumberEquiv(prevSection, section, from);
            int fromEnd = this.getFromLineNumberEquiv(prevSection, section, to);
            if (hunk.getTo() == to + 1 && hunk.isDelete()) {
                fromEnd = hunk.getFrom() + hunk.getFromCount() - 1;
            }
            int fromLength = fromEnd - fromStart + 1;
            if (section.isDiff()) {
                match = true;
            }
            newRanges.addRanges(this.getPrevLines(prevSection, section, fromStart, fromLength));
            prevSection = section;
        }
        return new MatchableLineRanges(match, newRanges.flatten());
    }

    protected LineRanges getPrevLines(Section prevSection, Section section, int fromStart, int fromLength) {
        LineRanges newRanges = new LineRanges();
        if (fromLength == 0) {
            return newRanges;
        }
        Hunk hunk = section.getHunk();
        int newFrom = -1;
        int newTo = -2;
        if (!section.isCommonSubsequence() && hunk.getFromCount() != 0) {
            if (fromStart <= hunk.getFrom() + hunk.getFromCount() - 1 && fromStart + fromLength - 1 >= hunk.getFrom()) {
                newRanges.addRange(hunk.getFrom(), hunk.getFrom() + hunk.getFromCount() - 1);
            }
        } else if (section.isCommonSubsequence()) {
            newFrom = Math.max(hunk.getFrom(), fromStart);
            newTo = Math.min(hunk.getFrom() + hunk.getFromCount() - 1, fromStart + fromLength - 1);
        }
        if (this.hunksAreOffByOne && prevSection != null) {
            if (prevSection.getHunk().isAdd()) {
                ++newTo;
            } else if (prevSection.getHunk().isDelete()) {
                --newTo;
            }
        }
        if (newFrom <= newTo) {
            newRanges.addRange(newFrom, newTo);
        }
        return newRanges;
    }
}

