/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.selectionhistory;

import com.atlassian.fisheye.dag.GraphIterator;
import com.atlassian.fisheye.dag.GraphUtils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.selectionhistory.LineRanges;
import com.cenqua.fisheye.rep.selectionhistory.MatchableLineRanges;
import com.cenqua.fisheye.rep.selectionhistory.PerLineHistoryDiffHelper;
import com.cenqua.fisheye.rep.selectionhistory.PerLineHistoryResult;
import com.cenqua.fisheye.util.Pair;
import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PerLineHistoryCalculator {
    @Resource
    private final PerLineHistoryDiffHelper diffHelper;

    @Autowired
    public PerLineHistoryCalculator(PerLineHistoryDiffHelper diffHelper) {
        this.diffHelper = diffHelper;
    }

    public List<PerLineHistoryResult.Revision> getRevisions(RepositoryEngine engine, Path path, String revision, int fromLine, int toLine) throws IOException {
        RevisionCache<? extends ChangeSet> revisionCache = engine.getRevisionCache();
        ArrayList<Entry> toProcess = new ArrayList<Entry>();
        FileRevision initialFileRev = revisionCache.findFileRevision(path, revision);
        MatchableLineRanges initialLines = new MatchableLineRanges(false, new LineRanges(fromLine, toLine));
        Entry initialEntry = new Entry(initialFileRev, this.getAncestorMap(initialFileRev, initialLines, revisionCache), initialLines);
        toProcess.add(initialEntry);
        NodeProvider nextNodeProvider = new NodeProvider(revisionCache);
        GraphIterator<Entry> iterator = GraphUtils.iterateBreadthFirst(toProcess, nextNodeProvider, new Function<Entry, Object>(){

            public Object apply(Entry entry) {
                return entry.fileRevision.getRevision();
            }
        });
        PerLineHistoryResult result = new PerLineHistoryResult();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.previousLines.isTooFarFromSelection(fromLine, toLine) || entry.previousLines.isEmpty()) {
                iterator.prune();
            }
            if (entry.fileRevision.getAncestors().isEmpty()) {
                result.addResult(new PerLineHistoryResult.Revision(entry.fileRevision, true, entry.previousLines.getMin()));
                continue;
            }
            for (FileRevision ancestor : entry.ancestors.keySet()) {
                int selectedLine;
                MatchableLineRanges currentLines = (MatchableLineRanges)entry.ancestors.get(ancestor);
                int n2 = selectedLine = !currentLines.isEmpty() ? currentLines.getMin() : entry.previousLines.getMin();
                PerLineHistoryResult.Revision match = this.getResultToAdd(entry.fileRevision, currentLines, fromLine, toLine, selectedLine);
                if (match == null) continue;
                result.addResult(match);
            }
        }
        return result;
    }

    public PerLineHistoryResult.Revision getResultToAdd(FileRevision revision, MatchableLineRanges matchingLines, int initialFrom, int initialTo, int selectedLine) {
        if (matchingLines.isTooFarFromSelection(initialFrom, initialTo)) {
            return new PerLineHistoryResult.Revision(revision, false, selectedLine);
        }
        if (matchingLines.isMatch()) {
            return new PerLineHistoryResult.Revision(revision, true, selectedLine);
        }
        return null;
    }

    private Map<FileRevision, MatchableLineRanges> getAncestorMap(FileRevision fileRevision, MatchableLineRanges currentLines, RevisionCache<? extends ChangeSet> revisionCache) {
        HashMap<FileRevision, MatchableLineRanges> ancestorMap = new HashMap<FileRevision, MatchableLineRanges>();
        for (RevInfoKey revInfoKey : fileRevision.getAncestors()) {
            FileRevision ancestor = revisionCache.getFileRevision(revInfoKey);
            if (ancestor != null) {
                if (fileRevision.getDiffRevision().equals(revInfoKey)) {
                    ancestorMap.put(ancestor, this.diffHelper.getPrevLines(this.diffHelper.getPaddedSections(fileRevision.getHunks(), currentLines.getMax()), (LineRanges)currentLines));
                    continue;
                }
                int lineCountDifference = fileRevision.getLineCount() - ancestor.getLineCount();
                MatchableLineRanges newLines = new MatchableLineRanges(currentLines.isMatch(), currentLines);
                for (Pair range : currentLines.ranges) {
                    if (lineCountDifference < 0) {
                        newLines.addRange((Integer)range.getSecond(), (Integer)range.getSecond() + Math.abs(lineCountDifference));
                        continue;
                    }
                    if (lineCountDifference <= 0) continue;
                    newLines.addRange((Integer)range.getFirst() - lineCountDifference, (Integer)range.getFirst());
                }
                ancestorMap.put(ancestor, newLines);
                continue;
            }
            Logs.APP_LOG.debug((Object)("Possibly something wrong here - revision was not found: " + revInfoKey));
        }
        return ancestorMap;
    }

    public class NodeProvider
    implements Function<Entry, Collection<Entry>> {
        private RevisionCache<? extends ChangeSet> revisionCache;

        public NodeProvider(RevisionCache<? extends ChangeSet> revisionCache) {
            this.revisionCache = revisionCache;
        }

        public Collection<Entry> apply(Entry entry) {
            ArrayList<Entry> nextNodes = new ArrayList<Entry>();
            RevInfoKey rik = entry.fileRevision.getRevInfoKey();
            FileRevision currentFileRevision = this.revisionCache.getFileRevision(rik);
            if (currentFileRevision == null) {
                Logs.APP_LOG.warn((Object)("Revision not found: " + rik));
                return Collections.emptyList();
            }
            if (!entry.ancestors.isEmpty()) {
                return this.getNextNodes(entry);
            }
            return nextNodes;
        }

        private List<Entry> getNextNodes(Entry entry) {
            ArrayList<Entry> nextNodes = new ArrayList<Entry>();
            for (FileRevision ancestor : entry.ancestors.keySet()) {
                MatchableLineRanges currentLines = (MatchableLineRanges)entry.ancestors.get(ancestor);
                Entry newEntry = new Entry(ancestor, PerLineHistoryCalculator.this.getAncestorMap(ancestor, currentLines, this.revisionCache), currentLines);
                nextNodes.add(newEntry);
            }
            return nextNodes;
        }
    }

    public class Entry {
        private final FileRevision fileRevision;
        private final Map<FileRevision, MatchableLineRanges> ancestors;
        private final MatchableLineRanges previousLines;

        public Entry(FileRevision fileRevision, Map<FileRevision, MatchableLineRanges> ancestors, MatchableLineRanges previousLines) {
            this.fileRevision = fileRevision;
            this.ancestors = ancestors;
            this.previousLines = previousLines;
        }
    }
}

