/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.selectionhistory;

import com.cenqua.fisheye.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LineRanges {
    protected List<Pair<Integer, Integer>> ranges;

    public LineRanges(int singleLine) {
        this(Arrays.asList(Pair.newInstance(singleLine, singleLine)));
    }

    public LineRanges(int from, int to) {
        this(Arrays.asList(Pair.newInstance(from, to)));
    }

    public LineRanges() {
        this(new ArrayList<Pair<Integer, Integer>>());
    }

    public LineRanges(List<Pair<Integer, Integer>> ranges) {
        this.ranges = new ArrayList<Pair<Integer, Integer>>(ranges);
    }

    public int getMin() {
        int min = -1;
        for (Pair<Integer, Integer> range : this.ranges) {
            if (min != -1 && range.getFirst() >= min) continue;
            min = range.getFirst();
        }
        return min;
    }

    public int getMax() {
        int max = -1;
        for (Pair<Integer, Integer> range : this.ranges) {
            if (range.getSecond() <= max) continue;
            max = range.getSecond();
        }
        return max;
    }

    public LineRanges flatten() {
        int max = this.getMax();
        boolean[] lines = new boolean[max + 1];
        for (Pair<Integer, Integer> pair : this.ranges) {
            for (int i2 = pair.getFirst().intValue(); i2 <= pair.getSecond(); ++i2) {
                lines[i2] = true;
            }
        }
        LineRanges newRanges = new LineRanges();
        boolean newRange = true;
        int min = 0;
        for (int i3 = 0; i3 < max + 1; ++i3) {
            if (lines[i3] && newRange) {
                min = i3;
                newRange = false;
                if (i3 != max) continue;
                newRanges.addRange(min, i3);
                continue;
            }
            if (newRange) continue;
            if (!lines[i3]) {
                newRanges.addRange(min, i3 - 1);
                newRange = true;
                continue;
            }
            if (i3 != max) continue;
            newRanges.addRange(min, i3);
            newRange = true;
        }
        return newRanges;
    }

    public boolean isTooFarFromSelection(int originalFrom, int originalTo) {
        int originalCount = Math.max(originalTo - originalFrom, 10);
        int newCount = this.getMax() - this.getMin();
        return newCount > originalCount * 3;
    }

    public List<Pair<Integer, Integer>> getRanges() {
        return this.ranges;
    }

    public void addRange(int from, int to) {
        this.ranges.add(Pair.newInstance(from, to));
    }

    public void addRanges(LineRanges ranges) {
        for (Pair<Integer, Integer> range : ranges.ranges) {
            this.addRange(range.getFirst(), range.getSecond());
        }
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }
}

