/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.util.Disposer;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class RescanRequest
extends PingRequest {
    private static final int RESCAN_WAIT_TIME = 100000;
    private String start;
    private String end;
    private static final Set<ScmType> RESCANNABLE_TYPES = EnumSet.of(ScmType.SVN, ScmType.P4);

    public RescanRequest(RepositoryHandle handle, String startRev, String endRev) {
        super(handle);
        ScmType repoType = handle.getCfg().getRepositoryType();
        if (!RESCANNABLE_TYPES.contains((Object)repoType)) {
            throw new UnsupportedOperationException("Rescan is not supported on " + (Object)((Object)repoType) + " repositories");
        }
        this.start = startRev;
        this.end = endRev;
    }

    @Override
    public boolean canCombine(PingRequest request) {
        boolean canCombine = false;
        if (request.getClass() == this.getClass()) {
            RescanRequest rescanRequest = (RescanRequest)request;
            canCombine = rescanRequest.getStart().equals(this.start) && rescanRequest.getEnd().equals(this.end);
        }
        return canCombine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRequest() {
        RepositoryHandle handle = this.getHandle();
        if (handle.isRunning()) {
            Disposer.pushThreadInstance();
            try {
                if (!handle.accessRepository(100000L)) {
                    Logs.APP_LOG.warn((Object)"Unable to update revisions as repository is busy with another operation");
                } else {
                    RepositoryEngine eng = handle.acquireEngine();
                    String messages = eng.rescan(this.start, this.end);
                    if (!StringUtils.isEmpty((String)messages)) {
                        Logs.APP_LOG.info((Object)messages);
                    }
                }
            }
            catch (Throwable e2) {
                Logs.APP_LOG.error((Object)"Exception during rescan", e2);
            }
            finally {
                try {
                    handle.releaseRepository();
                }
                finally {
                    Disposer.popThreadInstance();
                }
            }
        }
    }

    @Override
    public String getDescription() {
        return "Rescan from " + this.start + " to " + this.end;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }
}

