/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.NamedExecution;
import java.util.ArrayList;
import java.util.List;

public abstract class PingRequest {
    private RepositoryHandle handle;
    private final List<PingRequest> subRequests = new ArrayList<PingRequest>();
    protected final Runnable callback;

    protected PingRequest(RepositoryHandle handle) {
        this(handle, null);
    }

    protected PingRequest(RepositoryHandle handle, Runnable callback) {
        this.handle = handle;
        this.callback = callback;
    }

    public void combine(PingRequest request) {
        if (request.hasCallback() && request != this) {
            this.subRequests.add(request);
        }
    }

    public boolean hasCallback() {
        return this.callback != null;
    }

    private void done() {
        for (PingRequest subRequest : this.subRequests) {
            subRequest.done();
        }
        if (this.callback != null) {
            this.callback.run();
        }
    }

    public RepositoryHandle getHandle() {
        return this.handle;
    }

    public final void process() {
        new NamedExecution(this.getHandle().getName()).run(new Runnable(){

            @Override
            public void run() {
                PingRequest.this.doRequest();
                PingRequest.this.done();
            }
        });
    }

    public boolean canCombine(PingRequest request) {
        return request.getClass() == this.getClass() && request != this;
    }

    protected abstract void doRequest();

    public abstract String getDescription();
}

