/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.config1.ResourceCountType;
import com.cenqua.fisheye.config1.ResourcesType;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PingManager {
    private static final ThreadPoolExecutor incrementalExecutePool;
    private static final ThreadPoolExecutor initialExecutePool;
    private static final int DEFAULT_MAX_INDEX_THREADS = 3;
    private static int initialIndexingThreads;
    private static int incrementalIndexingThreads;

    private static ThreadPoolExecutor initExecutePool(String name) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        ConfigurableThreadFactory tf = new ConfigurableThreadFactory(name + "Ping", true);
        return new ThreadPoolExecutor(3, 3, 1L, TimeUnit.SECONDS, queue, tf);
    }

    public static void setThreadConfig(ResourcesType threads) {
        if (threads != null) {
            incrementalIndexingThreads = PingManager.setPoolLimits(incrementalExecutePool, threads.getIncrementalIndexThreads());
            initialIndexingThreads = PingManager.setPoolLimits(initialExecutePool, threads.getInitialIndexThreads());
        }
    }

    private static int setPoolLimits(ThreadPoolExecutor pool, ResourceCountType config) {
        int min = 1;
        int max = 3;
        if (config != null) {
            min = config.getMin().intValue();
            max = config.getMax().intValue();
        }
        if (min > max) {
            throw new IllegalArgumentException("Thread maximum " + max + " is less than the minimum " + min);
        }
        pool.setCorePoolSize(max);
        pool.setMaximumPoolSize(max);
        return max;
    }

    public static ThreadPoolExecutor getExecutor(boolean useInitialThreadPool) {
        ThreadPoolExecutor pool = useInitialThreadPool ? initialExecutePool : incrementalExecutePool;
        return pool;
    }

    public static int getInitialIndexingThreads() {
        return initialIndexingThreads;
    }

    static {
        initialIndexingThreads = 3;
        incrementalIndexingThreads = 3;
        incrementalExecutePool = PingManager.initExecutePool("Incr");
        initialExecutePool = PingManager.initExecutePool("Init");
    }
}

