/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.util.Disposer;

public class LinecountReindexRequest
extends PingRequest {
    public LinecountReindexRequest(RepositoryHandle handle) {
        super(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRequest() {
        RepositoryHandle handle = this.getHandle();
        if (handle.isRunning()) {
            Disposer.pushThreadInstance();
            try {
                RepositoryEngine eng = handle.acquireEngine();
                Logs.APP_LOG.debug((Object)("Processing linecount scan request for " + handle.getName()));
                eng.doLinecountReindex();
            }
            catch (Throwable e2) {
                Logs.APP_LOG.error((Object)"Exception during slurp", e2);
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    @Override
    public String getDescription() {
        return "FishEye Line Count Reindexing";
    }
}

