/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.StopRequestedException;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.util.Disposer;

public abstract class IndexingPingRequest
extends PingRequest {
    protected IndexingPingRequest(RepositoryHandle handle, Runnable callback) {
        super(handle, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRequest() {
        RepositoryHandle handle = this.getHandle();
        if (handle.isRunning()) {
            Disposer.pushThreadInstance();
            try {
                if (!handle.accessRepository(0L)) {
                    Logs.APP_LOG.info((Object)"Slurp abandoned as repository is currently locked by another operation");
                } else {
                    RepositoryEngine eng = handle.acquireEngine();
                    eng.slurp();
                }
            }
            catch (StopRequestedException e2) {
                Logs.APP_LOG.debug((Object)"Ping halted as repository is stopping");
            }
            catch (Throwable e3) {
                String message = "Exception during " + this.getDescription() + " of " + this.getHandle().getName() + ": " + e3;
                Logs.APP_LOG.warn((Object)message);
                Logs.APP_LOG.debug((Object)message, e3);
            }
            finally {
                try {
                    handle.releaseRepository();
                }
                finally {
                    Disposer.popThreadInstance();
                }
            }
        }
    }
}

