/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.IndexingPingRequest;
import com.cenqua.fisheye.rep.ping.PingRequest;

public class IncrementalPingRequest
extends IndexingPingRequest {
    private long lastStartTime = -1L;

    public IncrementalPingRequest(RepositoryHandle handle, Runnable callback) {
        super(handle, callback);
    }

    @Override
    public String getDescription() {
        return "FishEye Incremental Indexing";
    }

    public String toString() {
        return "Incremental Ping of " + this.getHandle().getName();
    }

    @Override
    public boolean canCombine(PingRequest request) {
        return false;
    }

    @Override
    public void doRequest() {
        this.lastStartTime = System.currentTimeMillis();
        super.doRequest();
    }

    public long getLastStartTime() {
        return this.lastStartTime;
    }

    public void resetLastStartTime() {
        this.lastStartTime = -1L;
    }
}

