/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.util.Disposer;

public class CrucibleIncrementalRequest
extends PingRequest {
    public CrucibleIncrementalRequest(RepositoryHandle handle) {
        super(handle);
    }

    protected CrucibleIncrementalRequest(RepositoryHandle handle, Runnable callback) {
        super(handle, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRequest() {
        RepositoryHandle handle = this.getHandle();
        if (handle.isRunning()) {
            Disposer.pushThreadInstance();
            try {
                RepositoryEngine eng = handle.acquireEngine();
                if (AppConfig.isCrucible() && HibernateUtil.isRunning() && !handle.getStatus().isStopRequested()) {
                    Logs.APP_LOG.debug((Object)("Processing Crucible scan request for " + handle.getName()));
                    eng.doReviewSlurp(this.isReindex());
                }
            }
            catch (Throwable e2) {
                Logs.APP_LOG.error((Object)"Exception during slurp", e2);
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    protected boolean isReindex() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Crucible Incremental Indexing";
    }
}

