/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.atlassian.fecru.util.EggTimer;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.CommonRepositoryScanner;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TotalHitCountCollector;

public class CrossRepositoryRescanRequest
extends PingRequest {
    private static final Set<String> REPOSITORIES_BEING_REINDEXED = Sets.newSetFromMap((Map)Maps.newConcurrentMap());
    private static final int RESCAN_TIME_LIMIT_MS = 30000;
    private final boolean forceReindex;

    public CrossRepositoryRescanRequest(RepositoryHandle handle, boolean forceReindex) {
        super(handle);
        this.forceReindex = forceReindex;
        REPOSITORIES_BEING_REINDEXED.add(handle.getName());
    }

    @Override
    protected void doRequest() {
        RepositoryHandle handle = this.getHandle();
        if (handle.isRunning()) {
            Logs.APP_LOG.debug((Object)("Starting cross-repository scan request for " + handle.getName()));
            try {
                boolean done = handle.withEngine(new Function<RepositoryEngine, Boolean>(){

                    public Boolean apply(RepositoryEngine engine) {
                        return CrossRepositoryRescanRequest.this.doCrossRepoRescanCheck(engine);
                    }
                });
                if (!done) {
                    Logs.APP_LOG.debug((Object)("Cross-repository rescan timeslice complete for " + handle.getName() + " - scheduling further work"));
                } else {
                    Logs.APP_LOG.debug((Object)("Cross-repository rescan complete for " + handle.getName()));
                }
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.debug((Object)"Trying to execute on an engine that's no longer running");
            }
            catch (Exception e3) {
                Logs.APP_LOG.error((Object)"Exception during cross-repository scan: ", (Throwable)e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCrossRepoRescanCheck(RepositoryEngine eng) throws DbException {
        CrossRepLuceneIndex crossRepoIndex = eng.getIndexingContext().getCrossRepLuceneIndex();
        RevisionCache<? extends ChangeSet> cache = eng.getRevisionCache();
        RepositoryStatus status = eng.getStatus();
        CommonRepositoryScanner scanner = eng.getScanner();
        CrossRepLuceneIndex.RescanStatus rescanStatus = crossRepoIndex.getRescanStatus(cache);
        if (!this.forceReindex && rescanStatus.isDone()) {
            REPOSITORIES_BEING_REINDEXED.remove(eng.getName());
            return true;
        }
        REPOSITORIES_BEING_REINDEXED.add(eng.getName());
        try {
            Long startChangeset;
            EggTimer timer = new EggTimer(30000L, TimeUnit.MILLISECONDS);
            if (this.forceReindex || rescanStatus.isSerialChanged()) {
                status.setMessage("Re-creating cross-repository index");
                crossRepoIndex.deleteRepFromIndex(eng.getName());
                if (timer.isTimeExpired() || status.isStopRequested()) {
                    crossRepoIndex.setRescanStatus(cache, null, false);
                    boolean bl = false;
                    return bl;
                }
            }
            if (rescanStatus.hasPre24Changesets() == null) {
                Boolean hasPre24Changesets = this.checkPre24Changesets(crossRepoIndex, cache.getRepositoryName());
                crossRepoIndex.setRescanStatus(cache, rescanStatus.getLastScannedChangeset(), hasPre24Changesets);
                rescanStatus = new CrossRepLuceneIndex.RescanStatus(rescanStatus.isSerialChanged(), hasPre24Changesets, rescanStatus.getLastScannedChangeset());
            }
            if (this.forceReindex || rescanStatus.getLastScannedChangeset() == null) {
                scanner.reindexChangesetComments(false);
            }
            Long endChangeset = null;
            if (!(status.isStopRequested() || (startChangeset = rescanStatus.getLastScannedChangeset() != null && !this.forceReindex ? Long.valueOf(rescanStatus.getLastScannedChangeset() - 1L) : null) != null && startChangeset <= -1L)) {
                endChangeset = scanner.reindexChangesets(startChangeset, timer);
            }
            if (endChangeset != null) {
                if (endChangeset == -1L) {
                    REPOSITORIES_BEING_REINDEXED.remove(eng.getName());
                    crossRepoIndex.setRescanStatus(cache, endChangeset, false);
                    status.setMessage("Cross-repository sync complete");
                    boolean bl = true;
                    return bl;
                }
                crossRepoIndex.setRescanStatus(cache, endChangeset, rescanStatus.hasPre24Changesets());
            }
        }
        finally {
            status.setMessage("");
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Cross-repository index updating";
    }

    private Boolean checkPre24Changesets(CrossRepLuceneIndex crossRepoIndex, final String repository) {
        return crossRepoIndex.getConnection().withIndexReader(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexReaderAction<Boolean>(){

            @Override
            public Boolean perform(IndexReader indexReader) throws IOException, DbException {
                IndexSearcher searcher = new IndexSearcher(indexReader);
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.search(((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(repository).changesetsOnly()).build(), ChangesetQueryBuilder.noCrossRepoIdFilter(), (Collector)collector);
                return collector.getTotalHits() > 0;
            }
        });
    }

    public static boolean isRepositoryBeingReindexed(String repositoryName) {
        return REPOSITORIES_BEING_REINDEXED.contains(repositoryName);
    }
}

