/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.J;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.Locale;

public class UpgradeSuffixPathIndex {
    private final String repname;
    private final RepositoryStatus status;
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;
    private final boolean caseSensitive;

    public UpgradeSuffixPathIndex(String repname, RepositoryStatus status, InfinityDbHandle dbh, CommonStringTables stringTables, boolean caseSensitive) {
        this.repname = repname;
        this.status = status;
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.caseSensitive = caseSensitive;
    }

    public void upgradeIfNecessary() throws DbException {
        ac db = this.dbh.get();
        try {
            y cu = y.a();
            cu.f().a(CommonSchema.E_SUFFIXPATHS);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                return;
            }
            Logs.APP_LOG.info((Object)("[" + this.repname + "] upgrading suffix path indexes."));
            this.upgrade(db);
            this.dbh.commit();
        }
        catch (IOException e2) {
            try {
                this.dbh.rollback();
            }
            catch (IOException e22) {
                Logs.APP_LOG.warn((Object)"Failed to rollback after failing to upgrade suffix paths", (Throwable)e22);
            }
            throw new DbException(e2);
        }
    }

    private long addSuffixId(Path path) throws DbException {
        long pathId = this.caseSensitive ? this.stringTables.suffixDB.add(path.getPath()) : this.stringTables.suffixDB.add(path.getPath().toLowerCase(Locale.US));
        return pathId;
    }

    private void upgrade(ac db) throws IOException, DbException {
        this.status.setMessage("Upgrading suffix path indexes...");
        Logs.APP_LOG.info((Object)("[" + this.repname + "] Upgrading suffix path indexes..."));
        long t0 = System.currentTimeMillis();
        J paths = new J(db, y.a(CommonSchema.E_PATH_ID_TO_REVID));
        y cu = y.a();
        y newrow = y.a();
        long done = 0L;
        while (paths.d(cu)) {
            int pathid = (int)cu.v(0);
            Path path = new Path(this.stringTables.pathDB.get(pathid));
            if (path != null) {
                do {
                    long suffixid = this.addSuffixId(path);
                    newrow.f();
                    newrow.a(CommonSchema.E_SUFFIXPATHS_TO_PATHID);
                    newrow.b(suffixid).b((long)pathid);
                    db.b(newrow);
                } while (!(path = path.getTailPath()).isRoot());
            }
            int trunc = cu.w(0);
            cu.d(trunc).j();
            if (++done % 100L != 0L) continue;
            this.status.setMessage("Upgrading suffix path indexes... (" + done + " paths so far)");
        }
        long t1 = System.currentTimeMillis();
        Logs.APP_LOG.info((Object)("[" + this.repname + "] Upgraded suffix path indexes in " + (t1 - t0) + "ms"));
    }
}

