/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.git.GitCache;
import com.atlassian.fisheye.git.db.GitChangeSet;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.BaseUpgradeTask;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.util.EmailUtil;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class UpgradeGitAuthorNames
extends BaseUpgradeTask {
    private static final int CHANGESET_BATCHSIZE = 100;
    private ChangesetIndexer csIndexer = new ChangesetIndexer();

    @Override
    protected int getTargetedSchemaVersion(ScmType scmType) {
        return scmType == ScmType.GIT ? 11 : -1;
    }

    @Override
    protected String getTaskId() {
        return "UpgradeGitAuthorNames-1";
    }

    @Override
    protected void doUpgrade(RepositoryEngine engine, RepositoryStatus status) throws DbException {
        status.setMessage("Upgrading git committer names");
        GitCache gitCache = (GitCache)engine.getInternalRevisionCache();
        LicenseEnforcer enforcer = gitCache.getLicenseEnforcer();
        InfinityDbHandle dbh = gitCache.getInfDb();
        int originalCommitterCount = 0;
        if (enforcer.isCommitterLimitEnforced()) {
            originalCommitterCount = enforcer.getCommitterCount(dbh);
        }
        Map<String, String> authorNameUpdateMap = this.updateFileRevisions(gitCache);
        this.updateEmptyChangesets(gitCache, authorNameUpdateMap);
        if (enforcer.isCommitterLimitEnforced()) {
            enforcer.reInitialize();
            int newCommitterCount = enforcer.getCommitterCount(dbh);
            if (newCommitterCount > originalCommitterCount) {
                try {
                    enforcer.validateCommitterLimit(null, dbh);
                    Logs.APP_LOG.info((Object)("Upgrading the Git committer names has increased the number of committers in the repository from " + originalCommitterCount + " to " + newCommitterCount));
                }
                catch (LicensePolicyException e2) {
                    Logs.APP_LOG.warn((Object)("**** Upgrading the Git committer names has caused your repository to exceed your license limits. Please refer to " + LicenseEnforcer.DVCS_DETAILS_LINK + " for more information****"));
                }
            }
        }
    }

    private void updateEmptyChangesets(final GitCache cache, final Map<String, String> authorNameUpdateMap) {
        final AtomicBoolean reindexRequired = new AtomicBoolean(false);
        Iterator allChangeSets = cache.getChangeSetDAO().getChangeSets().iterator();
        UnmodifiableIterator changesetsForUpdate = Iterators.filter((Iterator)allChangeSets, (Predicate)new Predicate<GitChangeSet>(){

            public boolean apply(@Nullable GitChangeSet cs) {
                return cs.getRevisionInfosCount() == 0 && authorNameUpdateMap.containsKey(cs.getAuthor());
            }
        });
        Iterator updatedChangesets = Iterators.transform((Iterator)changesetsForUpdate, (Function)new Function<GitChangeSet, GitChangeSet>(){

            public GitChangeSet apply(@Nullable GitChangeSet cs) {
                cs.setAuthor((String)authorNameUpdateMap.get(cs.getAuthor()));
                cache.getChangeSetDAO().storeWithoutLimits(cs);
                reindexRequired.set(true);
                return cs;
            }
        });
        this.csIndexer.indexChangesetsAndAuthors(cache.getCrossRepLuceneConnection(), updatedChangesets, null, true, null, false);
        if (reindexRequired.get()) {
            this.forceMetadataReindex(cache);
        }
    }

    private Map<String, String> updateFileRevisions(GitCache cache) {
        HashMap<String, String> authorNameUpdateMap = new HashMap<String, String>();
        boolean reindexRequired = false;
        ac db = cache.getInfDb().get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.RevInfo.ENTITY);
            int fileRevIteratorLength = cu.e();
            String oldCsid = null;
            HashMap<String, GitChangeSet> updatedChangeSets = new HashMap<String, GitChangeSet>();
            while (db.a(cu, fileRevIteratorLength)) {
                int revid = (int)cu.v(fileRevIteratorLength);
                int fileRevOffset = cu.w(fileRevIteratorLength);
                cu.d(fileRevOffset).a(CommonSchema.RevInfo.A_AUTHOR);
                int authorKeyLen = cu.e();
                if (db.a(cu, authorKeyLen)) {
                    String emailAddress;
                    String oldAuthor = cu.m(authorKeyLen);
                    cu.d(fileRevOffset).a(DvcsSchema.Git.A_EMAIL);
                    int emailKeyLen = cu.e();
                    if (db.a(cu, emailKeyLen) && StringUtils.isNotBlank((String)(emailAddress = cu.m(emailKeyLen)))) {
                        String csid;
                        String newAuthor = oldAuthor + " " + EmailUtil.wrapEmail(emailAddress);
                        if (!oldAuthor.contains(emailAddress)) {
                            cu.d(fileRevOffset).a(CommonSchema.RevInfo.A_AUTHOR);
                            cu.b(newAuthor);
                            db.e(cu, authorKeyLen);
                            authorNameUpdateMap.put(oldAuthor, newAuthor);
                            this.updateAuthorRevidMapping(db, oldAuthor, newAuthor, revid);
                            reindexRequired = true;
                        }
                        cu.d(fileRevOffset).a(CommonSchema.RevInfo.A_CSID);
                        int csidLen = cu.e();
                        if (db.a(cu, csidLen) && !(csid = cu.m(csidLen)).equals(oldCsid)) {
                            GitChangeSet cs = (GitChangeSet)cache.getChangeSet(csid);
                            if (!cs.getAuthor().contains(emailAddress)) {
                                cs.setAuthor(newAuthor);
                                cache.getChangeSetDAO().storeWithoutLimits(cs);
                                updatedChangeSets.put(csid, cs);
                                if (updatedChangeSets.size() > 100) {
                                    this.indexChangesets(cache, updatedChangeSets);
                                    updatedChangeSets.clear();
                                }
                                reindexRequired = true;
                            }
                            oldCsid = csid;
                        }
                    }
                }
                cu.d(fileRevOffset).j();
            }
            this.indexChangesets(cache, updatedChangeSets);
            if (reindexRequired) {
                this.forceMetadataReindex(cache);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
        return authorNameUpdateMap;
    }

    private void indexChangesets(GitCache cache, Map<String, GitChangeSet> updatedChangeSets) {
        this.csIndexer.indexChangesetsAndAuthors(cache.getCrossRepLuceneConnection(), updatedChangeSets.values().iterator(), null, true, null, false);
    }

    private void forceMetadataReindex(GitCache cache) {
        long currentVersion = cache.getMetadataVersion();
        if (currentVersion == 29L) {
            cache.setMetadataVersion(currentVersion - 1L);
        }
    }

    private void updateAuthorRevidMapping(ac db, String oldAuthor, String newAuthor, int revid) {
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_AUTHOR_TO_REVID);
            cu.b(oldAuthor.toLowerCase(Locale.US));
            cu.b((long)revid);
            db.c(cu);
            cu.f().a(CommonSchema.E_AUTHOR_TO_REVID);
            cu.b(newAuthor.toLowerCase(Locale.US));
            cu.b((long)revid);
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }
}

