/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.J;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.Locale;

public class UpgradeDataFilenameSearch {
    private final String repname;
    private final RepositoryStatus status;
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;
    private boolean caseSensitive;
    private BlameAndLinecountCalculator blameAndLinecountCalculator;

    public UpgradeDataFilenameSearch(String repname, RepositoryStatus status, InfinityDbHandle dbh, CommonStringTables stringTables, boolean caseSensitive, BlameAndLinecountCalculator blameAndLinecountCalculator) {
        this.repname = repname;
        this.status = status;
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.caseSensitive = caseSensitive;
        this.blameAndLinecountCalculator = blameAndLinecountCalculator;
    }

    public void upgradeIfNecessary() throws DbException {
        ac db = this.dbh.get();
        try {
            y cu = y.a();
            cu.f().a(CommonSchema.E_LCFILENAMEID_TO_REVID);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                return;
            }
            Logs.APP_LOG.info((Object)("[" + this.repname + "] upgrading quicksearch data."));
            this.upgrade(db);
            this.dbh.commit();
        }
        catch (IOException e2) {
            try {
                this.dbh.rollback();
            }
            catch (IOException e22) {
                Logs.APP_LOG.warn((Object)("Failed to rollback after failing to upgrade quicksearch data of repository" + this.repname), (Throwable)e22);
            }
            throw new DbException(e2);
        }
    }

    public void initAndUpgradeBuckets(RevisionCache cache) throws DbException {
        BucketGraph bucketGraph = new BucketGraph(this.dbh, this.repname, this.caseSensitive, this.stringTables, cache);
        if (!bucketGraph.isAtCurrentVersion()) {
            Logs.APP_LOG.debug((Object)("Repository " + this.repname + ": Started upgrading linecount database"));
            bucketGraph.reindex(this.blameAndLinecountCalculator, this.status);
            Logs.APP_LOG.debug((Object)("Repository " + this.repname + ": Finished upgrading linecount database"));
            String dbTimezone = bucketGraph.loadTimeZone();
            String serverTimezone = AppConfig.getsConfig().getTimezone().getID();
            if (!dbTimezone.equals(serverTimezone)) {
                Logs.APP_LOG.info((Object)("Repository " + this.repname + ": Linecount database is calculated in " + dbTimezone + " time, " + "while the default timezone of the server is " + serverTimezone + ".  " + "When it is next recalculated the linecount database will use the server's timezone."));
            }
        } else {
            this.blameAndLinecountCalculator.calcBlame(false);
        }
    }

    private void upgrade(ac db) throws IOException, DbException {
        this.status.setMessage("Upgrading quicksearch cache...");
        Logs.APP_LOG.info((Object)("Repository " + this.repname + ": Upgrading filename search data..."));
        long t0 = System.currentTimeMillis();
        J revs = new J(db, y.a(CommonSchema.RevInfo.ENTITY));
        y cu = y.a();
        y row = y.a();
        y newrow = y.a();
        while (revs.d(cu)) {
            long pathid;
            String path;
            int revid = (int)cu.v(0);
            row.f();
            row.a(CommonSchema.RevInfo.ENTITY).b((long)revid).a(CommonSchema.RevInfo.A_REVKEY);
            int pl = row.e();
            if (!db.a(row, pl) || (path = this.stringTables.pathDB.get(pathid = row.v(pl))) == null) continue;
            String lcfilename = Path.parseName(path).toLowerCase(Locale.US);
            long lcfilenameid = this.stringTables.lcfilenameDB.add(lcfilename);
            newrow.f();
            newrow.a(CommonSchema.E_LCFILENAMEID_TO_REVID).b(lcfilenameid).b((long)revid);
            db.b(newrow);
        }
        long t1 = System.currentTimeMillis();
        Logs.APP_LOG.info((Object)("Repository " + this.repname + ": Upgraded filename search data in " + (t1 - t0) + "ms"));
    }
}

