/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.dvcs.DvcsCache;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.atlassian.fisheye.svn.Svn2AncestryUpgrader;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.cvsrep.cache.CvsChangeSetAncestryProcessor;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.P4ChangeSetAncestryProcessor;
import com.cenqua.fisheye.rep.AncestryUpgrader;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.MutableChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.BaseUpgradeTask;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.TopologicalOrderChangesetIterator;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;

public class UpgradeChangesetAncestry
extends BaseUpgradeTask {
    private static final p[] DVCS_ATTRIBUTES_TO_CLEAR = new p[]{CommonSchema.ChangeSetInfo.A_NEXT_COMMITS, CommonSchema.ChangeSetInfo.A_ON_BRANCH, CommonSchema.ChangeSetInfo.A_POSITION};
    private static final p[] NON_DVCS_ATTRIBUTES_TO_CLEAR = new p[]{CommonSchema.ChangeSetInfo.A_NEXT_COMMITS, CommonSchema.ChangeSetInfo.A_ON_BRANCH, CommonSchema.ChangeSetInfo.A_POSITION, CommonSchema.ChangeSetInfo.A_PARENTS, CommonSchema.ChangeSetInfo.A_TAGS};
    private static final int UPDATE_STATUS_PERIOD_MILLIS = 10000;
    private static final int LOG_INFO_PERIOD_MILLIS = 600000;
    private static final String TASK_ID = "upgrade-changeset-ancestry-3";

    @Override
    protected int getTargetedSchemaVersion(ScmType scmType) {
        switch (scmType) {
            case CVS: {
                return 13;
            }
            case SVN: {
                return 23;
            }
            case P4: {
                return 3;
            }
            case HG: {
                return 3;
            }
            case GIT: {
                return 11;
            }
        }
        return -1;
    }

    @Override
    protected String getTaskId() {
        return TASK_ID;
    }

    @Override
    protected void doUpgrade(RepositoryEngine engine, RepositoryStatus status) throws DbException {
        Timer timer = new Timer("Running upgrade-changeset-ancestry-3");
        this.moveInfDbTables(engine.getInternalRevisionCache());
        timer.mark("finished moving tables");
        this.upgradeChangesets(engine, status);
        timer.mark("finished upgrading changesets");
        if (engine.getInternalRevisionCache().getRepositoryType() == ScmType.GIT) {
            this.upgradeBranchAncestry(engine.getInternalRevisionCache());
            timer.mark("finished upgrading branch ancestry");
        }
        timer.end();
    }

    private void moveInfDbTables(InternalRevisionCache cache) throws DbException {
        if (cache.getRepositoryType() == ScmType.GIT || cache.getRepositoryType() == ScmType.HG) {
            ac db = cache.getInfDb().get();
            this.moveTable(db, DvcsSchema.DEPRECATED_E_COMMIT_CHILDREN, CommonSchema.E_CHANGESET_CHILDREN);
            this.moveTable(db, DvcsSchema.DEPRECATED_E_COMMIT_PARENTS, CommonSchema.E_CHANGESET_PARENTS);
            this.moveTable(db, DvcsSchema.DEPRECATED_E_TAG_HEADS, CommonSchema.E_TAG_HEADS);
            this.moveTable(db, DvcsSchema.DEPRECATED_E_BRANCH, CommonSchema.E_BRANCH);
            this.moveAttribute(db, DvcsSchema.DvcsChangeSetInfo.DEPRECATED_A_PARENTS, CommonSchema.ChangeSetInfo.A_PARENTS, CommonSchema.ChangeSetInfo.ENTITY);
            this.moveAttribute(db, DvcsSchema.DvcsChangeSetInfo.DEPRECATED_A_TAGS, CommonSchema.ChangeSetInfo.A_TAGS, CommonSchema.ChangeSetInfo.ENTITY);
        }
    }

    private void upgradeChangesets(RepositoryEngine engine, RepositoryStatus status) throws DbException {
        try {
            InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
            ac db = cache.getInfDb().get();
            super.clearTable(db, CommonSchema.E_BRANCH_TO_POSITION);
            super.clearTable(db, CommonSchema.E_POSITION_TO_CHANGESET);
            super.clearTable(db, CommonSchema.E_BRANCH_TO_DESCENDANT_CS_POSITION);
            if (cache.getRepositoryType() != ScmType.GIT && cache.getRepositoryType() != ScmType.HG) {
                super.clearTable(db, CommonSchema.E_TAG_HEADS);
                super.clearTable(db, CommonSchema.E_CHANGESET_CHILDREN);
                super.clearTable(db, CommonSchema.E_CHANGESET_PARENTS);
            }
            this.clearAttributes(cache);
            AncestryUpgrader ancestryUpgrader = this.createAncestryProcessor(engine);
            TopologicalOrderChangesetIterator it = new TopologicalOrderChangesetIterator(cache);
            ChangeSetDAO<?, ?> csDAO = cache.getChangeSetDAO();
            long totalCSs = cache.countChangeSets(null, null);
            long lastStatus = 0L;
            long lastLog = 0L;
            long count = 0L;
            String lastTakeBackId = null;
            while (it.hasNext()) {
                MutableChangeSet cs = it.next();
                boolean loopInAncestryDetected = cs != null && cs.getId().equals(lastTakeBackId);
                lastTakeBackId = null;
                ++count;
                long time = System.currentTimeMillis();
                if (time - lastStatus > 10000L) {
                    lastStatus = time;
                    StringBuilder sb = new StringBuilder("Upgrading Ancestry for ChangeSet: ").append(cs == null ? "null" : cs.getDisplayId()).append(" (").append(count);
                    if (totalCSs == 0L) {
                        sb.append(" so far");
                    } else {
                        sb.append(" of ").append(totalCSs);
                    }
                    sb.append(")");
                    String string = sb.toString();
                    status.setMessage(string);
                    if (time - lastLog > 600000L) {
                        lastLog = time;
                        Logs.APP_LOG.info((Object)string);
                    }
                }
                if (cs == null) continue;
                if (ancestryUpgrader != null) {
                    ancestryUpgrader.doUpgrade(cs);
                }
                for (String string : cs.getParents()) {
                    if (!string.equals(cs.getId())) continue;
                    StringBuilder sb = new StringBuilder("Detected ChangeSet that is it's own parent!: ").append(cs.getDisplayId()).append(" pos:").append(cs.getPosition()).append("; parents:[");
                    for (String pa : cs.getParents()) {
                        sb.append(pa).append("; pos:").append(((ChangeSetImpl)csDAO.load(pa)).getPosition()).append(";");
                    }
                    sb.append("]");
                    Logs.APP_LOG.warn((Object)sb);
                }
                boolean isAllParentsProcessed = true;
                for (String parentId : cs.getParents()) {
                    Object parent = csDAO.load(parentId);
                    if (parent == null || parent.getPosition() != null) continue;
                    isAllParentsProcessed = false;
                    if (loopInAncestryDetected) continue;
                    it.takeBack(cs);
                    lastTakeBackId = cs.getId();
                    --count;
                    break;
                }
                if (loopInAncestryDetected) {
                    StringBuilder stringBuilder = new StringBuilder("Infinite Loop detected during upgrade of ChangeSet ancestry: ").append(cs.getId()).append(" pos:").append(cs.getPosition()).append("; parents:[");
                    for (String pa : cs.getParents()) {
                        stringBuilder.append(pa).append("; pos:").append(((ChangeSetImpl)csDAO.load(pa)).getPosition()).append(";");
                    }
                    stringBuilder.append("]: breaking: position may be incorrect for this ChangeSet");
                    Logs.APP_LOG.warn((Object)stringBuilder.toString());
                }
                if (!isAllParentsProcessed && !loopInAncestryDetected) continue;
                cs.setPosition(null);
                csDAO.store((ChangeSetImpl)cs);
            }
        }
        catch (LicensePolicyException e2) {
            throw new DbException(e2);
        }
    }

    private void clearAttributes(InternalRevisionCache cache) {
        p[] attributes = cache instanceof DvcsCache ? DVCS_ATTRIBUTES_TO_CLEAR : NON_DVCS_ATTRIBUTES_TO_CLEAR;
        ac infinityDB = cache.getInfDb().get();
        for (p a2 : attributes) {
            this.clearAttribute(infinityDB, a2, CommonSchema.ChangeSetInfo.ENTITY);
        }
    }

    private AncestryUpgrader createAncestryProcessor(RepositoryEngine engine) {
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        switch (cache.getRepositoryType()) {
            case SVN: {
                Svn2RepositoryEngine svnEngine = (Svn2RepositoryEngine)engine;
                return new Svn2AncestryUpgrader(svnEngine);
            }
            case P4: {
                return new P4AncestryUpgrader((P4Cache)cache);
            }
            case CVS: {
                return new CVSAncestryUpgrader((CvsCache)cache);
            }
        }
        return null;
    }

    private void upgradeBranchAncestry(InternalRevisionCache<? extends ChangeSet> cache) throws DbException {
        ChangeSetDAO<?, ?> csDAO = cache.getChangeSetDAO();
        for (Branch branch : cache.getBranches()) {
            csDAO.updateBranchAncestry(branch, branch);
        }
    }

    public static class CVSAncestryUpgrader
    implements AncestryUpgrader {
        private final CvsChangeSetAncestryProcessor ancestryProcessor;

        public CVSAncestryUpgrader(CvsCache cvsCache) {
            this.ancestryProcessor = new CvsChangeSetAncestryProcessor(cvsCache);
        }

        @Override
        public void doUpgrade(MutableChangeSet cs) throws LicensePolicyException {
            this.ancestryProcessor.process(cs);
        }
    }

    public static class P4AncestryUpgrader
    implements AncestryUpgrader {
        private final P4ChangeSetAncestryProcessor ancestryProcessor;

        P4AncestryUpgrader(P4Cache cache) {
            this.ancestryProcessor = new P4ChangeSetAncestryProcessor(cache);
        }

        @Override
        public void doUpgrade(MutableChangeSet cs) {
            this.ancestryProcessor.process(cs);
        }
    }
}

