/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.db.FileRevisionDAO;
import com.atlassian.fisheye.dvcs.db.DvcsSchema;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cvsrep.cache.infdb.EAV;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.BaseUpgradeTask;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpgradeChangeSetDB
extends BaseUpgradeTask {
    private static final String TASK_ID = "UpgradeChangeSetIndex-2";

    @Override
    protected String getTaskId() {
        return TASK_ID;
    }

    @Override
    protected int getTargetedSchemaVersion(ScmType scmType) {
        switch (scmType) {
            case CVS: {
                return 13;
            }
            case SVN: {
                return 23;
            }
            case P4: {
                return 3;
            }
            case HG: {
                return 1;
            }
            case GIT: {
                return 9;
            }
        }
        return -1;
    }

    @Override
    protected void doUpgrade(RepositoryEngine engine, RepositoryStatus status) throws DbException {
        status.setMessage("Upgrading ChangeSet DB");
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        Timer timer = new Timer("Upgrading changeset index for " + cache.getRepositoryName());
        UpgradeTask upgrade = new UpgradeTask((BaseRevisionCache)cache);
        try {
            upgrade.execute(cache);
        }
        catch (LicensePolicyException e2) {
            throw new DbException(e2);
        }
        timer.end();
    }

    private class UpgradeTask<F extends FileRevision, C extends ChangeSetImpl<F>, T extends CommonStringTables> {
        private ScmType scmType;
        private InfinityDbHandle dbh;
        private CommonRevInfoDAO commonDAO;
        private CommonStringTables stringTables;
        private ChangeSetDAO<F, C> csDAO;
        private FileRevisionDAO<F> fileRevDAO;

        public UpgradeTask(BaseRevisionCache<F, C, T> cache) throws DbException {
            this.scmType = cache.getRepositoryType();
            this.dbh = cache.getInfDb();
            this.commonDAO = cache.getCommonRevInfoDAO();
            this.stringTables = this.commonDAO.getStringTables();
            this.csDAO = cache.getChangeSetDAO();
            this.fileRevDAO = cache.getFileRevisionDAO();
        }

        public void execute(InternalRevisionCache cache) throws DbException, LicensePolicyException {
            this.prepareDB(cache.getInfDb().get());
            this.populateChangeSetDB();
            this.cleanupDB(cache.getInfDb().get());
            try {
                this.dbh.commit();
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }

        private boolean isDvcs() {
            return this.isGit() || this.isHg();
        }

        private boolean isGit() {
            return ScmType.GIT.equals((Object)this.scmType);
        }

        private boolean isHg() {
            return ScmType.HG.equals((Object)this.scmType);
        }

        private boolean isSvn() {
            return ScmType.SVN.equals((Object)this.scmType);
        }

        private boolean isCvs() {
            return ScmType.CVS.equals((Object)this.scmType);
        }

        private void populateChangeSetDB() throws DbException, LicensePolicyException {
            y cu = y.a().a(CommonSchema.E_CSID_TO_REVID);
            y cu2 = y.a();
            try {
                ac db = this.dbh.get();
                int pl = cu.e();
                int numCs = 0;
                while (db.a(cu, pl)) {
                    String csid = cu.m(pl);
                    cu2.f().a(CommonSchema.E_CSID_TO_REVID).b(csid);
                    long revid = -1L;
                    int revIdPl = cu2.e();
                    if (db.a(cu2, revIdPl)) {
                        revid = cu2.v(revIdPl);
                        C cs = this.csDAO.createChangeSet(csid);
                        this.populateChangeSet((ChangeSetImpl)cs, (int)revid);
                        this.csDAO.store(cs);
                        ++numCs;
                    } else {
                        Logs.APP_LOG.error((Object)("Could not upgrade changeset " + csid + "; no file revisions were found"));
                    }
                    cu.d(cu.n(pl));
                    cu.ak(pl);
                }
                Logs.APP_LOG.info((Object)("Upgraded " + numCs + " changesets"));
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            finally {
                y.c(cu);
                y.c(cu2);
            }
        }

        private void populateChangeSet(ChangeSetImpl cs, int revid) throws DbException {
            F revInfo = this.fileRevDAO.load(revid);
            cs.setAuthor(revInfo.getAuthor());
            cs.setComment(revInfo.getComment());
            cs.setDate(revInfo.getDate());
            if (this.isSvn()) {
                IntList revids = this.fileRevDAO.getChangeSetRevids(cs.getId());
                HashSet<String> branches = new HashSet<String>();
                for (Integer id : revids) {
                    branches.add(this.commonDAO.getBranchOf(id));
                }
                ArrayList<String> branchesList = new ArrayList<String>();
                branchesList.addAll(branches);
                cs.setBranches(branchesList);
            } else {
                cs.setBranch(revInfo.getBranch());
            }
            if (this.isDvcs()) {
                cs.setParents(this.getDvcsParents(cs.getId()));
                cs.setTags(this.getDvcsTags(cs.getId()));
            }
        }

        private List<String> getDvcsParents(String csid) throws DbException {
            y cu = y.a();
            ArrayList<String> parents = new ArrayList<String>();
            try {
                ac db = this.dbh.get();
                cu.a(DvcsSchema.DEPRECATED_E_COMMIT_PARENTS).b(csid);
                int pl = cu.e();
                while (db.a(cu, pl)) {
                    parents.add(cu.m(pl));
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            finally {
                y.c(cu);
            }
            return parents;
        }

        private Set<String> getDvcsTags(String csid) throws DbException {
            y cu = y.a();
            HashSet<String> tags = new HashSet<String>();
            try {
                ac db = this.dbh.get();
                cu.a(DvcsSchema.DEPRECATED_E_TAG_HEADS);
                int pl = cu.e();
                while (db.a(cu, pl)) {
                    long tagId = cu.v(pl);
                    cu.b(tagId);
                    int cspl = cu.e();
                    while (db.a(cu, cspl)) {
                        if (!csid.equals(cu.m(cspl))) continue;
                        tags.add(this.stringTables.tagDB.get(tagId));
                    }
                    cu.ak(pl);
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            finally {
                y.c(cu);
            }
            return tags;
        }

        private void prepareDB(ac db) throws DbException {
            if (this.isDvcs()) {
                UpgradeChangeSetDB.this.cloneTable(db, DvcsSchema.DEPRECATED_E_COMMIT_SHA1, CommonSchema.E_CHANGESET_IDS);
                UpgradeChangeSetDB.this.cloneTable(db, DvcsSchema.DEPRECATED_E_BRANCH_NAMES, CommonSchema.E_BRANCH_NAMES);
            }
            if (this.isCvs()) {
                UpgradeChangeSetDB.this.cloneTable(db, EAV.DEPRECATED_CHANGESET_ID_DB, CommonSchema.E_CHANGESET_IDS);
            }
        }

        private void cleanupDB(ac db) throws DbException {
            if (this.isDvcs()) {
                UpgradeChangeSetDB.this.clearTable(db, DvcsSchema.DEPRECATED_E_BRANCH_NAMES);
                UpgradeChangeSetDB.this.clearTable(db, DvcsSchema.DEPRECATED_E_COMMIT_SHA1);
            }
            if (this.isCvs()) {
                UpgradeChangeSetDB.this.clearTable(db, EAV.DEPRECATED_CHANGESET_ID_DB);
            }
        }
    }
}

