/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.BaseUpgradeTask;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class UpgradeBranchList
extends BaseUpgradeTask {
    private static final String TASK_ID = "UpgradeBranchList-3";

    @Override
    protected String getTaskId() {
        return TASK_ID;
    }

    @Override
    protected int getTargetedSchemaVersion(ScmType scmType) {
        switch (scmType) {
            case CVS: {
                return 13;
            }
            case SVN: {
                return 23;
            }
            case P4: {
                return 3;
            }
            case HG: {
                return -1;
            }
            case GIT: {
                return -1;
            }
        }
        return -1;
    }

    @Override
    protected void doUpgrade(RepositoryEngine engine, RepositoryStatus status) throws DbException {
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        status.setMessage("Upgrading Branch List");
        switch (cache.getRepositoryType()) {
            case SVN: 
            case P4: {
                this.upgradeBranchListFromDB(cache);
                break;
            }
            case CVS: {
                this.upgradeCVSBranchListFromDB(cache);
                break;
            }
        }
    }

    private void upgradeCVSBranchListFromDB(InternalRevisionCache cache) {
        ac db = cache.getInfDb().get();
        y cu = y.a().a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID);
        y cu2 = y.a();
        try {
            int keyLength1 = cu.e();
            while (db.a(cu, keyLength1)) {
                String branchName = cu.m(keyLength1);
                int keyLength2 = cu.n(keyLength1);
                if (!StringUtils.isBlank((String)branchName)) {
                    cu2.f().a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).b(branchName);
                    long latestDate = Long.MIN_VALUE;
                    String csid = null;
                    while (db.a(cu2, keyLength2)) {
                        int revid = (int)cu2.v(keyLength2);
                        FileRevision fileRev = cache.getFileRevision(revid);
                        if (fileRev.getDate() <= latestDate) continue;
                        csid = fileRev.getChangeSetId();
                        latestDate = fileRev.getDate();
                    }
                    if (csid != null) {
                        Branch branch = new Branch(branchName, csid, BranchState.ACTIVE);
                        ((BaseRevisionCache)cache).getBranchDAO().store(branch, false);
                    }
                }
                cu.d(keyLength2).j();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
            y.c(cu2);
        }
    }

    private void upgradeBranchListFromDB(InternalRevisionCache cache) {
        ac db = cache.getInfDb().get();
        y cu = y.a().a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID);
        try {
            int keyLength1 = cu.e();
            while (db.a(cu, keyLength1)) {
                String branchName = cu.m(keyLength1);
                int keyLength2 = cu.n(keyLength1);
                cu.d(keyLength2).j();
                if (!db.c(cu, keyLength2) || StringUtils.isBlank((String)branchName)) continue;
                int revid = (int)cu.v(keyLength2);
                FileRevision fileRev = cache.getFileRevision(revid);
                String csid = fileRev.getChangeSetId();
                Branch branch = new Branch(branchName, csid, BranchState.ACTIVE);
                ((BaseRevisionCache)cache).getBranchDAO().store(branch, false);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }
}

