/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.MutableChangeSet;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.NotImplementedException;

class TopologicalOrderChangesetIterator
implements Iterator<MutableChangeSet> {
    private LinkedList<MutableChangeSet> toProcess = new LinkedList();
    private Set<String> processedOrScheduled = new HashSet<String>();
    private ChangeSetDAO<?, ?> csDAO;
    private ac db;
    private y cuRevid;
    private int csRevIdOffset;
    private y cuDate;
    private int dateOffset;
    private y cuCSIter;
    private int cuCSIterOffset;
    private y cuCsid;
    private String repName;
    boolean doneFirstPass = false;
    private CommonStringTables stringTables;
    private final boolean useDateOrdering;

    public TopologicalOrderChangesetIterator(InternalRevisionCache<?> cache) {
        this(cache, cache.getRepositoryType() == ScmType.CVS);
    }

    public TopologicalOrderChangesetIterator(InternalRevisionCache<?> cache, boolean useDateOrdering) {
        this.useDateOrdering = useDateOrdering;
        this.csDAO = cache.getChangeSetDAO();
        this.db = cache.getInfDb().get();
        this.cuRevid = y.a(CommonSchema.RevInfo.ENTITY);
        this.csRevIdOffset = this.cuRevid.e();
        this.cuDate = y.a(CommonSchema.E_DATE_TO_REVID);
        this.dateOffset = this.cuDate.e();
        this.cuCSIter = y.a(CommonSchema.ChangeSetInfo.ENTITY);
        this.cuCSIterOffset = this.cuCSIter.e();
        this.cuCsid = y.a();
        this.repName = cache.getRepositoryName();
        this.stringTables = cache.getStringTables();
    }

    private void getNextChangeset() {
        try {
            if (!this.doneFirstPass) {
                if (this.useDateOrdering) {
                    this.getNextChangesetFromDateTable();
                } else {
                    this.getNextChangesetFromRevTable();
                }
                if (this.toProcess.isEmpty()) {
                    this.doneFirstPass = true;
                }
            }
            if (this.doneFirstPass) {
                this.getNextChangesetFromChangesetTable();
            }
        }
        catch (IOException ex) {
            throw new DbException(ex);
        }
    }

    private void getNextChangesetFromDateTable() throws IOException {
        while (this.toProcess.isEmpty()) {
            Long revid = this.getDateRevId();
            if (revid == null) {
                return;
            }
            this.addToQueue(revid);
        }
    }

    private Long getDateRevId() throws IOException {
        if (this.db.a(this.cuDate, this.dateOffset)) {
            int revIdOffset = this.cuDate.w(this.dateOffset);
            return this.cuDate.v(revIdOffset);
        }
        return null;
    }

    private void getNextChangesetFromRevTable() throws IOException {
        while (this.toProcess.isEmpty() && this.db.a(this.cuRevid, this.csRevIdOffset)) {
            long revId = this.cuRevid.v(this.csRevIdOffset);
            this.addToQueue(revId);
        }
    }

    private void getNextChangesetFromChangesetTable() throws IOException {
        while (this.toProcess.isEmpty() && this.db.a(this.cuCSIter, this.cuCSIterOffset)) {
            long id = this.cuCSIter.v(this.cuCSIterOffset);
            String csid = this.stringTables.changeSetIdDB.get(id);
            this.addToQueue(csid);
        }
    }

    private void addToQueue(long revId) {
        String csid = this.getCsIdforRevId(revId);
        if (csid != null) {
            this.addToQueue(csid);
        }
    }

    private void addToQueue(String csid) {
        if (!this.processedOrScheduled.contains(csid)) {
            this.processedOrScheduled.add(csid);
            Object cs = this.csDAO.load(csid);
            if (cs != null) {
                this.toProcess.add((MutableChangeSet)cs);
            } else {
                Logs.APP_LOG.warn((Object)("Couldn't find changeset " + csid + " in " + this.repName));
            }
        }
    }

    private String getCsIdforRevId(long revId) {
        this.cuCsid.f().a(CommonSchema.RevInfo.ENTITY).b(revId).a(CommonSchema.RevInfo.A_CSID);
        try {
            int l2 = this.cuCsid.e();
            if (this.db.a(this.cuCsid, l2)) {
                return this.cuCsid.m(l2);
            }
            Logs.APP_LOG.warn((Object)("No A_CSID in RevInfo for revid: " + revId));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.toProcess.isEmpty()) {
            this.getNextChangeset();
        }
        return !this.toProcess.isEmpty();
    }

    @Override
    public MutableChangeSet next() {
        if (this.toProcess.isEmpty()) {
            this.getNextChangeset();
        }
        MutableChangeSet nextCs = null;
        while (!this.toProcess.isEmpty() && nextCs == null) {
            MutableChangeSet first = this.toProcess.peek();
            for (String parent : first.getParents()) {
                MutableChangeSet parentCs;
                if (this.processedOrScheduled.add(parent)) {
                    parentCs = this.csDAO.load(parent);
                    if (parentCs != null) {
                        this.addCsAndParentsToFront(parentCs);
                        continue;
                    }
                    Logs.APP_LOG.warn((Object)("Couldn't find parent changeset " + parent + " for child changeset " + first.getId() + " in " + first.getRepName()));
                    continue;
                }
                parentCs = this.removeFromToProcess(parent);
                if (parentCs == null) continue;
                this.addCsAndParentsToFront(parentCs);
            }
            if (first != this.toProcess.peek()) continue;
            nextCs = this.toProcess.poll();
        }
        if (nextCs == null && this.toProcess.isEmpty()) {
            throw new NoSuchElementException("There are no more changesets available");
        }
        return nextCs;
    }

    public void takeBack(MutableChangeSet cs) {
        if (Logs.APP_LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("take back ").append(cs.getDisplayId()).append("; parents:[");
            List toProcessIds = Lists.transform(this.toProcess, (Function)new Function<ChangeSet, String>(){

                public String apply(@Nullable ChangeSet input) {
                    return input.getId();
                }
            });
            for (String p2 : cs.getParents()) {
                sb.append(p2).append("; considered:").append(this.processedOrScheduled.contains(p2)).append("; queued: ").append(toProcessIds.indexOf(p2)).append(";");
            }
            sb.append("]");
            Logs.APP_LOG.debug((Object)sb);
        }
        this.addCsAndParentsToFront(cs);
    }

    private void addCsAndParentsToFront(MutableChangeSet cs) {
        int maxRemovesFromToProcess = this.toProcess.size() * (this.toProcess.size() + 1) / 2;
        int numRemovesFromToProcess = 0;
        LinkedList<MutableChangeSet> parents = new LinkedList<MutableChangeSet>();
        parents.add(cs);
        while (!parents.isEmpty()) {
            MutableChangeSet head = (MutableChangeSet)parents.remove(0);
            this.toProcess.add(0, head);
            this.processedOrScheduled.add(head.getId());
            for (String parentId : head.getParents()) {
                MutableChangeSet parentCs = this.removeFromToProcess(parentId);
                if (parentCs == null) continue;
                ++numRemovesFromToProcess;
                parents.add(parentCs);
            }
            if (parents.isEmpty() || numRemovesFromToProcess <= maxRemovesFromToProcess) continue;
            Logs.APP_LOG.warn((Object)this.makeLoopWarningMessage(parents));
            break;
        }
    }

    private String makeLoopWarningMessage(LinkedList<MutableChangeSet> parents) {
        StringBuilder sb = new StringBuilder("TopologicalOrderChangesetIterator.addCsAndParentsToFront: Cyclic Ancestry Detected: [");
        for (MutableChangeSet csp : parents) {
            sb.append(csp.getDisplayId()).append("(");
            for (String p2 : csp.getParents()) {
                sb.append(p2).append(",");
            }
            sb.append("), ");
        }
        sb.append("][");
        for (MutableChangeSet csp : this.toProcess) {
            sb.append(csp.getDisplayId()).append("(");
            for (String p2 : csp.getParents()) {
                sb.append(p2).append(",");
            }
            sb.append("), ");
        }
        sb.append("]");
        return sb.toString();
    }

    private MutableChangeSet removeFromToProcess(String id) {
        Iterator iterator = this.toProcess.iterator();
        while (iterator.hasNext()) {
            MutableChangeSet cs = (MutableChangeSet)iterator.next();
            if (!cs.getId().equals(id)) continue;
            iterator.remove();
            this.processedOrScheduled.remove(id);
            return cs;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }
}

