/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;

public class TagTreeVisitor {
    private final ac db;
    private final IntList pending = new IntArrayList();

    public TagTreeVisitor(ac db) {
        this.db = db;
    }

    public void visitDescendents(int startid, DescendentVisitor v2) throws DbException {
        try {
            this.visitDescendents(startid, -1, v2, null);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void visitPredecessors(int startid, AncestorVisitor v2) throws DbException {
        try {
            y cu = y.a();
            int revid = startid;
            while (true) {
                AncestorLink link;
                cu.f();
                cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
                cu.a(CommonSchema.RevInfo.A_PREDECESSOR);
                int pl = cu.e();
                if (this.db.a(cu, pl)) {
                    int predecessorId = (int)cu.v(pl);
                    boolean cont = v2.visitAncestor(predecessorId, revid);
                    if (!cont) {
                        return;
                    }
                    revid = predecessorId;
                    continue;
                }
                cu.f();
                cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
                cu.a(CommonSchema.RevInfo.A_ANCESTOR_LINK);
                pl = cu.e();
                if (this.db.a(cu, pl) && (link = AncestorLink.fromCu(this.db, cu, pl)).isBranchPoint()) {
                    int ancestorId = link.getRevids().getInt(0);
                    boolean cont = v2.visitAncestor(ancestorId, revid);
                    if (!cont) {
                        return;
                    }
                    revid = ancestorId;
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int findLastSuccessor(int revid) throws DbException {
        try {
            y cu = y.a();
            while (true) {
                cu.f();
                cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
                cu.a(CommonSchema.RevInfo.A_SUCCESSOR);
                int pl = cu.e();
                if (!this.db.a(cu, pl)) break;
                revid = (int)cu.v(pl);
            }
            return revid;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int findNextSuccessor(int revid) throws DbException {
        try {
            y cu = y.a();
            cu.f();
            cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
            cu.a(CommonSchema.RevInfo.A_SUCCESSOR);
            int pl = cu.e();
            if (this.db.a(cu, pl)) {
                return (int)cu.v(pl);
            }
            return revid;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void visitSuccessors(int revid, DescendentVisitor v2) throws DbException {
        try {
            y cu = y.a();
            while (true) {
                cu.f();
                cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
                cu.a(CommonSchema.RevInfo.A_SUCCESSOR);
                int pl = cu.e();
                if (this.db.a(cu, pl)) {
                    revid = (int)cu.v(pl);
                    v2.visitDescendent(revid);
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void visitDescendents(int startid, int excludeid, DescendentVisitor dv, OtherVisitor ov) throws IOException, DbException {
        this.pending.clear();
        this.pending.add(startid);
        y cu = y.a();
        while (!this.pending.isEmpty()) {
            int successor;
            int current = this.pending.removeInt(this.pending.size() - 1);
            cu.f();
            cu.a(CommonSchema.RevInfo.ENTITY).b((long)current);
            cu.a(CommonSchema.RevInfo.A_SUCCESSOR);
            int pl = cu.e();
            if (this.db.a(cu, pl) && excludeid != (successor = (int)cu.v(pl))) {
                if (dv != null) {
                    dv.visitDescendent(successor);
                }
                if (ov != null) {
                    ov.visitOther(successor);
                }
                this.pending.add(successor);
            }
            cu.f();
            cu.a(CommonSchema.E_ANCESTORLINK_TO_REVID);
            cu.b((long)current);
            pl = cu.e();
            while (this.db.a(cu, pl)) {
                int descendent;
                int type = (int)cu.v(pl);
                if (type != AncestorLink.Type.BRANCHPOINT.getValue() || excludeid == (descendent = (int)cu.v(cu.w(pl)))) continue;
                if (dv != null) {
                    dv.visitDescendent(descendent);
                }
                if (ov != null) {
                    ov.visitOther(descendent);
                }
                this.pending.add(descendent);
            }
        }
    }

    public static interface OtherVisitor {
        public void visitOther(int var1) throws DbException, IOException;
    }

    public static interface DescendentVisitor {
        public void visitDescendent(int var1) throws DbException, IOException;
    }

    public static interface AncestorVisitor {
        public boolean visitAncestor(int var1, int var2) throws DbException, IOException;
    }
}

