/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.crucible.fisheye.CrucibleReindexMessage;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.infinitydb.DbTask;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonUtilDAO;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.List;
import java.util.WeakHashMap;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class ReviewInfoDAO {
    private static final int CACHE_VER = 2;
    private final ReviewManager reviewManager;
    private final InternalRevisionCache<? extends ChangeSet> cache;
    private final String repname;
    private final RepositoryStatus status;

    public ReviewInfoDAO(ReviewManager reviewManager, InternalRevisionCache<? extends ChangeSet> cache, String repname, RepositoryStatus status) {
        this.reviewManager = reviewManager;
        this.cache = cache;
        this.repname = repname;
        this.status = status;
    }

    public boolean slurp(final boolean reindex) throws DbException {
        Session session;
        try {
            session = HibernateUtil.currentSession();
        }
        catch (HibernateException e2) {
            Logs.APP_LOG.info((Object)"Could not get session, skipping slurp", (Throwable)e2);
            return false;
        }
        TxHelper txHelper = new TxHelper();
        try {
            txHelper.beginTx();
            boolean result = this.cache.withDbWriteLock(30, new DbTask<Boolean>(){

                @Override
                public Boolean perform(ac itemSpace) {
                    return ReviewInfoDAO.this.doSlurp(itemSpace, session, reindex);
                }
            });
            txHelper.commitTx();
            this.status.setMessage(null);
            boolean bl = result;
            return bl;
        }
        catch (HibernateException e3) {
            throw new DbException(e3);
        }
        finally {
            txHelper.rollbackTxIfNotCommitted();
            txHelper.closeSession();
        }
    }

    private boolean doSlurp(ac itemSpace, Session session, boolean requestReindex) throws DbException {
        boolean updated;
        boolean reindex;
        CommonRevInfoDAO rdao = this.cache.getCommonRevInfoDAO();
        CommonUtilDAO util = new CommonUtilDAO(this.cache.getInfDb(), rdao.getStringTables());
        long ver = util.getProperty(CommonProperties.CRUCACHE_VER.value, -1L);
        boolean bl = reindex = ver != 2L || requestReindex;
        if (reindex) {
            util.setProperty(CommonProperties.CRUCACHE_VER.value, 2L);
            updated = true;
            if (ver != -1L) {
                this.blowaway(itemSpace, rdao);
            }
            this.doFullscan(itemSpace, rdao, session);
        } else {
            updated = this.doIncremental(itemSpace, rdao, session);
        }
        return updated;
    }

    private boolean doIncremental(ac db, CommonRevInfoDAO rdao, Session session) throws DbException {
        FlushMode originalFlushMode = session.getFlushMode();
        try {
            Timer timer = new Timer("Review incremental scan for " + this.repname);
            session.setFlushMode(FlushMode.COMMIT);
            Query q2 = session.createQuery("from CrucibleReindexMessage fru where fru.fileRevision.sourceName = :sourceName order by fru.id asc");
            q2.setString("sourceName", this.repname);
            y cu = y.a();
            int count = 0;
            WeakHashMap reviewRevisionsProcessed = new WeakHashMap();
            for (CrucibleReindexMessage update : q2.list()) {
                Pair<Integer, CrucibleRevision> key;
                if (count == 0) {
                    this.status.setMessage("Indexing review data.");
                }
                if (!reviewRevisionsProcessed.containsKey(key = Pair.newInstance(update.getReviewId(), update.getFileRevision()))) {
                    this.processRevision(db, rdao, cu, update.getReviewId(), update.getFileRevision());
                    reviewRevisionsProcessed.put(key, null);
                }
                session.delete((Object)update);
                ++count;
            }
            Logs.APP_LOG.debug((Object)("indexed " + count + " revision updates."));
            timer.end();
            boolean bl = count != 0;
            return bl;
        }
        catch (HibernateException e2) {
            throw new DbException(e2);
        }
        finally {
            session.setFlushMode(originalFlushMode);
        }
    }

    private void doFullscan(ac db, CommonRevInfoDAO rdao, Session session) throws DbException {
        try {
            this.status.setMessage("Indexing all review data.");
            Timer timer = new Timer("Review fullscan for " + this.repname);
            this.deleteOldMessages(session);
            int count = 0;
            y cu = y.a();
            List<Object[]> revisionDetailsConsideredInReviews = this.reviewManager.getRevisionDetailsConsideredInReviews(this.repname);
            for (Object[] row : revisionDetailsConsideredInReviews) {
                String path = (String)row[0];
                String revision = (String)row[1];
                Integer review = (Integer)row[2];
                String state = (String)row[3];
                RevInfoKey rik = new RevInfoKey(new Path(path), revision);
                int revid = rdao.getRevId(rik);
                if (revid == -1) continue;
                this.addRevisionToReview(db, cu, revid, review, state);
                if (++count % 100 != 0) continue;
                this.status.setMessage("Indexing all review data, " + count + " rows so far.");
            }
            Logs.APP_LOG.debug((Object)("indexed " + count + " Crucible rows."));
            int countNotIndexed = revisionDetailsConsideredInReviews.size() - count;
            if (countNotIndexed > 0) {
                String msg = "Skipped indexing %d out of %d reviews. This can cause issues with the changeset to review mapping in FishEye. This is possibly due to a change in the repository path configuration.";
                Logs.APP_LOG.warn((Object)String.format("Skipped indexing %d out of %d reviews. This can cause issues with the changeset to review mapping in FishEye. This is possibly due to a change in the repository path configuration.", countNotIndexed, countNotIndexed + count));
            }
            timer.end();
        }
        catch (HibernateException e2) {
            throw new DbException(e2);
        }
    }

    private void deleteOldMessages(Session session) {
        Query delExisting = session.createQuery("delete CrucibleReindexMessage where fileRevision in (from CrucibleRevision fr where fr.spr.sourceName = :sourceName)");
        delExisting.setString("sourceName", this.repname);
        int nDeleted = delExisting.executeUpdate();
        Logs.APP_LOG.debug((Object)("deleted " + nDeleted + " old index messages"));
    }

    private void blowaway(ac db, CommonRevInfoDAO rdao) throws DbException {
        this.status.setMessage("Removing old review index.");
        try {
            y cu = y.a();
            cu.f().a(CommonSchema.E_CLOSEDREVIEW_REVIDS);
            db.c((Object)cu);
            cu.f().a(CommonSchema.E_OPENREVIEW_REVIDS);
            db.c((Object)cu);
            cu.f().a(CommonSchema.E_DRAFTREVIEW_REVIDS);
            db.c((Object)cu);
            cu.f().a(CommonSchema.E_REVIEW_TO_REVID);
            db.c((Object)cu);
            rdao.deleteAttribteOnAllRevisions(CommonSchema.RevInfo.A_REVIEWIDS);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void addRevisionToReview(ac db, y cu, int revid, int reviewid, String reviewState) throws DbException {
        try {
            State state = StateManager.INSTANCE.getStateByName(reviewState);
            I metastate = null;
            if (state.isClosedMetaState()) {
                metastate = CommonSchema.E_CLOSEDREVIEW_REVIDS;
            } else if (state.isOpenMetaState()) {
                metastate = CommonSchema.E_OPENREVIEW_REVIDS;
            } else if (state.isDraftMetaState()) {
                metastate = CommonSchema.E_DRAFTREVIEW_REVIDS;
            }
            if (metastate != null) {
                cu.f().a(metastate).b((long)revid);
                db.b(cu);
            }
            cu.f().a(CommonSchema.E_REVIEW_TO_REVID).b((long)reviewid).b((long)revid);
            db.b(cu);
            cu.f().a(CommonSchema.E_REVINFO).b((long)revid).a(CommonSchema.RevInfo.A_REVIEWIDS).b((long)reviewid);
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void processRevision(ac db, CommonRevInfoDAO rdao, y cu, Integer reviewId, CrucibleRevision fr) throws DbException {
        try {
            int revid = rdao.getRevId(fr.getFePath(), fr.getRevision());
            if (revid == -1) {
                Logs.APP_LOG.warn((Object)("could not find revision " + fr));
                return;
            }
            boolean isClosed = false;
            boolean isOpen = false;
            boolean isDraft = false;
            boolean inReview = this.reviewManager.isConsideredInReview(fr, reviewId);
            cu.f().a(CommonSchema.E_REVIEW_TO_REVID).b(reviewId).b((long)revid);
            this.insertOrDelete(db, cu, inReview);
            cu.f().a(CommonSchema.E_REVINFO).b((long)revid).a(CommonSchema.RevInfo.A_REVIEWIDS).b(reviewId);
            this.insertOrDelete(db, cu, inReview);
            cu.f().a(CommonSchema.E_REVINFO).b((long)revid).a(CommonSchema.RevInfo.A_REVIEWIDS);
            int len = cu.e();
            while (db.a(cu, len)) {
                int id = (int)cu.v(len);
                Review review = this.reviewManager.getReviewById(id);
                if (review == null) continue;
                if (review.getState().isClosedMetaState()) {
                    isClosed = true;
                } else if (review.getState().isDraftMetaState()) {
                    isDraft = true;
                } else if (review.getState().isOpenMetaState()) {
                    isOpen = true;
                }
                if (!isClosed || !isOpen || !isDraft) continue;
                break;
            }
            cu.f().a(CommonSchema.E_CLOSEDREVIEW_REVIDS).b((long)revid);
            this.insertOrDelete(db, cu, isClosed);
            cu.f().a(CommonSchema.E_OPENREVIEW_REVIDS).b((long)revid);
            this.insertOrDelete(db, cu, isOpen);
            cu.f().a(CommonSchema.E_DRAFTREVIEW_REVIDS).b((long)revid);
            this.insertOrDelete(db, cu, isDraft);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void insertOrDelete(ac db, y cu, boolean insert) throws IOException {
        if (insert) {
            db.b(cu);
        } else {
            db.c(cu);
        }
    }
}

