/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.cache.infdb.InfDbRevisionInfoCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class LazyFileRevisionInterceptor<F extends FileRevision>
implements MethodInterceptor {
    private FileRevisionDAO<F> dao = null;
    private Integer revid = null;
    private RevInfoKey key = null;
    private AncestorLink ancestorLink = null;
    private List<RevInfoKey> ancestors = null;
    private Boolean dead = null;
    private Boolean added = null;
    private Boolean copy = null;
    private Boolean moved = null;
    private Boolean modify = null;
    private Boolean metadataOnly = null;
    private Boolean binary = null;
    private Boolean oversize = null;
    private Boolean file = null;
    private Boolean dir = null;
    private LineCountState lineCountState = null;
    private String author = null;
    private String displayRevision = null;
    private Path logicalPath;
    private List<String> branchPoints = null;
    private long date = -1L;
    private F rev = null;
    private String changeSetId;

    public LazyFileRevisionInterceptor(int revid, FileRevisionDAO<F> dao) {
        if (dao == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        this.revid = revid;
        this.dao = dao;
    }

    public LazyFileRevisionInterceptor(int revid, RevInfoKey revkey, FileRevisionDAO<F> dao) {
        if (dao == null || revkey == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        this.revid = revid;
        this.key = revkey;
        this.dao = dao;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String methodName = method.getName();
        if ("finalize".equals(methodName)) {
            Logs.APP_LOG.warn((Object)("unexpected call to finalize on intercepted FileRevision " + this.revid));
            return null;
        }
        if (this.rev != null) {
            return proxy.invoke(this.rev, args);
        }
        if ("getRevID".equals(methodName)) {
            return this.getRevId();
        }
        if ("getRevInfoKey".equals(methodName)) {
            return this.getRevInfoKey();
        }
        if ("getPath".equals(methodName)) {
            return this.getRevInfoKey().getPath();
        }
        if ("getLogicalPath".equals(methodName)) {
            return this.getLogicalPath();
        }
        if ("getRevision".equals(methodName)) {
            return this.getRevInfoKey().getRev();
        }
        if ("getDate".equals(methodName)) {
            return this.getDate();
        }
        if ("getDateValue".equals(methodName)) {
            return new Date(this.getDate());
        }
        if ("getAncestorLink".equals(methodName)) {
            return this.getAncestorLink();
        }
        if ("isDead".equals(methodName)) {
            return this.isDead();
        }
        if ("isAdded".equals(methodName)) {
            return this.isAdded();
        }
        if ("isMove".equals(methodName)) {
            return this.isMove();
        }
        if ("isMetadataOnlyChange".equals(methodName)) {
            return this.isMetadataOnly();
        }
        if ("isCopy".equals(methodName)) {
            return this.isCopy();
        }
        if ("isModify".equals(methodName)) {
            return this.isModify();
        }
        if ("isBinary".equals(methodName)) {
            return this.isBinary();
        }
        if ("isOversize".equals(methodName)) {
            return this.isOversize();
        }
        if ("isBinaryOrOversize".equals(methodName)) {
            return this.isBinary() || this.isOversize();
        }
        if ("isFile".equals(methodName)) {
            return this.isFile();
        }
        if ("isDir".equals(methodName)) {
            return this.isDir();
        }
        if ("getBranchPoints".equals(methodName)) {
            return this.getBranchPoints();
        }
        if ("getChangeSetId".equals(methodName)) {
            return this.getChangeSetId();
        }
        if ("getLineCountState".equals(methodName)) {
            return this.getLineCountState();
        }
        if ("getAuthor".equals(methodName)) {
            return this.getAuthor();
        }
        if ("getDisplayRevision".equals(methodName)) {
            return this.getDisplayRevision();
        }
        if ("getAncestors".equals(methodName)) {
            return this.getAncestors();
        }
        this.loadFileRevision();
        return proxy.invoke(this.rev, args);
    }

    private Path getLogicalPath() {
        if (this.logicalPath == null) {
            this.logicalPath = this.dao.getLogicalPath(this.getRevInfoKey().getPath());
        }
        return this.logicalPath;
    }

    private List<RevInfoKey> getAncestors() {
        if (this.ancestors == null) {
            AncestorLink ancestorLink = this.getAncestorLink();
            this.ancestors = ancestorLink == null ? Collections.emptyList() : ImmutableList.copyOf((Collection)Lists.transform((List)ancestorLink.getRevids(), (Function)new Function<Integer, RevInfoKey>(){

                public RevInfoKey apply(Integer revId) {
                    return LazyFileRevisionInterceptor.this.dao.getKey(revId);
                }
            }));
        }
        return this.ancestors;
    }

    private String getAuthor() throws DbException {
        if (this.author == null) {
            this.author = this.dao.getAuthor(this.revid);
        }
        return this.author;
    }

    private String getDisplayRevision() throws DbException {
        if (this.displayRevision == null) {
            this.displayRevision = this.dao.getDisplayRevision(this.revid);
        }
        return this.displayRevision;
    }

    private RevInfoKey getRevInfoKey() throws DbException {
        if (this.key == null) {
            this.key = this.dao.getKey(this.revid);
        }
        return this.key;
    }

    private int getRevId() throws DbException {
        if (this.revid == null) {
            this.revid = this.dao.getId(this.key);
        }
        return this.revid;
    }

    private long getDate() throws DbException {
        if (this.date == -1L) {
            this.date = this.dao.getDate(this.getRevId());
        }
        return this.date;
    }

    private AncestorLink getAncestorLink() throws DbException {
        if (this.ancestorLink == null) {
            this.ancestorLink = this.dao.getAncestorLink(this.getRevId());
        }
        return this.ancestorLink;
    }

    private boolean isDead() throws DbException {
        if (this.dead == null) {
            this.dead = this.dao.isDead(this.getRevId());
        }
        return this.dead;
    }

    private boolean isAdded() {
        if (this.added == null) {
            this.added = this.dao.isAdded(this.getRevId());
        }
        return this.added;
    }

    private boolean isMove() {
        if (this.moved == null) {
            this.moved = this.dao.isMove(this.getRevId());
        }
        return this.moved;
    }

    private boolean isMetadataOnly() {
        if (this.metadataOnly == null) {
            this.metadataOnly = this.dao.isMetadataOnly(this.getRevId());
        }
        return this.metadataOnly;
    }

    private boolean isCopy() {
        if (this.copy == null) {
            this.copy = this.dao.isCopy(this.getRevId());
        }
        return this.copy;
    }

    private boolean isModify() {
        if (this.modify == null) {
            this.modify = this.dao.isModify(this.getRevId());
        }
        return this.modify;
    }

    private boolean isBinary() {
        if (this.binary == null) {
            this.binary = this.dao.isBinary(this.getRevId());
        }
        return this.binary;
    }

    private boolean isOversize() {
        if (this.oversize == null) {
            this.oversize = this.dao.isOversize(this.getRevId());
        }
        return this.oversize;
    }

    private boolean isFile() {
        if (this.file == null) {
            this.file = this.dao.isFile(this.getRevId());
        }
        return this.file;
    }

    private boolean isDir() {
        if (this.dir == null) {
            this.dir = this.dao.isDir(this.getRevId());
        }
        return this.dir;
    }

    private LineCountState getLineCountState() {
        if (this.lineCountState == null) {
            this.lineCountState = this.dao.getLineCountState(this.getRevId());
        }
        return this.lineCountState;
    }

    private List<String> getBranchPoints() throws DbException {
        if (this.branchPoints == null) {
            this.branchPoints = this.dao.getBranchPoints(this.getRevId());
        }
        return this.branchPoints;
    }

    private String getChangeSetId() {
        if (this.changeSetId == null) {
            this.changeSetId = this.dao instanceof InfDbRevisionInfoCache ? ((InfDbRevisionInfoCache)this.dao).getChangeSetId(this.getRevId()).toString() : this.getRevInfoKey().getRev();
        }
        return this.changeSetId;
    }

    protected void loadFileRevision() throws DbException {
        if (this.rev == null) {
            this.rev = this.dao.load(this.getRevId());
            if (this.rev == null) {
                throw new DbException("Error lazy loading file revision with rev id: " + this.revid + ", key = " + this.key);
            }
            this.ancestorLink = null;
            this.dead = null;
            this.added = null;
            this.copy = null;
            this.moved = null;
            this.modify = null;
            this.metadataOnly = null;
            this.binary = null;
            this.oversize = null;
            this.file = null;
            this.dir = null;
            this.key = null;
            this.revid = null;
            this.branchPoints = null;
        }
    }
}

