/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.Position;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class LazyChangeSetInterceptor<F extends FileRevision, C extends ChangeSetImpl<F>>
implements MethodInterceptor {
    private C cs = null;
    private String csid = null;
    private String displayId = null;
    private ChangeSetDAO<F, C> dao = null;
    private Position position = null;
    private String author = null;
    private Date date = null;
    private long id = -1L;
    private Integer revisionCount = null;
    private Set<String> branches;

    public LazyChangeSetInterceptor(String csid, ChangeSetDAO<F, C> dao) {
        this.csid = csid;
        this.dao = dao;
    }

    private long getDBId() {
        if (this.id == -1L) {
            this.id = this.dao.getDbId(this.csid);
        }
        return this.id;
    }

    private Position getPosition() {
        if (this.position == null) {
            this.position = this.dao.getPositionForChangeset(this.getDBId());
        }
        return this.position;
    }

    private String getAuthor() {
        if (this.author == null) {
            this.author = this.dao.getAuthor(this.getDBId());
        }
        return this.author;
    }

    private Set<String> getBranches() {
        if (this.branches == null) {
            this.branches = this.dao.supportsCreatedOnBranch() ? new HashSet<String>(this.dao.getBranches(this.getDBId())) : new HashSet<String>(this.dao.getBranchesContributedTo(this.getDBId()));
        }
        return this.branches;
    }

    private Date getDateValue() {
        if (this.date == null) {
            this.date = this.dao.getDateValue(this.getDBId());
            if (this.date == null) {
                this.date = new Date(0L);
            }
        }
        return this.date;
    }

    private String getRepositoryName() {
        return this.dao.getFileRevDAO().getRepName();
    }

    private Iterable<Path> getPaths() {
        return this.dao.getFileRevDAO().getPathsInChangeset(this.csid);
    }

    private String getDisplayId() {
        if (this.displayId == null) {
            this.displayId = ((ChangeSetImpl)this.dao.createChangeSet(this.csid)).getDisplayId();
        }
        return this.displayId;
    }

    private int getRevisionCount() {
        if (this.revisionCount == null) {
            this.revisionCount = this.dao.getRevisionCount(this.csid);
        }
        return this.revisionCount;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String methodName = method.getName();
        if ("finalize".equals(methodName)) {
            Logs.APP_LOG.warn((Object)("unexpected call to finalize on intercepted ChangeSet " + this.csid));
            return null;
        }
        if (this.cs != null) {
            return proxy.invoke(this.cs, args);
        }
        if ("getId".equals(methodName)) {
            return this.csid;
        }
        if ("getDisplayId".equals(methodName)) {
            return this.getDisplayId();
        }
        if ("getComment".equals(methodName)) {
            return this.dao.getComment(this.getDBId());
        }
        if ("getIndexingState".equals(methodName)) {
            return this.dao.getIndexingState(this.csid);
        }
        if ("getPosition".equals(methodName)) {
            return this.getPosition();
        }
        if ("getDate".equals(methodName)) {
            return this.getDateValue().getTime();
        }
        if ("getDateValue".equals(methodName)) {
            return this.getDateValue();
        }
        if ("getAuthor".equals(methodName)) {
            return this.getAuthor();
        }
        if ("getBranches".equals(methodName)) {
            return this.getBranches();
        }
        if ("isBefore".equals(methodName)) {
            Position thisPos = this.getPosition();
            Position otherPos = ((ChangeSetImpl)args[0]).getPosition();
            return thisPos != null && otherPos != null && thisPos.compareTo(otherPos) < 0;
        }
        if ("isAfter".equals(methodName)) {
            Position thisPos = this.getPosition();
            Position otherPos = ((ChangeSetImpl)args[0]).getPosition();
            return thisPos != null && otherPos != null && thisPos.compareTo(otherPos) > 0;
        }
        if ("isInBranch".equals(methodName)) {
            return this.dao.isCommitInBranch(this.getDBId(), (String)args[0]);
        }
        if ("equals".equals(methodName)) {
            ChangeSet other = (ChangeSet)args[0];
            return this.csid.equals(other.getId());
        }
        if ("getRepName".equals(methodName)) {
            return this.getRepositoryName();
        }
        if ("getCrossRepoId".equals(methodName)) {
            return this.getRepositoryName() + ":" + this.csid;
        }
        if ("dateCompare".equals(methodName)) {
            ChangeSet other = (ChangeSet)args[0];
            return ChangeSetImpl.dateCompare((ChangeSetImpl)obj, other);
        }
        if ("getPaths".equals(methodName)) {
            return this.getPaths();
        }
        if ("getRevisionInfosCount".equals(methodName)) {
            return this.getRevisionCount();
        }
        if ("visitRevisions".equals(methodName)) {
            StoppableVisitor visitor;
            if (args[0] instanceof StoppableVisitor) {
                visitor = (StoppableVisitor)args[0];
            } else {
                final Visitor unstoppable = (Visitor)args[0];
                visitor = new StoppableVisitor<FileRevision>(){

                    @Override
                    public boolean visit(FileRevision fileRevision) {
                        unstoppable.visit(fileRevision);
                        return true;
                    }
                };
            }
            this.dao.getFileRevDAO().visitChangeSetRevisions(this.csid, visitor);
            return null;
        }
        this.cs = this.dao.loadNonLazy(this.csid);
        this.position = null;
        this.date = null;
        this.csid = null;
        this.revisionCount = null;
        return proxy.invoke(this.cs, args);
    }
}

