/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public class DefaultLicenseEnforcer
implements LicenseEnforcer {
    private int maxCommitters = 1;
    private Set<String> authorSet;
    private boolean initialized = false;

    public DefaultLicenseEnforcer(int maxCommitters) {
        this.maxCommitters = maxCommitters;
    }

    private void initializeAuthorList(InfinityDbHandle dbh) throws DbException {
        if (this.maxCommitters != -1) {
            this.authorSet = new LinkedHashSet<String>();
            try {
                ac db = dbh.get();
                y cu = y.a();
                cu.a(CommonSchema.E_AUTHOR_TO_REVID);
                int pl = cu.e();
                while (db.a(cu, pl) && this.authorSet.size() <= this.maxCommitters) {
                    String author = cu.m(pl);
                    if (!"no_author".equals(author)) {
                        this.authorSet.add(author.toLowerCase(Locale.US));
                    }
                    int p2 = cu.n(pl);
                    cu.d(p2).j();
                }
                this.initialized = true;
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
    }

    @Override
    public void validateCommitterLimit(String newCommitter, InfinityDbHandle dbh) throws DbException, LicensePolicyException {
        if (this.maxCommitters != -1) {
            if (!this.initialized) {
                this.initializeAuthorList(dbh);
            }
            if (newCommitter != null) {
                this.authorSet.add(newCommitter.toLowerCase(Locale.US));
            }
            if (this.authorSet.size() > this.maxCommitters) {
                StringBuilder builder = new StringBuilder("Committer limit exceeded - committer list: ");
                String sep = "";
                int count = 0;
                for (String committer : this.authorSet) {
                    if (count > this.maxCommitters * 2) {
                        builder.append(sep).append("...");
                        break;
                    }
                    ++count;
                    builder.append(sep).append(committer);
                    sep = ", ";
                }
                Logs.APP_LOG.warn((Object)builder.toString());
                throw new LicensePolicyException("Exceeded number of allowed committers. Your licenses only allows " + this.maxCommitters + " committers. This repository has " + this.authorSet.size());
            }
        }
    }

    @Override
    public boolean isCommitterLimitEnforced() {
        return this.maxCommitters != -1;
    }

    @Override
    public int getCommitterCount(InfinityDbHandle dbh) {
        if (this.maxCommitters == -1) {
            return 0;
        }
        if (!this.initialized) {
            this.initializeAuthorList(dbh);
        }
        return this.authorSet.size();
    }

    @Override
    public void reInitialize() {
        this.initialized = false;
    }
}

