/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CommonUtilDAO {
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;
    private final ReadWriteLock accessLock = new ReentrantReadWriteLock();
    private LoadingCache<String, Optional<Long>> cache = CacheBuilder.newBuilder().concurrencyLevel(1).build((CacheLoader)new CacheLoader<String, Optional<Long>>(){

        public Optional<Long> load(String key) throws Exception {
            try {
                Long result = null;
                ac db = CommonUtilDAO.this.dbh.get();
                long keyId = ((CommonUtilDAO)CommonUtilDAO.this).stringTables.propKeyDB.find(key);
                if (keyId != -1L) {
                    y cu = y.a().a(CommonSchema.E_INDEXING_PROPS);
                    cu.b(keyId);
                    int pl = cu.e();
                    result = db.a(cu, pl) ? Long.valueOf(cu.v(pl)) : null;
                }
                return Optional.fromNullable(result);
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
    });

    public CommonUtilDAO(InfinityDbHandle dbh, CommonStringTables stringTables) {
        this.dbh = dbh;
        this.stringTables = stringTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, long value) throws DbException {
        try {
            this.accessLock.writeLock().lock();
            Optional cached = (Optional)this.cache.asMap().get(key);
            if (cached != null && cached.isPresent() && (Long)cached.get() == value) {
                return;
            }
            try {
                ac db = this.dbh.get();
                long keyId = this.stringTables.propKeyDB.add(key);
                y cu = y.a().a(CommonSchema.E_INDEXING_PROPS);
                cu.b(keyId);
                int pl = cu.e();
                cu.b(value);
                db.e(cu, pl);
                this.cache.asMap().put(key, Optional.of((Object)value));
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        finally {
            this.accessLock.writeLock().unlock();
        }
    }

    public long getProperty(String key, long defaultValue) throws DbException {
        try {
            this.accessLock.readLock().lock();
            Optional cached = (Optional)this.cache.get((Object)key);
            long l2 = cached.isPresent() ? (Long)cached.get() : defaultValue;
            return l2;
        }
        catch (ExecutionException e2) {
            throw new DbException(e2);
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }

    public boolean hasProperty(String key) throws DbException {
        try {
            this.accessLock.readLock().lock();
            boolean bl = ((Optional)this.cache.get((Object)key)).isPresent();
            return bl;
        }
        catch (ExecutionException e2) {
            throw new DbException(e2);
        }
        finally {
            this.accessLock.readLock().unlock();
        }
    }
}

