/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import java.util.HashMap;
import java.util.Map;

public class CommonStringTables {
    private final Map<Object, UniqueStringTable> tables = new HashMap<Object, UniqueStringTable>();
    private final UniqueStringTableFactory factory;
    public final UniqueStringTable commentDB;
    public final UniqueStringTable pathDB;
    public final UniqueStringTable suffixDB;
    public final UniqueStringTable lcfilenameDB;
    public final UniqueStringTable tagDB;
    public final UniqueStringTable propKeyDB;
    public final UniqueStringTable changeSetIdDB;
    public final UniqueStringTable branchDB;

    public CommonStringTables(UniqueStringTableFactory factory) {
        this.factory = factory;
        this.commentDB = this.createForId(CommonSchema.E_COMMENTS);
        this.pathDB = this.createForId(CommonSchema.E_PATHS);
        this.suffixDB = this.createForId(CommonSchema.E_SUFFIXPATHS);
        this.lcfilenameDB = this.createForId(CommonSchema.E_LCFILENAMES);
        this.tagDB = this.createForId(CommonSchema.E_TAGS);
        this.propKeyDB = this.createForId(CommonSchema.E_PROPKEYS);
        this.changeSetIdDB = this.createForId(CommonSchema.E_CHANGESET_IDS);
        this.branchDB = this.createForId(CommonSchema.E_BRANCH_NAMES);
    }

    public UniqueStringTable getForId(Object tableId) {
        return this.tables.get(tableId);
    }

    protected UniqueStringTable createForId(Object tableId) {
        UniqueStringTable ust = this.factory.createUniqueStringTable(tableId);
        this.tables.put(tableId, ust);
        return ust;
    }

    public void clearCaches() {
        for (UniqueStringTable table : this.tables.values()) {
            table.clearCaches();
        }
    }
}

