/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.dag.GraphIterator;
import com.atlassian.fisheye.dag.GraphUtils;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.SimpleIndex;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3Params;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.cenqua.fisheye.util.NaturalComparator;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.RevisionDateRange;
import com.cenqua.fisheye.util.SortedList;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.J;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.ag;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class CommonRevInfoDAO {
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;
    private final boolean svnMode;
    private final boolean caseSensitive;
    private final LicenseEnforcer licenseEnforcer;
    public static final String DEFAULT_AUTHOR = "no_author";
    public static final String DEFAULT_COMMENT = "no_comment";
    public static final String IMPORT_COMMENT = "Created by FishEye for initial repository import";
    private static final int HUNK_BATCHSIZE = 50;

    public CommonRevInfoDAO(InfinityDbHandle dbh, CommonStringTables stringTables, boolean svnMode, boolean caseSensitive, LicenseEnforcer licenseEnforcer) {
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.svnMode = svnMode;
        this.caseSensitive = caseSensitive;
        this.licenseEnforcer = licenseEnforcer;
    }

    public CommonStringTables getStringTables() {
        return this.stringTables;
    }

    public boolean exists(RevInfoKey rk) throws DbException {
        return this.getRevId(rk) != -1;
    }

    public boolean exists(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            return eav.exists();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getRevId(RevInfoKey revInfoKey) throws DbException {
        return this.getRevId(revInfoKey.getPath(), revInfoKey.getRev());
    }

    public int getRevId(Path path, String revision) throws DbException {
        long pathid = this.getPathId(path);
        if (pathid == -1L) {
            return -1;
        }
        return this.getRevId(pathid, revision);
    }

    public int getRevId(long pathid, String revision) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            cu.a(CommonSchema.E_REVKEY_TO_REVID);
            cu.b(pathid).b(revision);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                return (int)cu.v(pl);
            }
            return -1;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        catch (RuntimeException e3) {
            Logs.APP_LOG.debug((Object)("Failed to get revId: " + pathid + "(" + this.stringTables.pathDB.get(pathid) + ")" + " @ " + revision));
            throw e3;
        }
    }

    public Set<Integer> filterHeadRevisions(Set<Integer> revIds) throws DbException {
        IntArraySet headRevIds = new IntArraySet();
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS);
            int pl = cu.e();
            for (Integer revId : revIds) {
                cu.b(revId);
                if (db.a_(cu)) {
                    headRevIds.add(revId);
                }
                cu.d(pl);
            }
        }
        catch (IOException e2) {
            throw new DbException("Error while filtering " + revIds + " for head revisions", e2);
        }
        return headRevIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(int revid, CommonFileRevision ri) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                return;
            }
            ri.setRevID(revid);
            y revkey = y.a();
            if (!eav.getValue(CommonSchema.RevInfo.A_REVKEY, revkey)) {
                throw new DbException("Unable to load key for revid " + revid);
            }
            long pathid = revkey.v(0);
            String revision = revkey.m(revkey.w(0));
            ri.setRevision(revision);
            pathid = eav.getLong(CommonSchema.RevInfo.A_PATHID, pathid);
            ri.setPath(new Path(this.stringTables.pathDB.get(pathid)));
            ri.setAuthor(eav.getString(CommonSchema.RevInfo.A_AUTHOR, null));
            ri.setDate(eav.getLong(CommonSchema.RevInfo.A_DATE, 0L));
            ri.setComment(this.getStringFromTable(eav, CommonSchema.RevInfo.A_COMMENT_ID, this.stringTables.commentDB));
            ri.addBranch(eav.getString(CommonSchema.RevInfo.A_BRANCH, null));
            ri.setBinary(eav.getBoolean(CommonSchema.RevInfo.A_ISBINARY, false));
            ri.setOversize(eav.getBoolean(CommonSchema.RevInfo.A_IS_OVERSIZE, false));
            ri.setAdded(eav.getBoolean(CommonSchema.RevInfo.A_ISADDED, false));
            ri.setDead(eav.getBoolean(CommonSchema.RevInfo.A_ISDELETED, false));
            ri.setCopy(eav.getBoolean(CommonSchema.RevInfo.A_ISCOPIED, false));
            ri.setMove(eav.getBoolean(CommonSchema.RevInfo.A_ISMOVED, false));
            ri.setModify(eav.getBoolean(CommonSchema.RevInfo.A_ISMODIFY, false));
            ri.setTrunkLike(eav.getBoolean(CommonSchema.RevInfo.A_ISTRUNKLIKE, false));
            ri.setFileType(eav.getInt(CommonSchema.RevInfo.A_FILETYPE, 1));
            this.fillAncestors(ri);
            this.fillPredecessor(ri);
            this.fillDescendents(ri);
            y cu = y.a();
            try {
                if (eav.getValue(CommonSchema.RevInfo.A_LINEDATA, cu)) {
                    int pl = 0;
                    ri.setLineCount((int)cu.v(pl));
                    pl = cu.w(pl);
                    ri.setLinesAdded((int)cu.v(pl));
                    pl = cu.w(pl);
                    ri.setLinesRemoved((int)cu.v(pl));
                }
                cu = cu.f().a(CommonSchema.E_REVID_TO_HEAD_IN_BRANCHES).b((long)revid);
                ac db = this.dbh.get();
                int len = cu.e();
                while (db.a(cu, len)) {
                    ri.addHeadOnBranch(this.stringTables.branchDB.get(cu.v(len)));
                }
            }
            finally {
                y.c(cu);
            }
            ri.setLineCountState(this.getLineCountState(eav));
            ri.setTags(eav.getStrings(this.stringTables.tagDB, CommonSchema.RevInfo.A_TAGS));
            ri.setBranchPoints(eav.getStrings(CommonSchema.RevInfo.A_BRANCH_POINTS));
            ri.setReviewIds(eav.getInts(CommonSchema.RevInfo.A_REVIEWIDS));
            ri.setHunks(this.getHunks(revid));
            ri.setTmpDiffAddedFile(this.getFilename(eav, CommonSchema.RevInfo.A_TMP_DIFF_ADDED_FILE));
            ri.setTmpDiffRemovedFile(this.getFilename(eav, CommonSchema.RevInfo.A_TMP_DIFF_REMOVED_FILE));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private File getFilename(EavEntityCu eav, p attribute) throws IOException {
        String filename = eav.getString(attribute, null);
        return filename == null ? null : new File(filename);
    }

    public List<String> getBranchPoints(int revid) throws DbException {
        ArrayList<String> result = new ArrayList<String>();
        y cu = y.a(CommonSchema.RevInfo.ENTITY).b((long)revid).a(CommonSchema.RevInfo.A_BRANCH_POINTS);
        int pl = cu.e();
        try {
            ac db = this.dbh.get();
            while (db.a(cu, pl)) {
                result.add(cu.m(pl));
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return result;
    }

    public int searchChangeSetRevids(String csid, Predicate<Integer> matchPredicate) throws DbException {
        if (csid != null) {
            y cu = y.a().b(csid);
            y val = y.a();
            ac db = this.dbh.get();
            try {
                while (CommonSchema.RevInfoIndexes.I_CSID.nextInIndex(db, cu, val)) {
                    int revid = (int)val.v(0);
                    if (!matchPredicate.apply((Object)revid)) continue;
                    int n2 = revid;
                    return n2;
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            finally {
                cu.b();
                val.b();
            }
        }
        return -1;
    }

    public IntList getChangeSetRevids(String csid) throws DbException {
        IntArrayList result = new IntArrayList();
        this.searchChangeSetRevids(csid, new Predicate<Integer>((IntList)result){
            final /* synthetic */ IntList val$result;
            {
                this.val$result = intList;
            }

            public boolean apply(Integer revid) {
                this.val$result.add((Object)revid);
                return false;
            }
        });
        return result;
    }

    private void fillPredecessor(CommonFileRevision ri) throws IOException, DbException {
        Integer predecessor = this.getPredecessorOf(ri.getRevID());
        if (predecessor != null && predecessor != -1) {
            ri.setPredecessor(this.getKey(predecessor));
        }
    }

    private void fillAncestors(CommonFileRevision ri) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            cu.a(CommonSchema.RevInfo.ENTITY).b((long)ri.getRevID());
            cu.a(CommonSchema.RevInfo.A_ANCESTOR_LINK);
            int pl = cu.e();
            if (!db.a(cu, pl)) {
                return;
            }
            AncestorLink link = AncestorLink.fromCu(db, cu, pl);
            ri.setAncestorLink(link);
            int ancestorOnBranchId = this.getAncestorOnBranch(link, ri.getBranch());
            RevInfoKey ancestorOnBranch = null;
            ArrayList<RevInfoKey> ancestors = new ArrayList<RevInfoKey>();
            IntListIterator intListIterator = link.getRevids().iterator();
            while (intListIterator.hasNext()) {
                int arevid = (Integer)intListIterator.next();
                RevInfoKey ancestorKey = this.getKey(arevid);
                if (ancestorKey != null) {
                    ancestors.add(ancestorKey);
                    if (ancestorOnBranchId != arevid) continue;
                    ancestorOnBranch = ancestorKey;
                    continue;
                }
                Logs.APP_LOG.warn((Object)("Could not find ancestor for " + ri.getRevID() + " ancestor id = " + arevid));
            }
            ri.setAncestors(ancestors);
            ri.setAncestorOnBranch(ancestorOnBranch);
            RevInfoKey srcAncestor = ancestorOnBranch;
            if (srcAncestor == null && !ancestors.isEmpty()) {
                srcAncestor = (RevInfoKey)ancestors.get(0);
            }
            if (link.isCopy()) {
                ri.setCopySource(srcAncestor);
            }
            if (link.isMove()) {
                ri.setMoveSource(srcAncestor);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void fillDescendents(CommonFileRevision ri) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            cu.a(CommonSchema.E_ANCESTORLINK_TO_REVID).b((long)ri.getRevID());
            int pl = cu.e();
            while (db.a(cu, pl)) {
                AncestorLink.Type linkType = AncestorLink.Type.fromValue((int)cu.v(pl));
                int descendantid = (int)cu.v(cu.w(pl));
                if (AncestorLink.Type.COPY.equals((Object)linkType)) {
                    ri.addCopyDestination(this.getKey(descendantid));
                    continue;
                }
                if (!AncestorLink.Type.MOVE.equals((Object)linkType)) continue;
                ri.setMoveDest(this.getKey(descendantid));
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public RevInfoKey getKey(int revid) throws DbException {
        try {
            y revkey;
            if (revid == -1) {
                Logs.APP_LOG.warn((Object)"Attempt to load key for invalid revision", (Throwable)new Exception());
                return null;
            }
            EavEntityCu eav = this.makeEav(revid);
            if (eav.getValue(CommonSchema.RevInfo.A_REVKEY, revkey = y.a())) {
                long pathid = revkey.v(0);
                String revision = revkey.m(revkey.w(0));
                pathid = eav.getLong(CommonSchema.RevInfo.A_PATHID, pathid);
                return new RevInfoKey(new Path(this.stringTables.pathDB.get(pathid)), revision);
            }
            return null;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private String getStringFromTable(EavEntityCu eav, p atr, UniqueStringTable table) throws IOException, DbException {
        long pathid = eav.getLong(atr, 0L);
        return table.get(pathid);
    }

    public int getAncestorOnBranch(AncestorLink ancestorLink, String branch) throws DbException {
        if (branch != null) {
            IntListIterator intListIterator = ancestorLink.getRevids().iterator();
            while (intListIterator.hasNext()) {
                int arevid = (Integer)intListIterator.next();
                String ancestorBranch = this.getBranchOf(arevid);
                if (!branch.equals(ancestorBranch)) continue;
                return arevid;
            }
        }
        return -1;
    }

    public int insertNew(CommonFileRevisionInput ri, AncestorLink ancestorLink, boolean storeHunks, boolean storeSuffixPaths) throws DbException, LicensePolicyException {
        this.licenseEnforcer.validateCommitterLimit(ri.getAuthor(), this.dbh);
        y cu = y.a();
        y cuAncestor = y.a();
        try {
            ac db = this.dbh.get();
            int revid = this.allocateNewRevID();
            String branch = ri.getBranch();
            if (this.svnMode) {
                ancestorLink = ri.getAncestorLink();
            } else {
                int ancestorOnBranch;
                if (ancestorLink != null && ancestorLink.isDirect() && branch != null && (ancestorOnBranch = this.getAncestorOnBranch(ancestorLink, branch)) == -1) {
                    ancestorLink = new AncestorLink(AncestorLink.Type.BRANCHPOINT, (Iterable<Integer>)ancestorLink.getRevids());
                }
                this.updateAncestorLink(revid, ancestorLink);
            }
            if (ancestorLink != null && ancestorLink.isBranchPoint()) {
                IntListIterator ancestorOnBranch = ancestorLink.getRevids().iterator();
                while (ancestorOnBranch.hasNext()) {
                    int aid = (Integer)ancestorOnBranch.next();
                    this.addBranchpoints(aid, this.getAncestorOf(aid), Collections.singleton(branch));
                }
            }
            long pathid = this.stringTables.pathDB.add(ri.getPath().getPath());
            long fullpathid = this.addPathId(ri.getPath());
            long dirid = this.addPathId(ri.getPath().getParent());
            long lcfilenameid = this.stringTables.lcfilenameDB.add(ri.getPath().getName().toLowerCase(Locale.US));
            long cmtid = this.stringTables.commentDB.add(ri.getComment());
            EavEntityCu eav = this.makeEav(revid);
            y revkey = y.a().b(fullpathid).b(ri.getRevision());
            eav.updateValueIndex(CommonSchema.RevInfoIndexes.I_REVKEY, revkey);
            cu.f();
            cu.a(CommonSchema.E_PATH_ID_TO_REVID).b(fullpathid).b((long)revid);
            db.b(cu);
            cu.f();
            cu.a(CommonSchema.E_LCFILENAMEID_TO_REVID).b(lcfilenameid).b((long)revid);
            db.b(cu);
            Integer predecessor = null;
            if (!this.svnMode) {
                predecessor = ancestorLink == null || !ancestorLink.isDirect() ? this.findBestPredecessor(revid, fullpathid, branch) : Integer.valueOf(this.getAncestorOnBranch(ancestorLink, branch));
                if (predecessor != null) {
                    eav.updateInt(CommonSchema.RevInfo.A_PREDECESSOR, predecessor);
                    EavEntityCu preEav = this.makeEav(predecessor);
                    preEav.updateInt(CommonSchema.RevInfo.A_SUCCESSOR, revid);
                }
            } else if (ri.getPredecessor() != null) {
                predecessor = this.getRevId(ri.getPredecessor());
            }
            this.insertAuthor(revid, ri.getAuthor());
            eav.updateLongIndex(CommonSchema.RevInfoIndexes.I_DATE, ri.getDate());
            eav.updateLongIndex(CommonSchema.RevInfoIndexes.I_COMMENT, cmtid);
            eav.updateString(CommonSchema.RevInfo.A_BRANCH, branch);
            eav.updateLong(CommonSchema.RevInfo.A_FULLDIR, dirid);
            eav.updateLong(CommonSchema.RevInfo.A_PATHID, pathid);
            eav.updateBoolean(CommonSchema.RevInfo.A_ISBINARY, ri.isBinary());
            eav.updateBoolean(CommonSchema.RevInfo.A_IS_OVERSIZE, ri.isOversize());
            boolean isAdded = ri.isAdded() && !ri.isDead();
            boolean isDeleted = ri.isDead();
            eav.updateBoolean(CommonSchema.RevInfo.A_ISADDED, isAdded);
            this.updateBooleanIndex(CommonSchema.E_ISADDED_TO_REVID, isAdded, revid);
            eav.updateBoolean(CommonSchema.RevInfo.A_ISDELETED, isDeleted);
            this.updateBooleanIndex(CommonSchema.E_ISDELETED_TO_REVID, isDeleted, revid);
            eav.updateBoolean(CommonSchema.RevInfo.A_ISMOVED, ri.isMove());
            eav.updateBoolean(CommonSchema.RevInfo.A_ISCOPIED, ri.isCopy());
            eav.updateBoolean(CommonSchema.RevInfo.A_ISMODIFY, ri.isModify());
            eav.updateBoolean(CommonSchema.RevInfo.A_ISTRUNKLIKE, ri.isTrunkLike());
            eav.updateInt(CommonSchema.RevInfo.A_FILETYPE, ri.getFileType());
            if (ri.getTmpDiffAddedFile() != null) {
                eav.updateString(CommonSchema.RevInfo.A_TMP_DIFF_ADDED_FILE, ri.getTmpDiffAddedFile().toString());
            }
            if (ri.getTmpDiffRemovedFile() != null) {
                eav.updateString(CommonSchema.RevInfo.A_TMP_DIFF_REMOVED_FILE, ri.getTmpDiffRemovedFile().toString());
            }
            cu.f();
            if (ri.isBinaryOrOversize()) {
                if (predecessor != null) {
                    cu.b(0L).b(0L).b((long)this.getLineCount(predecessor));
                } else {
                    cu.b(0L).b(0L).b((long)ri.getLinesRemoved());
                }
            } else {
                cu.b((long)ri.getLineCount()).b((long)ri.getLinesAdded()).b((long)ri.getLinesRemoved());
            }
            eav.updateValue(CommonSchema.RevInfo.A_LINEDATA, cu);
            eav.updateInt(CommonSchema.RevInfo.A_LINECOUNT_STATE, ri.getLineCountState().getValue());
            String csid = ri.getChangeSetId();
            if (csid != null) {
                eav.updateStringIndex(CommonSchema.RevInfoIndexes.I_CSID, csid);
                this.incrementRevCount(db, csid);
            }
            cu.f();
            cu.a(CommonSchema.E_FULLDIR_TO_REVID);
            cu.b(dirid).b((long)revid);
            db.b(cu);
            this.updateParentPaths(ri, revid);
            if (storeSuffixPaths && !FishEyeSysProps.SUFFIX_PATHS_DISABLE && !isDeleted) {
                this.updateSuffixPaths(ri.getPath());
            }
            CommonDirInfoDAO diDao = new CommonDirInfoDAO(this.dbh, this.stringTables, this.caseSensitive);
            if (ri.getFileType() == 1) {
                diDao.addFileToParent(ri.getPath());
            } else if (ri.getFileType() == 2) {
                diDao.addDirToParent(ri.getPath());
            }
            if (this.svnMode) {
                this.updateSimpleRelationAttributes(eav, ri, revid, branch);
            } else {
                this.updateRevBranchAttributes(ri, revid, branch, ancestorLink, predecessor);
            }
            if (storeHunks) {
                this.setHunks(revid, ri.getHunks());
            }
            int n2 = revid;
            return n2;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
            y.c(cuAncestor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementRevCount(ac db, String csid) throws IOException {
        long revCount = 0L;
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_CSID_TO_REV_COUNT).b(csid);
            int countOffset = cu.e();
            if (db.a(cu, countOffset)) {
                revCount = cu.v(countOffset);
            }
            cu.d(countOffset).b(++revCount);
            db.e(cu, countOffset);
        }
        finally {
            y.c(cu);
        }
    }

    private void updateSimpleRelationAttributes(EavEntityCu eav, CommonFileRevisionInput ri, int revid, String branch) throws IOException {
        Integer predecessorId = null;
        RevInfoKey predecessor = ri.getPredecessor();
        if (predecessor != null) {
            predecessorId = this.getRevId(predecessor);
            eav.updateInt(CommonSchema.RevInfo.A_PREDECESSOR, predecessorId);
            EavEntityCu preEav = this.makeEav(predecessorId);
            long prePathId = preEav.getLong(CommonSchema.RevInfo.A_PATHID, -1L);
            Path prePath = new Path(this.stringTables.pathDB.get(prePathId));
            if (prePath.equals(ri.getPath())) {
                int oldSuccessor = preEav.getInt(CommonSchema.RevInfo.A_SUCCESSOR, -1);
                preEav.updateInt(CommonSchema.RevInfo.A_SUCCESSOR, revid);
                if (oldSuccessor != -1) {
                    EavEntityCu succEav = this.makeEav(oldSuccessor);
                    succEav.updateInt(CommonSchema.RevInfo.A_PREDECESSOR, revid);
                    eav.updateInt(CommonSchema.RevInfo.A_SUCCESSOR, oldSuccessor);
                }
            }
        }
        AncestorLink ancestorLink = ri.getAncestorLink();
        this.updateBranchHead(revid, ancestorLink, predecessorId, branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRevBranchAttributes(CommonFileRevisionInput ri, int revid, String branch, AncestorLink ancestorLink, Integer predecessor) throws IOException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            boolean modifiedOnBranch;
            boolean isAdded = ri.isAdded() && !ri.isDead();
            boolean isDeleted = ri.isDead();
            boolean bl = modifiedOnBranch = !this.svnMode || ancestorLink == null || !ancestorLink.isBranchPoint() || ri.isModify();
            if (branch != null) {
                if (modifiedOnBranch) {
                    cu.f().a(CommonSchema.E_MOD_ON_BRANCH_TO_REVID);
                    cu.b(branch).b((long)revid);
                    db.b(cu);
                } else {
                    cu.f().a(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID);
                    cu.b(branch).b((long)revid);
                    db.b(cu);
                }
                this.updateBranchHead(revid, ancestorLink, predecessor, branch);
                boolean isAddedOnBranch = ancestorLink != null ? (this.svnMode ? isAdded && ancestorLink.isDirect() : isAdded) : isAdded;
                if (isAddedOnBranch) {
                    this.copyBranchWithXBackward(CommonSchema.E_BRANCH_WITH_ADDS_TO_REVID, revid, branch);
                }
                if (isDeleted) {
                    this.copyBranchWithXBackward(CommonSchema.E_BRANCH_WITH_DELETES_TO_REVID, revid, branch);
                }
                if (predecessor != null) {
                    this.copyBranchWithXForward(CommonSchema.E_BRANCH_WITH_ADDS_TO_REVID, revid, predecessor, branch);
                    this.copyBranchWithXForward(CommonSchema.E_BRANCH_WITH_DELETES_TO_REVID, revid, predecessor, branch);
                }
            }
        }
        finally {
            y.c(cu);
        }
    }

    public void setBlameSpans(int revid, List<BlameChunk> spans) throws IOException, DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        cu.a(CommonSchema.E_BLAMESPANS).b((long)revid);
        int pl = cu.e();
        while (db.a(cu, pl)) {
            db.c(cu);
        }
        if (spans == null || spans.isEmpty()) {
            cu.f().a(CommonSchema.E_BLAMESPANS).b((long)revid);
            db.b(cu);
        } else {
            for (BlameChunk span : spans) {
                cu.f().a(CommonSchema.E_BLAMESPANS).b((long)revid).b((long)span.getStart()).b((long)span.getOriginalStartingLine()).b((long)span.getLength()).b((long)span.getRevId());
                db.b(cu);
            }
        }
    }

    public boolean hasBlameSpans(int revid) throws DbException {
        y cu = y.a();
        ac db = this.dbh.get();
        try {
            cu.a(CommonSchema.E_BLAMESPANS).b((long)revid);
            boolean bl = db.b(cu, cu.e());
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public List<BlameChunk> getBlameSpans(int revid) throws DbException {
        SortedList<BlameChunk> spans = new SortedList<BlameChunk>(new NaturalComparator());
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_BLAMESPANS).b((long)revid);
            int pk = cu.e();
            while (db.a(cu, pk)) {
                int start = (int)cu.v(pk);
                int offset = cu.w(pk);
                int origStartingLine = (int)cu.v(offset);
                offset = cu.w(offset);
                int spanLength = (int)cu.v(offset);
                offset = cu.w(offset);
                int revId = (int)cu.v(offset);
                BlameChunk span = new BlameChunk(start, origStartingLine, spanLength, revId);
                spans.add(span);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return spans;
    }

    public void setHunks(int revid, List<Hunk> hunks) throws DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_DIFFHUNKS).b((long)revid);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                db.c(cu);
            }
            if (hunks != null) {
                for (int index = 0; index < hunks.size(); index += 50) {
                    int endIndex = Math.min(hunks.size(), index + 50);
                    List<Hunk> subList = hunks.subList(index, endIndex);
                    cu.f().a(CommonSchema.E_DIFFHUNKS).b((long)revid).b((long)subList.size());
                    for (Hunk hunk : subList) {
                        cu.b((long)hunk.getFrom()).b((long)hunk.getFromCount()).b((long)hunk.getTo()).b((long)hunk.getToCount());
                    }
                    db.b(cu);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public List<Hunk> getHunks(int revid) throws DbException {
        SortedList<Hunk> hunks = new SortedList<Hunk>(Hunk.comp);
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_DIFFHUNKS).b((long)revid);
            int pk = cu.e();
            while (db.a(cu, pk)) {
                int length = (int)cu.v(pk);
                int offset = cu.w(pk);
                for (int i2 = 0; i2 < length; ++i2) {
                    int from = (int)cu.v(offset);
                    offset = cu.w(offset);
                    int fromCount = (int)cu.v(offset);
                    offset = cu.w(offset);
                    int to = (int)cu.v(offset);
                    offset = cu.w(offset);
                    int toCount = (int)cu.v(offset);
                    offset = cu.w(offset);
                    Hunk hunk = new Hunk(from, to, fromCount, toCount);
                    hunks.add(hunk);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return hunks;
    }

    private EavEntityCu getUpdateEAV(RevInfoKey key) throws DbException {
        int revid = this.getRevId(key);
        if (revid == -1) {
            throw new DbException("Unable to update revision " + key + " because it is not currently in the database");
        }
        return this.getUpdateEAV(revid);
    }

    private EavEntityCu getUpdateEAV(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Unable to update revid " + revid + " because it does not exist");
            }
            return eav;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateAuthor(int revid, String newAuthor) throws DbException {
        try {
            EavEntityCu eav = this.getUpdateEAV(revid);
            String oldAuthor = eav.getString(CommonSchema.RevInfo.A_AUTHOR, null);
            this.updateAuthorField(revid, oldAuthor, newAuthor);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateAuthorField(int revid, String oldAuthor, String newAuthor) throws DbException {
        if (Strings.isNullOrEmpty((String)oldAuthor)) {
            oldAuthor = DEFAULT_AUTHOR;
        }
        if (Strings.isNullOrEmpty((String)newAuthor)) {
            newAuthor = DEFAULT_AUTHOR;
        }
        if (oldAuthor.equals(newAuthor)) {
            return;
        }
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
            cu.a(CommonSchema.RevInfo.A_AUTHOR);
            int len = cu.e();
            cu.b(newAuthor);
            db.e(cu, len);
            cu.f();
            cu.a(CommonSchema.E_AUTHOR_TO_REVID);
            cu.b(oldAuthor.toLowerCase(Locale.US));
            cu.b((long)revid);
            db.c(cu);
            cu.f();
            cu.a(CommonSchema.E_AUTHOR_TO_REVID);
            cu.b(newAuthor.toLowerCase(Locale.US));
            cu.b((long)revid);
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateComment(int revid, String comment) throws DbException {
        try {
            long cmtid = this.stringTables.commentDB.add(comment);
            this.getUpdateEAV(revid).updateLongIndex(CommonSchema.RevInfoIndexes.I_COMMENT, cmtid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateLineCount(RevInfoKey key, int lineCount, int linesAdded, int linesRemoved, LineCountState state) throws DbException {
        try {
            this.updateLineCount(this.getUpdateEAV(key), lineCount, linesAdded, linesRemoved, state);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateLineCount(int revid, int lineCount, int linesAdded, int linesRemoved, LineCountState state) throws DbException {
        try {
            this.updateLineCount(this.getUpdateEAV(revid), lineCount, linesAdded, linesRemoved, state);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLineCount(EavEntityCu eav, int lineCount, int linesAdded, int linesRemoved, LineCountState state) throws IOException {
        y cu = y.a();
        try {
            cu.b((long)lineCount).b((long)linesAdded).b((long)linesRemoved);
            eav.updateValue(CommonSchema.RevInfo.A_LINEDATA, cu);
            eav.updateInt(CommonSchema.RevInfo.A_LINECOUNT_STATE, state.getValue());
        }
        finally {
            y.c(cu);
        }
    }

    public void updateDate(int revid, long newDate) throws DbException {
        try {
            EavEntityCu eav = this.getUpdateEAV(revid);
            eav.updateLongIndex(CommonSchema.RevInfoIndexes.I_DATE, newDate);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateCSID(int revid, String csid) throws DbException {
        try {
            if (csid != null) {
                EavEntityCu eav = this.makeEav(revid);
                eav.updateStringIndex(CommonSchema.RevInfoIndexes.I_CSID, csid);
                this.incrementRevCount(this.dbh.get(), csid);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateParentPaths(CommonFileRevisionInput ri, int revid) throws IOException, DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        Path path = ri.getPath();
        long fullpathid = this.getPathId(path);
        if (ri.getFileType() != 2) {
            path = path.getParent();
        }
        long date = ri.getDate();
        RevisionDateRange minmax = new RevisionDateRange();
        do {
            long parentid = this.addPathId(path);
            cu.f();
            cu.a(CommonSchema.E_PARENTPATHS_TO_REVID);
            cu.b(parentid).b((long)revid);
            db.b(cu);
            cu.f();
            cu.a(CommonSchema.E_PARENTPATHS_TO_PATHID);
            cu.b(parentid).b(fullpathid);
            db.b(cu);
            cu.f();
            cu.a(CommonSchema.DirInfo.ENTITY).b(parentid);
            cu.a(CommonSchema.DirInfo.A_SUBTREE_DATERANGE);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                minmax.readFromCursor(cu, pl);
            } else {
                minmax.reset();
            }
            if (!minmax.update(date, revid)) continue;
            cu.d(pl);
            minmax.writeToCursor(cu);
            db.e(cu, pl);
        } while ((path = path.isRoot() ? null : path.getParent()) != null);
    }

    public void updateSuffixPaths(Path path) throws IOException, DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        UniqueStringTable table = this.stringTables.suffixDB;
        long fullpathid = this.getPathId(path);
        do {
            long suffixid = this.addPathId(path, table);
            cu.f();
            cu.a(CommonSchema.E_SUFFIXPATHS_TO_PATHID);
            cu.b(suffixid).b(fullpathid);
            if (db.a_(cu)) break;
            db.b(cu);
        } while (!(path = path.getTailPath()).isRoot());
    }

    private Integer findBestPredecessor(int revid, long pathid, String branch) throws DbException {
        try {
            ac db = this.dbh.get();
            AndQuery3 q2 = new AndQuery3();
            q2.addClause(new TermQuery3(CommonSchema.E_PATH_ID_TO_REVID, pathid, null));
            if (branch != null) {
                OrQuery3 onBranch = new OrQuery3();
                onBranch.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, branch, null));
                onBranch.addClause(new TermQuery3(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, branch, null));
                q2.addClause(onBranch);
            }
            ac revids = q2.asItemSpace(new Query3Params(db, this.stringTables));
            y cu2 = y.a();
            y cu = y.a().j();
            while (revids.f(cu)) {
                int predecessorId = (int)cu.v(0);
                if (predecessorId == revid) continue;
                cu2.f().a(CommonSchema.RevInfo.ENTITY).b((long)predecessorId);
                cu2.a(CommonSchema.RevInfo.A_SUCCESSOR);
                int pl = cu2.e();
                if (db.a(cu2, pl)) continue;
                return predecessorId;
            }
            return null;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void insertAuthor(int revid, String author) throws IOException, DbException, LicensePolicyException {
        if (Strings.isNullOrEmpty((String)author)) {
            author = DEFAULT_AUTHOR;
        }
        ac db = this.dbh.get();
        y cu = y.a();
        cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
        cu.a(CommonSchema.RevInfo.A_AUTHOR).b(author);
        db.b(cu);
        cu.f();
        cu.a(CommonSchema.E_AUTHOR_TO_REVID);
        cu.b(author.toLowerCase(Locale.US));
        cu.b((long)revid);
        db.b(cu);
    }

    private void copyBranchWithXBackward(I entity, int revid, String branch) throws IOException, DbException {
        y cu = y.a();
        while (revid != -1) {
            ac db = this.dbh.get();
            cu.f();
            cu.a(entity).b(branch).b((long)revid);
            db.b(cu);
            Integer preid = this.getPredecessorOf(revid);
            if (preid == null) break;
            if (revid == preid) {
                throw new IllegalStateException("getPredecessorOf() triggered circular reference for revid: " + revid);
            }
            revid = preid;
        }
    }

    public String getBranchOf(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            return eav.getString(CommonSchema.RevInfo.A_BRANCH, null);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public AncestorLink getAncestorOf(int revid) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
            cu.a(CommonSchema.RevInfo.A_ANCESTOR_LINK);
            int pl = cu.e();
            if (db.a(cu, pl)) {
                return AncestorLink.fromCu(db, cu, pl);
            }
            return null;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public Integer getPredecessorOf(int revid) throws IOException, DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
        cu.a(CommonSchema.RevInfo.A_PREDECESSOR);
        int pl = cu.e();
        if (db.a(cu, pl)) {
            int prec = (int)cu.v(pl);
            if (prec == revid) {
                Logs.APP_LOG.warn((Object)("getPrecedessorOf returned the same value as an argument: " + revid + ". Please see issue https://jira.atlassian.com/browse/FE-5067"));
                return null;
            }
            return prec;
        }
        return null;
    }

    private void copyBranchWithXForward(I entity, int revid, int aid, String branch) throws IOException, DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        cu.a(entity).b(branch).b((long)aid);
        if (db.a_(cu)) {
            cu.f();
            cu.a(entity).b(branch).b((long)revid);
            db.b(cu);
        }
    }

    public void addBranchpoints(int revid, AncestorLink ancestorLink, Collection<String> branchpoints) throws DbException {
        try {
            Integer predecessor = this.getPredecessorOf(revid);
            ac db = this.dbh.get();
            y cu = y.a();
            y cu2 = y.a();
            cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
            cu.a(CommonSchema.RevInfo.A_BRANCH_POINTS);
            int pl = cu.e();
            for (String bp : branchpoints) {
                cu.d(pl);
                cu.b(bp);
                if (db.a_(cu)) continue;
                db.b(cu);
                if (this.svnMode) continue;
                cu2.f();
                cu2.a(CommonSchema.E_BP_ON_BRANCH_TO_REVID).b(bp);
                cu2.b((long)revid);
                db.b(cu2);
                this.updateBranchHead(revid, ancestorLink, predecessor, bp);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateBranchHead(int revid, AncestorLink ancestorLink, Integer predecessor, String branch) throws IOException, DbException {
        IntOpenHashSet oldHeads = new IntOpenHashSet();
        if (predecessor != null) {
            oldHeads.add((Object)predecessor);
        }
        if (ancestorLink != null && (ancestorLink.isDirect() || ancestorLink.isBranchPoint())) {
            oldHeads.addAll((IntCollection)ancestorLink.getRevids());
        }
        IntIterator intIterator = oldHeads.iterator();
        while (intIterator.hasNext()) {
            int oldHead = (Integer)intIterator.next();
            this.deleteBranchHeadInfo(oldHead, branch);
        }
        ac db = this.dbh.get();
        y cu = y.a();
        cu.a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID);
        cu.b(branch);
        cu.b((long)revid);
        db.b(cu);
        cu.f().a(CommonSchema.E_REVID_TO_HEAD_IN_BRANCHES).b((long)revid).b(this.stringTables.branchDB.find(branch));
        db.b(cu);
        cu.f().a(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS).b((long)revid);
        db.b(cu);
    }

    public void deleteBranchHeadInfo(int revid, String branch) throws IOException, DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        cu.a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID);
        cu.b(branch);
        cu.b((long)revid);
        if (db.a_(cu)) {
            db.c(cu);
            cu.f().a(CommonSchema.E_REVID_TO_HEAD_IN_BRANCHES).b((long)revid).b(this.stringTables.branchDB.find(branch));
            db.c(cu);
            if (!this.isHeadInAnyBranch(revid)) {
                cu.f().a(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS).b((long)revid);
                db.c(cu);
            }
        }
    }

    private boolean isHeadInAnyBranch(int revid) throws IOException, DbException {
        ac db = this.dbh.get();
        y cu = y.a();
        y cu2 = y.a();
        cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid).a(CommonSchema.RevInfo.A_BRANCH);
        int cupl = cu.e();
        if (db.a(cu, cupl)) {
            String br = cu.m(cupl);
            cu2.f().a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).b(br).b((long)revid);
            if (db.a_(cu2)) {
                return true;
            }
        }
        cu.f();
        cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid).a(CommonSchema.RevInfo.A_BRANCH_POINTS);
        cupl = cu.e();
        while (db.a(cu, cupl)) {
            String pb = cu.m(cupl);
            cu2.f().a(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).b(pb).b((long)revid);
            if (!db.a_(cu2)) continue;
            return true;
        }
        return false;
    }

    private void updateBooleanIndex(I idx, boolean val, int revid) throws IOException, DbException {
        ac db = this.dbh.get();
        if (val) {
            y cu = y.a();
            cu.a(idx).b((long)revid);
            db.b(cu);
        }
    }

    public void addTagData(int revid, String tag) throws DbException {
        ac db = this.dbh.get();
        try {
            long tagid = this.stringTables.tagDB.add(tag);
            y cu = y.a();
            cu.f();
            cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
            cu.a(CommonSchema.RevInfo.A_TAGS).b(tagid);
            db.b(cu);
            cu.f().a(CommonSchema.E_TAG_TO_REVID).b(tagid).b((long)revid);
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void removeTagData(int revid, String tag) throws DbException {
        ac db = this.dbh.get();
        try {
            long tagid = this.stringTables.tagDB.find(tag);
            if (tagid != -1L) {
                y cu = y.a();
                cu.f().a(CommonSchema.E_TAG_TO_REVID).b(tagid).b((long)revid);
                db.c(cu);
                cu.f();
                cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
                cu.a(CommonSchema.RevInfo.A_TAGS).b(tagid);
                db.c(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void removeTag(String tag) throws DbException {
        ac db = this.dbh.get();
        try {
            long tagid = this.stringTables.tagDB.find(tag);
            if (tagid == -1L) {
                return;
            }
            y cu = y.a();
            cu.a(CommonSchema.E_TAG_TO_REVID).b(tagid);
            int pl = cu.e();
            y cu2 = y.a();
            while (db.a(cu, pl)) {
                int revid = (int)cu.v(pl);
                cu2.f().a(CommonSchema.RevInfo.ENTITY).b((long)revid);
                cu2.a(CommonSchema.RevInfo.A_TAGS).b(tagid);
                db.c(cu2);
                db.c(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateTagData(int revid, Collection<String> tags) throws DbException {
        try {
            long tagid;
            ac db = this.dbh.get();
            y cu = y.a();
            LongOpenHashSet tagids = new LongOpenHashSet();
            for (String tag : tags) {
                tagid = this.stringTables.tagDB.add(tag);
                tagids.add(tagid);
                cu.f();
                cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
                cu.a(CommonSchema.RevInfo.A_TAGS).b(tagid);
                if (db.a_(cu)) continue;
                db.b(cu);
                cu.f().a(CommonSchema.E_TAG_TO_REVID).b(tagid).b((long)revid);
                db.b(cu);
            }
            y cu2 = y.a();
            cu.f();
            cu.a(CommonSchema.RevInfo.ENTITY).b((long)revid);
            cu.a(CommonSchema.RevInfo.A_TAGS);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                tagid = cu.v(pl);
                if (tagids.contains(tagid)) continue;
                db.c(cu);
                cu2.f().a(CommonSchema.E_TAG_TO_REVID).b(tagid).b((long)revid);
                db.c(cu2);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public EavEntityCu makeEav(int revid) throws DbException {
        ac db = this.dbh.get();
        return new EavEntityCu(db, CommonSchema.RevInfo.ENTITY, revid);
    }

    private int allocateNewRevID() throws IOException, DbException {
        y cu = y.a();
        cu.a(CommonSchema.RevInfo.ENTITY);
        int id = this.allocateId(cu);
        cu.f().a(CommonSchema.RevInfo.ENTITY).b((long)id);
        ac db = this.dbh.get();
        db.b(cu);
        return id;
    }

    public int getLatestRevid() throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            cu.a(CommonSchema.RevInfo.ENTITY);
            int pl = cu.e();
            cu.j();
            if (db.c(cu, pl)) {
                return (int)cu.v(pl);
            }
            return -1;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private int allocateId(y cu) throws DbException, IOException {
        ac db = this.dbh.get();
        int p1 = cu.e();
        cu.j();
        long id = db.c(cu, p1) ? cu.v(p1) + 1L : 1L;
        return (int)id;
    }

    public void addRevidLongIndex(I entityClass, long indexValue, int revid) throws DbException {
        try {
            ac db = this.dbh.get();
            db.b(y.a().a(entityClass).b(indexValue).b((long)revid));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public SortedIntSet getRevidsInLongIndexRange(I entityClass, long fromValue, long toValue) throws DbException {
        try {
            long value;
            ac db = this.dbh.get();
            SegmentedIntSet result = new SegmentedIntSet();
            y cu = y.a().a(entityClass);
            int keyLength = cu.e();
            cu.b(fromValue);
            while (db.a(cu, keyLength) && (value = cu.v(keyLength)) <= toValue) {
                int revid = (int)cu.v(cu.w(keyLength));
                result.set(revid);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public LongLinkedOpenHashSet getLongIndexKeyRange(I entityClass, long fromValue, long toValue) throws DbException {
        try {
            long value;
            ac db = this.dbh.get();
            LongLinkedOpenHashSet result = new LongLinkedOpenHashSet();
            y cu = y.a().a(entityClass);
            int keyLength = cu.e();
            cu.b(fromValue);
            while (db.a(cu, keyLength) && (value = cu.v(keyLength)) <= toValue) {
                result.add(value);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public IntList getIndexedRevIds(I entityClass, long indexValue) throws DbException {
        try {
            ac db = this.dbh.get();
            IntArrayList result = new IntArrayList();
            y index = y.a().a(entityClass).b(indexValue);
            int pl = index.e();
            while (db.a(index, pl)) {
                int revid = (int)index.v(pl);
                result.add(revid);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addPathLongProperty(I entityClass, Path path, long ... values) throws DbException {
        try {
            ac db = this.dbh.get();
            long pathId = this.getPathId(path);
            if (pathId == -1L) {
                throw new DbException("Unable to find path " + path + ", not in database");
            }
            y cu = y.a().a(entityClass);
            cu.b(pathId);
            for (long value : values) {
                cu.b(value);
            }
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getPathLargestProperty(I entityClass, Path path, long limitValue, long defaultValue) throws DbException {
        try {
            ac db = this.dbh.get();
            long value = defaultValue;
            long pathId = this.getPathId(path);
            if (pathId != -1L) {
                y pathIndex = y.a().a(entityClass).b(pathId);
                int pl = pathIndex.e();
                if (limitValue != -1L) {
                    pathIndex.b(limitValue + 1L);
                } else {
                    pathIndex.j();
                }
                if (db.c(pathIndex, pl)) {
                    value = pathIndex.v(pl);
                }
            }
            return value;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addRevIdLongProperty(I propertyClass, int revid, long value) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(propertyClass);
            cu.b((long)revid).b(value);
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getLongProperty(I propertyClass, int revid, long defaultValue) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            int length = cu.f().a(propertyClass).b((long)revid).e();
            long value = defaultValue;
            if (db.a(cu, length)) {
                value = cu.v(length);
            }
            return value;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public SortedIntSet getLongProperySet(I propertyClass, SortedIntSet revids) throws DbException {
        try {
            ac db = this.dbh.get();
            SegmentedIntSet result = new SegmentedIntSet();
            y cu = y.a();
            int revid = revids.nextSetBit(0);
            while (revid >= 0) {
                int length = cu.f().a(propertyClass).b((long)revid).e();
                if (db.a(cu, length)) {
                    long value = cu.v(length);
                    result.set((int)value);
                }
                revid = revids.nextSetBit(revid + 1);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getFileType(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Attempt to load file type from non existent revid = " + revid);
            }
            return eav.getInt(CommonSchema.RevInfo.A_FILETYPE, 1);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean isDeleted(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Attempt to load isDeleted from non existent revid = " + revid);
            }
            return eav.getBoolean(CommonSchema.RevInfo.A_ISDELETED, true);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getLineCount(int revid) throws DbException {
        try {
            int lineCount = 0;
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Attempt to load line count from non existent revid = " + revid);
            }
            y cu = y.a();
            if (eav.getValue(CommonSchema.RevInfo.A_LINEDATA, cu)) {
                int pl = 0;
                lineCount = (int)cu.v(pl);
            }
            return lineCount;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean isBinary(int revid) throws DbException {
        return this.getBooleanAttribute(revid, CommonSchema.RevInfo.A_ISBINARY, false);
    }

    public boolean isAdded(int revid) {
        return this.getBooleanAttribute(revid, CommonSchema.RevInfo.A_ISADDED, false);
    }

    public boolean isMoved(int revid) {
        return this.getBooleanAttribute(revid, CommonSchema.RevInfo.A_ISMOVED, false);
    }

    public boolean isModify(int revid) {
        return this.getBooleanAttribute(revid, CommonSchema.RevInfo.A_ISMODIFY, false);
    }

    public boolean isCopy(int revid) {
        return this.getBooleanAttribute(revid, CommonSchema.RevInfo.A_ISCOPIED, false);
    }

    public boolean isFile(int revid) {
        return this.getFileType(revid) == 1;
    }

    public boolean isDir(int revid) {
        return this.getFileType(revid) == 2;
    }

    public boolean isOversize(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Attempt to load isOversize from non existent revid = " + revid);
            }
            y cu = y.a();
            if (eav.getValue(CommonSchema.RevInfo.A_IS_OVERSIZE, cu)) {
                return cu.s(0);
            }
            return false;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public LineCountState getLineCountState(int revid) {
        return this.getLineCountState(this.makeEav(revid));
    }

    private LineCountState getLineCountState(EavEntityCu eav) {
        try {
            int lineCountStateValue = eav.getInt(CommonSchema.RevInfo.A_LINECOUNT_STATE, LineCountState.FULL.getValue());
            return LineCountState.getState(lineCountStateValue);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateTmpDiffAddedFile(RevInfoKey key, File contentFile) throws DbException {
        if (contentFile != null) {
            try {
                EavEntityCu eav = this.getUpdateEAV(key);
                eav.updateString(CommonSchema.RevInfo.A_TMP_DIFF_ADDED_FILE, contentFile.toString());
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
    }

    public void deleteTmpDiffAddedFiles(int revid) throws DbException {
        EavEntityCu eav = this.getUpdateEAV(revid);
        try {
            eav.deleteValues(CommonSchema.RevInfo.A_TMP_DIFF_ADDED_FILE);
            eav.deleteValues(CommonSchema.RevInfo.A_TMP_DIFF_REMOVED_FILE);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public Path getPath(long pathId) throws DbException {
        return new Path(this.stringTables.pathDB.get(pathId));
    }

    public List<Integer> orderRevisions(Iterable<Integer> revIds, boolean collapseBranches) throws DbException {
        if (collapseBranches) {
            return this.orderAndCollapseRevisions(revIds);
        }
        return this.orderRevisions(revIds);
    }

    private List<Integer> orderRevisions(Iterable<Integer> revIds) throws DbException {
        TreeMap map = new TreeMap(Collections.reverseOrder());
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(CommonSchema.RevInfo.ENTITY);
            int atHeads = cu.e();
            for (Integer revId : revIds) {
                cu.b(revId).a(CommonSchema.RevInfo.A_DATE);
                int dateOffset = cu.e();
                if (db.a(cu, dateOffset)) {
                    long date = cu.v(dateOffset);
                    map.put(date, revId);
                }
                cu.d(atHeads);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return new ArrayList<Integer>(map.values());
    }

    private List<Integer> orderAndCollapseRevisions(Iterable<Integer> revIds) throws DbException {
        TreeMap<Long, Pair<String, Integer>> map = new TreeMap<Long, Pair<String, Integer>>(Collections.reverseOrder());
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(CommonSchema.RevInfo.ENTITY);
            int atHeads = cu.e();
            for (Integer revId : revIds) {
                cu.b(revId);
                int atRevision = cu.e();
                String branch = null;
                long date = 0L;
                cu.a(CommonSchema.RevInfo.A_BRANCH);
                int branchOffset = cu.e();
                if (db.a(cu, branchOffset)) {
                    branch = cu.m(branchOffset);
                }
                cu.d(atRevision).a(CommonSchema.RevInfo.A_DATE);
                int dateOffset = cu.e();
                if (db.a(cu, dateOffset)) {
                    date = cu.v(dateOffset);
                }
                if (branch != null || date > 0L) {
                    map.put(date, Pair.newInstance(branch, revId));
                }
                cu.d(atHeads);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return this.collapse(map);
    }

    private List<Integer> collapse(SortedMap<Long, Pair<String, Integer>> map) {
        LinkedHashMap<String, Integer> topRevisions = new LinkedHashMap<String, Integer>(map.size());
        for (Map.Entry<Long, Pair<String, Integer>> entry : map.entrySet()) {
            String branch = entry.getValue().getFirst();
            if (topRevisions.containsKey(branch)) continue;
            Integer revId = entry.getValue().getSecond();
            topRevisions.put(branch, revId);
        }
        return new ArrayList<Integer>(topRevisions.values());
    }

    public <F extends FileRevision> Iterator<F> getRevisionIterator(String csid, final FileRevisionDAO<F> dao) {
        final ac db = this.dbh.get();
        final y cu = y.a().b(csid);
        final y val = y.a();
        try {
            final boolean[] hasNext = new boolean[]{CommonSchema.RevInfoIndexes.I_CSID.nextInIndex(db, cu, val)};
            return new Iterator<F>(){

                @Override
                public boolean hasNext() {
                    return hasNext[0];
                }

                @Override
                public F next() {
                    if (hasNext[0]) {
                        int revid = (int)val.v(0);
                        try {
                            hasNext[0] = CommonSchema.RevInfoIndexes.I_CSID.nextInIndex(db, cu, val);
                            return dao.loadLazy(revid);
                        }
                        catch (IOException e2) {
                            throw new DbException(e2);
                        }
                    }
                    hasNext[0] = false;
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateRevisionRelationships(int revid, CommonFileRevision revision) throws DbException {
        try {
            AncestorLink ancestorLink = revision.getAncestorLink();
            this.updateAncestorLink(revid, ancestorLink);
            Integer predecessorId = null;
            if (revision.getPredecessor() != null) {
                predecessorId = this.getRevId(revision.getPredecessor());
                this.makeEav(revid).updateInt(CommonSchema.RevInfo.A_PREDECESSOR, predecessorId);
                EavEntityCu preEav = this.makeEav(predecessorId);
                long prePathId = preEav.getLong(CommonSchema.RevInfo.A_PATHID, -1L);
                Path prePath = new Path(this.stringTables.pathDB.get(prePathId));
                if (prePath.equals(revision.getPath())) {
                    preEav.updateInt(CommonSchema.RevInfo.A_SUCCESSOR, revid);
                }
            }
            this.updateRevBranchAttributes(revision, revision.getRevID(), revision.getBranch(), revision.getAncestorLink(), predecessorId);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateAncestorLink(int revid, AncestorLink link) {
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            SimpleIndex ancestorLinkIndex = CommonSchema.RevInfoIndexes.I_ANCESTORLINK;
            y pk = this.makeEav(revid).getPk();
            ancestorLinkIndex.clear(db, pk);
            if (link != null) {
                IntListIterator intListIterator = link.getRevids().iterator();
                while (intListIterator.hasNext()) {
                    int arevid = (Integer)intListIterator.next();
                    cu.f().b((long)arevid).b((long)link.getType().getValue());
                    ancestorLinkIndex.insert(db, pk, cu);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public void updateDead(int revid, boolean dead) {
        try {
            this.makeEav(revid).updateBoolean(CommonSchema.RevInfo.A_ISDELETED, dead);
            this.updateBooleanIndex(CommonSchema.E_ISDELETED_TO_REVID, dead, revid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateAdded(int revid, boolean added) {
        try {
            this.makeEav(revid).updateBoolean(CommonSchema.RevInfo.A_ISADDED, added);
            this.updateBooleanIndex(CommonSchema.E_ISADDED_TO_REVID, added, revid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateMoved(int revid, boolean move) {
        try {
            this.makeEav(revid).updateBoolean(CommonSchema.RevInfo.A_ISMOVED, move);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void setLongAttribute(int revid, p attribute, long value) {
        try {
            this.makeEav(revid).updateLong(attribute, value);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void setBooleanAttribute(int revid, p attribute, boolean value) {
        try {
            this.makeEav(revid).updateBoolean(attribute, value);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getLongAttribute(int revid, p attribute, long defaultValue) {
        try {
            return this.makeEav(revid).getLong(attribute, defaultValue);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean getBooleanAttribute(int revid, p attribute, boolean defaultValue) {
        try {
            return this.makeEav(revid).getBoolean(attribute, defaultValue);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateModify(int revid, boolean modify) {
        try {
            this.makeEav(revid).updateBoolean(CommonSchema.RevInfo.A_ISMODIFY, modify);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateCopied(int revid, boolean copy) {
        try {
            this.makeEav(revid).updateBoolean(CommonSchema.RevInfo.A_ISCOPIED, copy);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateBinary(int revid, boolean binary) {
        try {
            this.makeEav(revid).updateBoolean(CommonSchema.RevInfo.A_ISBINARY, binary);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateOversize(int revid, boolean oversize) {
        try {
            this.makeEav(revid).updateBoolean(CommonSchema.RevInfo.A_IS_OVERSIZE, oversize);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateFileType(int revid, int filetype) {
        try {
            long pathid;
            EavEntityCu eav = this.makeEav(revid);
            eav.updateInt(CommonSchema.RevInfo.A_FILETYPE, filetype);
            if (filetype == 2 && (pathid = eav.getLong(CommonSchema.RevInfo.A_PATHID, -1L)) != -1L) {
                Path path = new Path(this.stringTables.pathDB.get(pathid));
                CommonDirInfoDAO diDao = new CommonDirInfoDAO(this.dbh, this.stringTables, this.caseSensitive);
                diDao.updateToDir(path);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateDiffFiles(int revid, File tmpDiffAddedFile, File tmpDiffRemovedFile) {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (tmpDiffAddedFile != null) {
                eav.updateString(CommonSchema.RevInfo.A_TMP_DIFF_ADDED_FILE, tmpDiffAddedFile.getAbsolutePath());
            } else {
                eav.updateString(CommonSchema.RevInfo.A_TMP_DIFF_ADDED_FILE, null);
            }
            if (tmpDiffRemovedFile != null) {
                eav.updateString(CommonSchema.RevInfo.A_TMP_DIFF_REMOVED_FILE, tmpDiffRemovedFile.getAbsolutePath());
            } else {
                eav.updateString(CommonSchema.RevInfo.A_TMP_DIFF_REMOVED_FILE, null);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void visitRevisionTree(Path path, I selectorClass, long selectorValue, DirectoryTreeVisitor v2) throws DbException {
        try {
            long fileId;
            ac db = this.dbh.get();
            ag pathids = null;
            long dirId = this.getPathId(path);
            if (dirId != -1L) {
                pathids = new ag(db, y.a().a(CommonSchema.E_PARENTPATHS_TO_PATHID).b(dirId));
                this.visitDirectoryTree(pathids, selectorClass, selectorValue, v2);
            }
            if ((fileId = this.getPathId(path)) != -1L) {
                boolean alreadyVisited;
                y cu = y.a().b(fileId);
                boolean bl = alreadyVisited = pathids != null && pathids.a_(cu);
                if (!alreadyVisited) {
                    this.visitPathInTree(cu, fileId, selectorClass, selectorValue, v2);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void visitDirectoryTree(ac pathids, I selectorClass, long selectorValue, DirectoryTreeVisitor v2) throws IOException, DbException {
        y cu = y.a();
        y cu2 = y.a();
        while (pathids.d(cu)) {
            long pathId = cu.v(0);
            this.visitPathInTree(cu2, pathId, selectorClass, selectorValue, v2);
        }
    }

    private void visitPathInTree(y cu, long pathId, I selectorClass, long selectorValue, DirectoryTreeVisitor v2) throws IOException, DbException {
        ac db = this.dbh.get();
        cu.f().a(selectorClass).b(pathId);
        int pl = cu.e();
        cu.b(selectorValue);
        if (db.d(cu, pl)) {
            long csid = cu.v(pl);
            v2.visit(pathId, csid);
        }
    }

    public Map<String, Integer> getPathRevisions(Path path) throws DbException {
        ac db = this.dbh.get();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try {
            long pathId = this.getPathId(path);
            if (pathId != -1L) {
                y cu = y.a();
                cu.a(CommonSchema.E_REVKEY_TO_REVID);
                cu.b(pathId);
                int pl = cu.e();
                while (db.a(cu, pl)) {
                    String revision = cu.m(pl);
                    int revid = (int)cu.v(cu.n(pl));
                    result.put(revision, revid);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    public Set<Integer> getReviewsForChangeset(String csid) throws DbException {
        final LinkedHashSet<Integer> reviews = new LinkedHashSet<Integer>();
        final y cu = y.a();
        final ac db = this.dbh.get();
        this.searchChangeSetRevids(csid, new Predicate<Integer>(){

            public boolean apply(@Nullable Integer revid) {
                cu.f().a(CommonSchema.RevInfo.ENTITY).b(revid).a(CommonSchema.RevInfo.A_REVIEWIDS);
                int pl = cu.e();
                try {
                    while (db.a(cu, pl)) {
                        int reviewid = (int)cu.v(pl);
                        reviews.add(reviewid);
                    }
                }
                catch (IOException e2) {
                    throw new DbException(e2);
                }
                return false;
            }
        });
        return reviews;
    }

    public void deleteAttribteOnAllRevisions(p attr) throws DbException {
        try {
            ac db = this.dbh.get();
            J revs = new J(db, y.a(CommonSchema.RevInfo.ENTITY));
            y cu = y.a();
            y row = y.a();
            while (revs.d(cu)) {
                int revid = (int)cu.v(0);
                row.f().a(CommonSchema.RevInfo.ENTITY).b((long)revid).a(attr);
                db.c((Object)row);
                db.c(row);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getPathId(Path path) throws DbException {
        UniqueStringTable table = this.stringTables.pathDB;
        return this.getPathId(path, table);
    }

    public long getPathId(Path path, UniqueStringTable table) throws DbException {
        long pathId = this.caseSensitive ? table.find(path.getPath()) : table.find(path.getPath().toLowerCase(Locale.US));
        return pathId;
    }

    public long addPathId(Path path) throws DbException {
        UniqueStringTable table = this.stringTables.pathDB;
        return this.addPathId(path, table);
    }

    private long addPathId(Path path, UniqueStringTable table) throws DbException {
        long pathId = this.caseSensitive ? table.add(path.getPath()) : table.add(path.getPath().toLowerCase(Locale.US));
        return pathId;
    }

    public String getAuthorOfRevision(int revid) throws DbException {
        EavEntityCu eav = this.makeEav(revid);
        if (eav == null) {
            return null;
        }
        try {
            return eav.getString(CommonSchema.RevInfo.A_AUTHOR, null);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDate(int revid) throws DbException {
        y cu = y.a(CommonSchema.RevInfo.ENTITY).b((long)revid).a(CommonSchema.RevInfo.A_DATE);
        try {
            int valueOffset = cu.e();
            try {
                if (this.dbh.get().a(cu, valueOffset)) {
                    long l2 = cu.v(valueOffset);
                    return l2;
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            long l3 = 0L;
            return l3;
        }
        finally {
            cu.b();
        }
    }

    public RevInfoKey searchAncestors(RevInfoKey revInfoKey, Predicate<RevInfoKey> predicate, final boolean predecessorFirst) throws DbException {
        Function<RevInfoKey, Collection<RevInfoKey>> ancestorProvider = new Function<RevInfoKey, Collection<RevInfoKey>>(){

            public Collection<RevInfoKey> apply(RevInfoKey from) {
                try {
                    int revid = CommonRevInfoDAO.this.getRevId(from);
                    if (revid != -1) {
                        AncestorLink aLink;
                        ArrayList<RevInfoKey> ancestors = new ArrayList<RevInfoKey>();
                        if (predecessorFirst) {
                            CommonRevInfoDAO.this.addPredecessor(revid, ancestors);
                        }
                        if ((aLink = CommonRevInfoDAO.this.getAncestorOf(revid)) != null && !aLink.getRevids().isEmpty()) {
                            for (int i2 = 0; i2 < aLink.getRevids().size(); ++i2) {
                                ancestors.add(CommonRevInfoDAO.this.getKey(aLink.getRevids().getInt(i2)));
                            }
                        } else if (!predecessorFirst) {
                            CommonRevInfoDAO.this.addPredecessor(revid, ancestors);
                        }
                        return ancestors;
                    }
                    return Collections.emptyList();
                }
                catch (IOException e2) {
                    throw new DbException(e2);
                }
            }
        };
        GraphIterator<RevInfoKey> it = GraphUtils.iterateBreadthFirst((Collection)ancestorProvider.apply((Object)revInfoKey), ancestorProvider, Functions.identity());
        while (it.hasNext()) {
            RevInfoKey key = (RevInfoKey)it.next();
            if (!predicate.apply((Object)key)) continue;
            return key;
        }
        return null;
    }

    private void addPredecessor(int revid, Collection<RevInfoKey> ancestors) throws IOException {
        Integer predId = this.getPredecessorOf(revid);
        if (predId != null && predId != -1) {
            ancestors.add(this.getKey(predId));
        }
    }

    public static interface DirectoryTreeVisitor {
        public void visit(long var1, long var3) throws DbException;
    }
}

