/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.Query3Params;
import com.cenqua.fisheye.infinitydb.query3.TermLookupQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.n;
import com.cenqua.obfuscate.idb.y;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class CommonQuery3Helper {
    public static BooleanQuery findRevisionsUnderDirQuery(Path dir) {
        BooleanQuery query = new BooleanQuery();
        String dirpath = dir == null ? "" : dir.getPath();
        query.add((Query)new TermQuery(new Term("parentpaths", dirpath)), BooleanClause.Occur.MUST);
        return query;
    }

    public static AndQuery3 findRevisionsUnderDirAndQuery3(Path dir, boolean caseSensitive) {
        AndQuery3 query = new AndQuery3();
        String dirpath = dir == null ? "" : dir.getPath(caseSensitive);
        query.addClause(new TermLookupQuery3(CommonSchema.E_PATHS, CommonSchema.E_PARENTPATHS_TO_REVID, dirpath, null));
        return query;
    }

    public static AndQuery3 findRevisionsUnderDirAndBranchAndQuery3(Path dir, String branch, boolean caseSensitive) {
        AndQuery3 query = CommonQuery3Helper.findRevisionsUnderDirAndQuery3(dir, caseSensitive);
        if (!Strings.isNullOrEmpty((String)branch)) {
            query.addClause(CommonQuery3Helper.onBranchQuery3(branch));
        }
        return query;
    }

    private static OrQuery3 onBranchQuery3(String branch) {
        OrQuery3 onBranch = new OrQuery3();
        onBranch.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, branch, null));
        onBranch.addClause(new TermQuery3(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, branch, null));
        onBranch.addClause(new TermQuery3(CommonSchema.E_BP_ON_BRANCH_TO_REVID, branch, null));
        return onBranch;
    }

    public static Query3 branchPointQuery3(String branch) {
        return new TermQuery3(CommonSchema.E_BP_ON_BRANCH_TO_REVID, branch, null);
    }

    public static Query3 atTagQuery3(String tag) {
        return new TermLookupQuery3(CommonSchema.E_TAGS, CommonSchema.E_TAG_TO_REVID, tag, null);
    }

    public static Query3 headOnBranchQuery3(String branch) {
        return new TermQuery3(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID, branch, null);
    }

    public static Query3 headOnAnyBranchQuery3() {
        return new TermQuery3(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS, y.a(), null);
    }

    public static AndQuery3 findHeadRevisionsInDirAndBranchAndQuery3(Path dir, String branch, boolean caseSensitive) {
        AndQuery3 query = CommonQuery3Helper.findRevisionsInDirQuery3(dir, caseSensitive);
        if (!Strings.isNullOrEmpty((String)branch)) {
            query.addClause(CommonQuery3Helper.headOnBranchQuery3(branch));
        }
        return query;
    }

    public static AndQuery3 findRevisionsInDirAndTagAndQuery3(Path dir, String tag, boolean caseSensitive) {
        AndQuery3 query = CommonQuery3Helper.findRevisionsInDirQuery3(dir, caseSensitive);
        if (!Strings.isNullOrEmpty((String)tag)) {
            query.addClause(CommonQuery3Helper.atTagQuery3(tag));
        }
        return query;
    }

    public static AndQuery3 findRevisionsInDirQuery3(Path dir, boolean caseSensitive) {
        AndQuery3 query = new AndQuery3();
        String dirpath = dir == null ? "" : dir.getPath(caseSensitive);
        query.addClause(new TermLookupQuery3(CommonSchema.E_PATHS, CommonSchema.E_FULLDIR_TO_REVID, dirpath, null));
        return query;
    }

    public static AndQuery3 findRevisionsAtPathQuery3(Path path, boolean caseSensitive) {
        AndQuery3 query = new AndQuery3();
        String p2 = path == null ? "" : path.getPath(caseSensitive);
        query.addClause(new TermLookupQuery3(CommonSchema.E_PATHS, CommonSchema.E_PATH_ID_TO_REVID, p2, null));
        return query;
    }

    public static AndQuery3 findHeadRevisionsAtPathAndBranchQuery3(Path path, String branch, boolean caseSensitive) {
        AndQuery3 query = CommonQuery3Helper.findRevisionsAtPathQuery3(path, caseSensitive);
        if (!Strings.isNullOrEmpty((String)branch)) {
            query.addClause(CommonQuery3Helper.headOnBranchQuery3(branch));
        }
        return query;
    }

    public static AndQuery3 findRevisionsAtPathAndTagQuery3(Path path, String tag, boolean caseSensitive) {
        AndQuery3 query = CommonQuery3Helper.findRevisionsAtPathQuery3(path, caseSensitive);
        if (!Strings.isNullOrEmpty((String)tag)) {
            query.addClause(CommonQuery3Helper.atTagQuery3(tag));
        }
        return query;
    }

    public static AndQuery3 findRevisionsAtPathBranchQuery3(Path path, String branch, boolean caseSensitive) {
        AndQuery3 query = CommonQuery3Helper.findRevisionsAtPathQuery3(path, caseSensitive);
        if (!Strings.isNullOrEmpty((String)branch)) {
            query.addClause(CommonQuery3Helper.onBranchQuery3(branch));
        }
        return query;
    }

    public static AndQuery3 findRevisionsForFilenameQuery3(String filename) {
        AndQuery3 query = new AndQuery3();
        query.addClause(new TermLookupQuery3(CommonSchema.E_LCFILENAMES, CommonSchema.E_LCFILENAMEID_TO_REVID, filename.toLowerCase(Locale.US), null));
        return query;
    }

    public static Query3 findDeletedRevisionsQuery3() {
        return new TermQuery3(CommonSchema.E_ISDELETED_TO_REVID, y.a(), null);
    }

    public static void visitMatchingStringTerms(ac db, CommonStringTables commonStringTables, Query3 q2, I entity, StringVisitor v2) throws DbException {
        try {
            Query3Params query3Params = new Query3Params(db, commonStringTables);
            ac constraint = q2.asItemSpace(query3Params);
            y cu2 = y.a();
            y cu = y.a();
            cu.a(entity);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                boolean cont;
                String term = cu.m(pl);
                int p2 = cu.n(pl);
                cu.d(p2).j();
                TermQuery3 termq = new TermQuery3(entity, term, null);
                n termspace = new n();
                termspace.g(constraint);
                termspace.g(termq.asItemSpace(query3Params));
                cu2.f();
                if (!termspace.d(cu2) || (cont = v2.visit(term))) continue;
                break;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public static interface StringVisitor {
        public boolean visit(String var1);
    }
}

