/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fecru.search.index.model.ContentDocInfo;
import com.atlassian.fecru.search.index.model.DiffDocInfo;
import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.IndexableFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexWriter;

public class CommonIndexer {
    @Nullable
    private Reader getReaderForDiffFile(File diffFile, long maxIndexableSize, String diffName) {
        if (diffFile != null && diffFile.exists()) {
            if (diffFile.length() >= maxIndexableSize) {
                Logs.APP_LOG.debug((Object)String.format("%s diff exceeds indexing size limit (%s, limit is %s). This diff won't be searchable in FishEye.", diffName, FileUtils.formatFileSize(diffFile.length()), FileUtils.formatFileSize(maxIndexableSize)));
                return null;
            }
            return this.getFileReader(diffFile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNewFileRevision(IndexWriter diffTextWriter, CommonFileRevisionInput ri, int revid, DiffTextCache diffTextCache, CommonRevInfoDAO dao, boolean cvs, long maxIndexableSize) throws DbException, IOException {
        if (diffTextCache == null) {
            return;
        }
        File addedFile = null;
        File removedFile = null;
        Reader added = null;
        Reader removed = null;
        try {
            addedFile = ri.getTmpDiffAddedFile();
            added = this.getReaderForDiffFile(addedFile, maxIndexableSize, String.format("+%s@%s", ri.getPath(), ri.getRevision()));
            removedFile = ri.getTmpDiffRemovedFile();
            removed = this.getReaderForDiffFile(removedFile, maxIndexableSize, String.format("-%s@%s", ri.getPath(), ri.getRevision()));
            if (added != null || removed != null) {
                DocInfoManager<DiffDocInfo> diffDocManager = new DocInfoManager<DiffDocInfo>(diffTextWriter, null);
                diffDocManager.addDoc(new DiffDocInfo(added, removed, ri.getPath(), ri.getChangeSetId(), revid, ri.getDate(), cvs ? ri.getRevision() : null));
            }
        }
        catch (Throwable throwable) {
            this.finaliseDiffLines(added, removed, addedFile, removedFile, revid, dao, diffTextCache);
            throw throwable;
        }
        this.finaliseDiffLines(added, removed, addedFile, removedFile, revid, dao, diffTextCache);
    }

    private Reader getFileReader(File file) {
        if (file != null && file.exists()) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException e2) {
                return null;
            }
        }
        return null;
    }

    private void finaliseDiffLines(Reader addedReader, Reader removedReader, File addedFile, File removedFile, int revid, CommonRevInfoDAO dao, DiffTextCache diffTextCache) throws DbException {
        if (addedReader != null) {
            try {
                addedReader.close();
            }
            catch (IOException e2) {
                Logs.APP_LOG.debug((Object)"Error trying to close reader", (Throwable)e2);
            }
        }
        if (removedReader != null) {
            try {
                removedReader.close();
            }
            catch (IOException e3) {
                Logs.APP_LOG.debug((Object)"Error trying to close reader", (Throwable)e3);
            }
        }
        if (diffTextCache != null) {
            diffTextCache.deleteFile(addedFile);
            diffTextCache.deleteFile(removedFile);
        }
        if (dao != null) {
            dao.deleteTmpDiffAddedFiles(revid);
        }
    }

    public void deleteDocumentsForPaths(IndexWriter writer, Collection<Path> paths) throws IOException {
        for (Path path : paths) {
            try {
                writer.deleteDocuments(ContentDocInfo.queryByPath(path));
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)("Exception while deleting document at path: " + path + ". This doc will not be deleted from the content index."), (Throwable)e2);
            }
        }
    }

    public void indexContents(IndexWriter writer, int revid, IndexableFileRevision ri, Reader in, String cvsRevision) throws DbException {
        try {
            DocInfoManager<ContentDocInfo> dao = new DocInfoManager<ContentDocInfo>(writer, null);
            dao.addDoc(new ContentDocInfo(in, ri.getPath(), ri.getChangeSetId(), revid, ri.getDate(), cvsRevision));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }
}

