/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.FileRevisionImpl;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.DiffFileTracker;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class CommonFileRevision
extends FileRevisionImpl {
    private static final List<RevInfoKey> NO_PARENTS = Collections.emptyList();
    private int revID;
    private AncestorLink ancestorLink;
    private RevInfoKey ancestorOnBranch;
    private Path path;
    private String revision;
    private String author;
    private String comment;
    private boolean trunkLike;
    private long date;
    private boolean isBinary;
    private boolean isAdded;
    private boolean isDead;
    private boolean isCopy;
    private boolean isMove;
    private boolean isModify;
    private RevInfoKey copySource;
    private final List<RevInfoKey> copyDests = new LinkedList<RevInfoKey>();
    private RevInfoKey moveSource;
    private RevInfoKey moveDest;
    private int lineCount;
    private int linesAdded;
    private int linesRemoved;
    private LineCountState lineCountState = LineCountState.FULL;
    private int fileType = 1;
    private List<String> tags = Collections.emptyList();
    private List<String> branchPoints = Collections.emptyList();
    private Set<String> branches = new HashSet<String>();
    private Set<String> headOnBranches = new HashSet<String>();
    private List<Integer> reviewIds = Collections.emptyList();
    private List<Hunk> hunks;
    private RevInfoKey predecessor;
    private List<RevInfoKey> ancestors = Collections.emptyList();
    private boolean isOversize;
    private DiffFileTracker diffTracker = new DiffFileTracker();

    protected CommonFileRevision() {
    }

    public void setAncestors(List<RevInfoKey> ancestors) {
        this.ancestors = ancestors;
    }

    @Override
    public List<RevInfoKey> getAncestors() {
        return this.ancestors;
    }

    @Override
    public List<RevInfoKey> getParents() {
        if (this.ancestorLink != null && (this.ancestorLink.isBranchPoint() || this.ancestorLink.isDirect())) {
            return this.ancestors;
        }
        return NO_PARENTS;
    }

    public void setAncestorOnBranch(RevInfoKey ancestorKey) {
        this.ancestorOnBranch = ancestorKey;
    }

    @Override
    public RevInfoKey getAncestorOnBranch() {
        return this.ancestorOnBranch;
    }

    @Override
    public RevInfoKey getRevInfoKey() {
        return new RevInfoKey(this.getPath(), this.getRevision());
    }

    @Override
    public int getRevID() {
        return this.revID;
    }

    public void setRevID(int revID) {
        this.revID = revID;
    }

    @Override
    public AncestorLink getAncestorLink() {
        return this.ancestorLink;
    }

    public void setAncestorLink(AncestorLink ancestorLink) {
        this.ancestorLink = ancestorLink;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author.trim();
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getBranch() {
        Set<String> branches = this.getBranches();
        if (branches != null && !branches.isEmpty()) {
            return branches.iterator().next();
        }
        return null;
    }

    public void addBranch(String branch) {
        this.branches.add(branch);
    }

    @Override
    public Set<String> getBranches() {
        return this.branches;
    }

    @Override
    public boolean isTrunkLike() {
        return this.trunkLike;
    }

    public void setTrunkLike(boolean trunkLike) {
        this.trunkLike = trunkLike;
    }

    @Override
    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    @Override
    public Date getDateValue() {
        return new Date(this.getDate());
    }

    @Override
    public boolean isBinary() {
        return this.isBinary;
    }

    public void setBinary(boolean binary) {
        this.isBinary = binary;
    }

    @Override
    public boolean isAdded() {
        return this.isAdded;
    }

    public void setAdded(boolean added) {
        this.isAdded = added;
    }

    @Override
    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean deleted) {
        this.isDead = deleted;
    }

    @Override
    public boolean isCopy() {
        return this.isCopy;
    }

    public void setCopy(boolean copy) {
        this.isCopy = copy;
    }

    @Override
    public boolean isMove() {
        return this.isMove;
    }

    public void setMove(boolean move) {
        this.isMove = move;
    }

    public void setModify(boolean modify) {
        this.isModify = modify;
    }

    @Override
    public boolean isModify() {
        return this.isModify;
    }

    public boolean isHead() {
        return !this.headOnBranches.isEmpty();
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    @Override
    public int getLinesAdded() {
        return this.linesAdded;
    }

    public void setLinesAdded(int linesAdded) {
        this.linesAdded = linesAdded;
    }

    @Override
    public int getLinesRemoved() {
        return this.linesRemoved;
    }

    @Override
    public LineCountState getLineCountState() {
        return this.lineCountState;
    }

    public void setLineCountState(LineCountState lineCountState) {
        this.lineCountState = lineCountState;
    }

    public void setLinesRemoved(int linesRemoved) {
        this.linesRemoved = linesRemoved;
    }

    @Override
    public List<String> getBranchPoints() {
        return this.branchPoints;
    }

    public void setBranchPoints(List<String> branches) {
        this.branchPoints = branches;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int fileType) {
        this.fileType = fileType;
    }

    @Override
    public RevInfoKey getCopySource() {
        return this.copySource;
    }

    public void setCopySource(RevInfoKey copySource) {
        this.copySource = copySource;
    }

    @Override
    public List<RevInfoKey> getCopyDestinations() throws DbException {
        return this.copyDests;
    }

    public void addCopyDestination(RevInfoKey key) {
        this.copyDests.add(key);
    }

    @Override
    public RevInfoKey getMoveSource() {
        return this.moveSource;
    }

    public void setMoveSource(RevInfoKey moveSource) {
        this.moveSource = moveSource;
    }

    @Override
    public RevInfoKey getMoveDestination() throws DbException {
        return this.moveDest;
    }

    public void setMoveDest(RevInfoKey moveDest) {
        this.moveDest = moveDest;
    }

    @Override
    public List<Integer> getReviewIds() {
        return this.reviewIds;
    }

    public void setReviewIds(List<Integer> reviewIds) {
        this.reviewIds = reviewIds;
    }

    @Override
    public List<Hunk> getHunks() {
        return this.hunks;
    }

    public void createDeletedHunk() {
        this.setHunks(Hunk.createUnifiedDeleteHunk(1, 1, this.getLinesRemoved()));
    }

    public void createAdditionHunk() {
        if (!this.isBinary()) {
            this.setHunks(Hunk.createUnifiedAddHunk(1, 1, this.getLineCount()));
        }
    }

    public void createReplaceHunk(int previousCount) {
        if (this.isBinary()) {
            this.setHunks(Hunk.createUnifiedDeleteHunk(1, 1, this.getLinesRemoved()));
        } else {
            this.setHunks(new Hunk(1, 1, previousCount, this.getLineCount()));
        }
    }

    private void setHunks(Hunk hunk) {
        this.hunks = new ArrayList<Hunk>();
        this.hunks.add(hunk);
    }

    public void setHunks(List<Hunk> hunks) {
        this.hunks = hunks;
    }

    public void setPredecessor(RevInfoKey predecessor) {
        this.predecessor = predecessor;
    }

    @Override
    public RevInfoKey getPredecessor() {
        return this.predecessor;
    }

    @Override
    public RevInfoKey getDiffRevision() {
        RevInfoKey key = this.getPredecessor();
        if (key == null) {
            key = this.getAncestorOnBranch();
        }
        if (key == null && !this.ancestors.isEmpty()) {
            key = this.getAncestors().get(0);
        }
        return key;
    }

    public void setTmpDiffAddedFile(File file) {
        this.diffTracker.setTmpDiffAddedFile(file);
    }

    public void setTmpDiffRemovedFile(File file) {
        this.diffTracker.setTmpDiffRemovedFile(file);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.revID;
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommonFileRevision other = (CommonFileRevision)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.revID != other.revID) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    @Override
    public File getTmpDiffAddedFile() {
        return this.diffTracker.getTmpDiffAddedFile();
    }

    @Override
    public File getTmpDiffRemovedFile() {
        return this.diffTracker.getTmpDiffRemovedFile();
    }

    @Override
    public boolean isMetadataOnlyChange() {
        return CommonFileRevision.isMetadataOnlyChange(this);
    }

    public static boolean isMetadataOnlyChange(FileRevision revision) {
        if (!(!CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES || !revision.isModify() || revision.isAdded() || revision.isDead() || revision.isMove() || revision.isBinary() || revision.isOversize())) {
            return revision.getLinesAdded() == 0 && revision.getLinesRemoved() == 0;
        }
        return false;
    }

    public void addHeadOnBranch(String branch) {
        if (!Strings.isNullOrEmpty((String)branch)) {
            this.headOnBranches.add(branch);
        }
    }

    @Override
    public Set<String> getHeadOnBranches() {
        return this.headOnBranches;
    }

    public void setOversize(boolean oversize) {
        this.isOversize = oversize;
    }

    @Override
    public boolean isOversize() {
        return this.isOversize;
    }

    @Override
    public boolean isBinaryOrOversize() {
        return this.isBinary() || this.isOversize();
    }

    public String toString() {
        Objects.ToStringHelper builder = Objects.toStringHelper((Object)this).add(this.getClass().getSimpleName(), (Object)(this.getPath() + "@" + this.getRevision())).add("revId", this.getRevID()).add("author", (Object)this.getAuthor()).add("comment", Iterables.getFirst((Iterable)Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)Strings.nullToEmpty((String)this.getComment())), (Object)"")).add("date", (Object)this.getDateValue());
        if (this.isBinary()) {
            builder.addValue((Object)"binary");
        }
        if (this.isDead()) {
            builder.addValue((Object)"dead");
        }
        if (this.isAdded()) {
            builder.addValue((Object)"added");
        }
        if (this.isModify()) {
            builder.addValue((Object)"modify");
        }
        if (this.isCopy()) {
            builder.add("copyFrom", (Object)this.getCopySource());
        }
        if (this.isMove()) {
            builder.add("moveFrom", (Object)this.getMoveSource());
        }
        builder.add("ancestors", this.getAncestors());
        return builder.toString();
    }
}

