/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonDirInfo;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;

public class CommonDirInfoDAO {
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;
    private final boolean caseSensitive;

    public CommonDirInfoDAO(InfinityDbHandle dbh, CommonStringTables stringTables, boolean caseSensitive) {
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.caseSensitive = caseSensitive;
    }

    public CommonDirInfo load(Path key) throws DbException {
        if (key == null) {
            return null;
        }
        try {
            String path = key.getPath(this.caseSensitive);
            long dirid = this.stringTables.pathDB.find(path);
            if (dirid == -1L) {
                return null;
            }
            EavEntityCu eav = this.makeEav(dirid);
            if (!eav.exists()) {
                return null;
            }
            CommonDirInfo di = new CommonDirInfo();
            di.setPath(key);
            di.setSubTreeDateRange(eav.getRevisionDateRange(CommonSchema.DirInfo.A_SUBTREE_DATERANGE, di.getSubTreeDateRange()));
            return di;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public Collection<Path> listDirs(Path dir) throws DbException {
        if (this.caseSensitive) {
            return this.listChildren(dir, CommonSchema.DirInfo.A_CHILD_DIRS, this.stringTables.pathDB);
        }
        return this.listChildren(dir, CommonSchema.DirInfo.A_CHILDPRESERVED_ID, this.stringTables.pathDB);
    }

    public Collection<Path> listFiles(Path dir) throws DbException {
        return this.listChildren(dir, CommonSchema.DirInfo.A_CHILD_FILES, this.stringTables.pathDB);
    }

    private Collection<Path> listChildren(Path dir, p attr, UniqueStringTable table) throws DbException {
        try {
            String path = dir.getPath(this.caseSensitive);
            long dirid = this.stringTables.pathDB.find(path);
            EavEntityCu eav = this.makeEav(dirid);
            LongList ids = eav.getLongs(attr);
            TreeSet<Path> result = new TreeSet<Path>();
            for (int i2 = 0; i2 < ids.size(); ++i2) {
                long strid = ids.getLong(i2);
                String str = table.get(strid);
                result.add(new Path(str));
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private EavEntityCu makeEav(long dirid) throws DbException {
        ac db = this.dbh.get();
        return new EavEntityCu(db, CommonSchema.DirInfo.ENTITY, dirid);
    }

    public void addDirToParent(Path dir) throws IOException, DbException {
        if (dir.isRoot()) {
            return;
        }
        String childDir = dir.getPath(this.caseSensitive);
        String parent = dir.getParent().getPath(this.caseSensitive);
        long childDirid = this.stringTables.pathDB.add(childDir);
        long parentid = this.stringTables.pathDB.add(parent);
        EavEntityCu parentEav = this.makeEav(parentid);
        parentEav.addLong(CommonSchema.DirInfo.A_CHILD_DIRS, childDirid);
        if (!this.caseSensitive) {
            long preservedId = this.stringTables.pathDB.add(dir.getPath());
            parentEav.addLong(CommonSchema.DirInfo.A_CHILDPRESERVED_ID, preservedId);
        }
    }

    public void addFileToParent(Path file) throws IOException, DbException {
        long parentId;
        long childFileId;
        if (this.caseSensitive) {
            childFileId = this.stringTables.pathDB.add(file.getPath());
            parentId = this.stringTables.pathDB.add(file.getParent().getPath());
        } else {
            childFileId = this.stringTables.pathDB.add(file.getPath().toLowerCase(Locale.US));
            parentId = this.stringTables.pathDB.add(file.getParent().getPath().toLowerCase(Locale.US));
        }
        EavEntityCu parentEav = this.makeEav(parentId);
        parentEav.addLong(CommonSchema.DirInfo.A_CHILD_FILES, childFileId);
    }

    public boolean exists(Path key) throws DbException {
        try {
            long pathID = this.stringTables.pathDB.find(key.getPath(this.caseSensitive));
            ac db = this.dbh.get();
            EavEntityCu ecu = new EavEntityCu(db, CommonSchema.DirInfo.ENTITY, pathID);
            return ecu.exists();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateToDir(Path dir) {
        try {
            long parentId;
            long childFileId;
            if (this.caseSensitive) {
                childFileId = this.stringTables.pathDB.add(dir.getPath());
                parentId = this.stringTables.pathDB.add(dir.getParent().getPath());
            } else {
                childFileId = this.stringTables.pathDB.add(dir.getPath().toLowerCase(Locale.US));
                parentId = this.stringTables.pathDB.add(dir.getParent().getPath().toLowerCase(Locale.US));
            }
            EavEntityCu parentEav = this.makeEav(parentId);
            parentEav.deleteLong(CommonSchema.DirInfo.A_CHILD_FILES, childFileId);
            this.addDirToParent(dir);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }
}

