/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fecru.util.ClassUtils;
import com.atlassian.fecru.util.ListIterable;
import com.atlassian.fisheye.dag.GraphIterator;
import com.atlassian.fisheye.dag.GraphUtils;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.atlassian.util.concurrent.LazyReference;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfDbIterable;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.Position;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.LazyChangeSetInterceptor;
import com.cenqua.fisheye.util.bitset.BitSets;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;
import org.apache.log4j.Logger;

public abstract class CommonChangeSetDAO<F extends FileRevision, C extends ChangeSetImpl<F>, T extends CommonStringTables>
implements ChangeSetDAO<F, C> {
    private static final Logger log = Logs.loggerFor(CommonChangeSetDAO.class);
    private Factory proxyFactory;
    protected final InfinityDbHandle dbh;
    protected final T stringTables;
    protected final FileRevisionDAO<F> fileRevDAO;
    protected final LicenseEnforcer licenseEnforcer;
    private final LazyReference<Set<String>> authors = new LazyReference<Set<String>>(){

        protected Set<String> create() throws Exception {
            return CommonChangeSetDAO.this.createAllAuthorsSet();
        }
    };
    private final String repName;
    private final RepositoryStatus repositoryStatus;
    private final Predicate<String> existsFilter = new Predicate<String>(){

        public boolean apply(String csid) {
            return CommonChangeSetDAO.this.exists(csid);
        }
    };
    private final Function<String, Collection<String>> csIdToParentsCsIds = new Function<String, Collection<String>>(){

        public Collection<String> apply(String changesetId) {
            return CommonChangeSetDAO.this.loadParentIds(changesetId);
        }
    };
    private final Function<String, Collection<String>> csIdsToChildrenCsIds = new Function<String, Collection<String>>(){

        public Collection<String> apply(String changesetId) {
            return CommonChangeSetDAO.this.loadChildIds(changesetId);
        }
    };

    public CommonChangeSetDAO(RepositoryStatus repositoryStatus, InfinityDbHandle dbh, T stringTables, FileRevisionDAO<F> fileRevDAO, LicenseEnforcer licenseEnforcer) {
        this.repositoryStatus = repositoryStatus;
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.fileRevDAO = fileRevDAO;
        this.licenseEnforcer = licenseEnforcer;
        this.repName = fileRevDAO == null ? null : fileRevDAO.getRepName();
    }

    private Factory getProxyFactory() {
        if (this.proxyFactory == null) {
            Class<?> changesetClazz = ClassUtils.getTypeArguments(CommonChangeSetDAO.class, this.getClass()).get(1);
            this.proxyFactory = ClassUtils.createEnhancer(changesetClazz, new LazyChangeSetInterceptor(null, this));
        }
        return this.proxyFactory;
    }

    @Override
    public boolean supportsCreatedOnBranch() {
        return true;
    }

    protected EavEntityCu makeEav(long csStringId) throws DbException {
        ac db = this.dbh.get();
        return new EavEntityCu(db, CommonSchema.ChangeSetInfo.ENTITY, csStringId);
    }

    @Override
    public List<String> getChangeSetIds() throws DbException {
        LinkedList<String> ids = new LinkedList<String>();
        y cu = y.a().a(CommonSchema.ChangeSetInfo.ENTITY);
        int pl = cu.e();
        try {
            ac db = this.dbh.get();
            while (db.a(cu, pl)) {
                long id = cu.v(pl);
                cu.d(cu.w(pl));
                cu.ak(pl);
                ids.add(this.getChangesetId(id));
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
        return ids;
    }

    @Override
    public C load(String csid) throws DbException {
        return this.loadLazy(csid);
    }

    protected C loadLazy(String csid) throws DbException {
        if (this.exists(csid)) {
            return (C)((ChangeSetImpl)this.getProxyFactory().newInstance(new Callback[]{new LazyChangeSetInterceptor(csid, this), NoOp.INSTANCE}));
        }
        return null;
    }

    @Override
    public C loadNonLazy(String csid) throws DbException {
        try {
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.find(csid);
            EavEntityCu eav = this.makeEav(id);
            if (!eav.exists()) {
                return null;
            }
            Object changeset = this.createChangeSet(csid);
            this.loadAttributes(eav, changeset);
            return changeset;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public String getComment(long csdbid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(csdbid);
            if (!eav.exists()) {
                return null;
            }
            return ((CommonStringTables)this.stringTables).commentDB.get(eav.getLong(CommonSchema.ChangeSetInfo.A_COMMENT_ID, 0L));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected void loadAttributes(EavEntityCu eav, C changeset) throws DbException, IOException {
        ((ChangeSetImpl)changeset).setRepName(this.repName);
        ((ChangeSetImpl)changeset).setDate(eav.getLong(CommonSchema.ChangeSetInfo.A_DATE, 0L));
        ((ChangeSetImpl)changeset).setAuthor(eav.getString(CommonSchema.ChangeSetInfo.A_AUTHOR, "no_author"));
        ((ChangeSetImpl)changeset).setComment(((CommonStringTables)this.stringTables).commentDB.get(eav.getLong(CommonSchema.ChangeSetInfo.A_COMMENT_ID, 0L)));
        ((ChangeSetImpl)changeset).setBranches(eav.getStrings(((CommonStringTables)this.stringTables).branchDB, CommonSchema.ChangeSetInfo.A_BRANCHES));
        ((ChangeSetImpl)changeset).setBranchesContributedTo(eav.getStrings(((CommonStringTables)this.stringTables).branchDB, CommonSchema.ChangeSetInfo.A_ON_BRANCH));
        ((ChangeSetImpl)changeset).setNextCrossBranchCommits(eav.getStrings(((CommonStringTables)this.stringTables).changeSetIdDB, CommonSchema.ChangeSetInfo.A_NEXT_COMMITS));
        long[] posValue = eav.getLongArray(CommonSchema.ChangeSetInfo.A_POSITION);
        if (posValue != null) {
            ((ChangeSetImpl)changeset).setPosition(new Position(posValue));
        }
        List<String> parentIds = eav.getStringsOrdered(((CommonStringTables)this.stringTables).changeSetIdDB, CommonSchema.ChangeSetInfo.A_PARENTS);
        ArrayList<String> resolvedIds = new ArrayList<String>();
        for (String parentId : parentIds) {
            Set<String> parentsForCsId = this.resolveParent(parentId);
            if (parentsForCsId.isEmpty()) {
                log.warn((Object)("Cannot resolve changeset parent id " + parentId + " for changeset " + ((ChangeSetImpl)changeset).getId() + " in " + this.repName));
                continue;
            }
            resolvedIds.addAll(parentsForCsId);
        }
        ((ChangeSetImpl)changeset).setParents(resolvedIds);
        ((ChangeSetImpl)changeset).setChildren(this.loadChildIds(((ChangeSetImpl)changeset).getId()));
        ((ChangeSetImpl)changeset).setTags(eav.getStrings(((CommonStringTables)this.stringTables).tagDB, CommonSchema.ChangeSetInfo.A_TAGS));
        long indexingStateValue = eav.getLong(CommonSchema.ChangeSetInfo.A_INDEXING_STATE, ChangeSetIndexingState.UNKNOWN.getValue());
        ((ChangeSetImpl)changeset).setIndexingState(ChangeSetIndexingState.getState((int)indexingStateValue));
        Map<Long, Long> rawStateVersionMap = eav.getKeyValueMap(CommonSchema.ChangeSetInfo.A_INDEXING_STATE_VERSION);
        HashMap<ChangeSetIndexingState, Long> stateVersionMap = new HashMap<ChangeSetIndexingState, Long>();
        for (Map.Entry<Long, Long> entry : rawStateVersionMap.entrySet()) {
            stateVersionMap.put(ChangeSetIndexingState.getState(entry.getKey().intValue()), entry.getValue());
        }
        ((ChangeSetImpl)changeset).setIndexingStateVersions(stateVersionMap);
    }

    @Override
    public boolean exists(String csid) throws DbException {
        long id = ((CommonStringTables)this.stringTables).changeSetIdDB.find(csid);
        return this.exists(id);
    }

    private boolean exists(long csDbId) throws DbException {
        if (csDbId > 0L) {
            y cu = y.a(CommonSchema.ChangeSetInfo.ENTITY).b(csDbId);
            try {
                boolean bl = this.dbh.get().b(cu, cu.e());
                return bl;
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
            finally {
                cu.b();
            }
        }
        return false;
    }

    @Override
    public void store(C changeset) throws DbException, LicensePolicyException {
        this.licenseEnforcer.validateCommitterLimit(((ChangeSetImpl)changeset).getAuthor(), this.dbh);
        this.storeWithoutLimits(changeset);
        if (this.authors.isInitialized()) {
            ((Set)this.authors.get()).add(((ChangeSetImpl)changeset).getAuthor());
        }
    }

    @Override
    public void storeWithoutLimits(C changeset) throws DbException {
        try {
            String csid = ((ChangeSetImpl)changeset).getId();
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.add(csid);
            EavEntityCu eav = this.makeEav(id);
            this.storeAttributes(eav, id, changeset);
            this.updateNextCrossBranchCommits(id, changeset);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateNextCrossBranchCommits(long thisCsId, C changeset) throws DbException {
        ImmutableList parentIds = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(((ChangeSetImpl)changeset).getParents(), (Function)new Function<String, Iterable<String>>(){

            public Set<String> apply(@Nullable String parentCsId) {
                return CommonChangeSetDAO.this.resolveParent(parentCsId);
            }
        })));
        if (parentIds.isEmpty()) {
            return;
        }
        C earliestParent = this.getEarliest((List<String>)parentIds);
        if (earliestParent == null || ((ChangeSetImpl)earliestParent).getPosition() == null) {
            StringBuilder message = new StringBuilder("Could not determine position of earliest parent for changeset ").append(((ChangeSetImpl)changeset).getId());
            if (earliestParent == null) {
                message.append("; earliestParent == null");
            } else {
                message.append("; parent ").append(((ChangeSetImpl)earliestParent).getId()).append(" has no position");
            }
            log.warn((Object)message.toString());
            return;
        }
        y cu = y.a();
        ac db = this.dbh.get();
        try {
            ChangeSetImpl cs;
            ChangeSet prev = this.getPreviousChangeSet((ChangeSet)changeset);
            if (prev != null) {
                long prevCsId = ((CommonStringTables)this.stringTables).changeSetIdDB.find(prev.getId());
                y fromCu = y.a(CommonSchema.ChangeSetInfo.ENTITY).b(prevCsId).a(CommonSchema.ChangeSetInfo.A_NEXT_COMMITS);
                cu.f().a(CommonSchema.ChangeSetInfo.ENTITY).b(thisCsId).a(CommonSchema.ChangeSetInfo.A_NEXT_COMMITS);
                db.a((Object)cu, db, fromCu);
                fromCu.b();
                for (String nextCommit : this.loadChildIds(prev.getId())) {
                    if (nextCommit.equals(((ChangeSetImpl)changeset).getId())) continue;
                    long nextCsId = ((CommonStringTables)this.stringTables).changeSetIdDB.find(nextCommit);
                    cu.f().a(CommonSchema.ChangeSetInfo.ENTITY).b(thisCsId).a(CommonSchema.ChangeSetInfo.A_NEXT_COMMITS).b(nextCsId);
                    db.b(cu);
                }
            }
            Iterator iterator = this.getChangeSets((ChangeSet)earliestParent).iterator();
            while (iterator.hasNext() && !(cs = (ChangeSetImpl)iterator.next()).getId().equals(((ChangeSetImpl)changeset).getId())) {
                if (!cs.isBefore((ChangeSet)changeset)) {
                    break;
                }
                if (parentIds.contains(cs.getId())) continue;
                long prevCsId = ((CommonStringTables)this.stringTables).changeSetIdDB.find(cs.getId());
                cu.f().a(CommonSchema.ChangeSetInfo.ENTITY).b(prevCsId).a(CommonSchema.ChangeSetInfo.A_NEXT_COMMITS).b(thisCsId);
                db.b(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    protected void storeAttributes(EavEntityCu eav, long csDbId, C changeset) throws DbException, IOException {
        eav.updateLong(CommonSchema.ChangeSetInfo.A_DATE, ((ChangeSetImpl)changeset).getDate());
        eav.updateString(CommonSchema.ChangeSetInfo.A_AUTHOR, ((ChangeSetImpl)changeset).getAuthor());
        eav.updateLong(CommonSchema.ChangeSetInfo.A_COMMENT_ID, ((CommonStringTables)this.stringTables).commentDB.add(((ChangeSetImpl)changeset).getComment()));
        eav.updateStrings(((CommonStringTables)this.stringTables).branchDB, CommonSchema.ChangeSetInfo.A_BRANCHES, ((ChangeSetImpl)changeset).getBranches());
        this.updateIndexingState(eav, ((ChangeSetImpl)changeset).getId(), ((ChangeSetImpl)changeset).getIndexingState());
        eav.updateStringsOrdered(((CommonStringTables)this.stringTables).changeSetIdDB, CommonSchema.ChangeSetInfo.A_PARENTS, ((ChangeSetImpl)changeset).getParents());
        eav.updateStrings(((CommonStringTables)this.stringTables).tagDB, CommonSchema.ChangeSetInfo.A_TAGS, ((ChangeSetImpl)changeset).getTags());
        this.updateParentGraph(((ChangeSetImpl)changeset).getId(), ((ChangeSetImpl)changeset).getParents());
        if (((ChangeSetImpl)changeset).getPosition() == null) {
            Position position = this.determinePosition(changeset);
            ((ChangeSetImpl)changeset).setPosition(position);
            this.storePosition(eav, csDbId, changeset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateIndexingState(EavEntityCu eav, String csid, ChangeSetIndexingState newState) throws IOException {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            int currentStateVal = eav.getInt(CommonSchema.ChangeSetInfo.A_INDEXING_STATE, -1);
            if (currentStateVal != -1) {
                cu.a(CommonSchema.E_INDEXING_STATE_TO_CSID).b((long)currentStateVal).b(csid);
                db.c(cu);
                ChangeSetIndexingState currentState = ChangeSetIndexingState.getState(currentStateVal);
                ((AtomicInteger)this.repositoryStatus.getIndexingStateCounts().get((Object)currentState)).decrementAndGet();
            }
            cu.f().a(CommonSchema.E_INDEXING_STATE_TO_CSID).b((long)newState.getValue()).b(csid);
            db.b(cu);
            ((AtomicInteger)this.repositoryStatus.getIndexingStateCounts().get((Object)newState)).incrementAndGet();
        }
        finally {
            cu.b();
        }
        eav.updateLong(CommonSchema.ChangeSetInfo.A_INDEXING_STATE, newState.getValue());
    }

    protected Position determinePosition(C changeset) throws DbException, IOException {
        C youngestParent = this.getLatest(((ChangeSetImpl)changeset).getParents());
        if (youngestParent != null) {
            return this.createPositionAfter(youngestParent, ((ChangeSetImpl)changeset).getDate());
        }
        return this.createPositionForDate(((ChangeSetImpl)changeset).getDate());
    }

    protected double getDateDistanceFraction(long before, long between, long after) {
        if (after != before) {
            return (double)(between - before) / (double)(after - before);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Position createPositionAfter(C lowerLimitCs, long time) throws DbException, IOException {
        ac db = this.dbh.get();
        y cu = y.a().a(CommonSchema.E_POSITION_TO_CHANGESET);
        y dateCu = y.a();
        try {
            long lowerLimitDate = time;
            long upperLimitDate = time;
            Position lowerLimit = ((ChangeSetImpl)lowerLimitCs).getPosition();
            Position upperLimit = null;
            int valueOffset = cu.e();
            lowerLimit.appendToCu(cu);
            db.a(cu, valueOffset);
            while (db.a(cu, valueOffset)) {
                int csoffset = valueOffset;
                while (cu.w(csoffset) != cu.e()) {
                    csoffset = cu.w(csoffset);
                }
                upperLimit = new Position(cu, valueOffset, csoffset);
                long csid = cu.v(csoffset);
                dateCu.f().a(CommonSchema.ChangeSetInfo.ENTITY).b(csid).a(CommonSchema.ChangeSetInfo.A_DATE);
                int dateOffset = dateCu.e();
                if (!db.a(dateCu, dateOffset)) continue;
                upperLimitDate = dateCu.v(dateOffset);
                if (upperLimitDate > time) break;
                lowerLimit = upperLimit;
                lowerLimitDate = upperLimitDate;
                upperLimit = null;
                upperLimitDate = -1L;
            }
            if (upperLimit != null) {
                Position position = Position.createBetween(lowerLimit, upperLimit, this.getDateDistanceFraction(lowerLimitDate, time, upperLimitDate));
                return position;
            }
            Position position = Position.createAfter(lowerLimit);
            return position;
        }
        finally {
            cu.b();
            dateCu.b();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Position createPositionForDate(long time) throws DbException, IOException {
        ac db = this.dbh.get();
        y cu = y.a().a(CommonSchema.E_POSITION_TO_CHANGESET);
        y dateCu = y.a();
        try {
            long lowerLimitDate = time;
            long upperLimitDate = time;
            Position lowerLimit = null;
            Position upperLimit = null;
            int valueOffset = cu.e();
            cu.j();
            while (db.c(cu, valueOffset)) {
                int csoffset = valueOffset;
                while (cu.w(csoffset) != cu.e()) {
                    csoffset = cu.w(csoffset);
                }
                lowerLimit = new Position(cu, valueOffset, csoffset);
                long csid = cu.v(csoffset);
                dateCu.f().a(CommonSchema.ChangeSetInfo.ENTITY).b(csid).a(CommonSchema.ChangeSetInfo.A_DATE);
                int dateOffset = dateCu.e();
                if (db.a(dateCu, dateOffset) && (lowerLimitDate = dateCu.v(dateOffset)) <= time) break;
                upperLimit = lowerLimit;
                upperLimitDate = lowerLimitDate;
                lowerLimit = null;
                lowerLimitDate = -1L;
            }
            if (lowerLimit != null && upperLimit != null) {
                Position position = Position.createBetween(lowerLimit, upperLimit, this.getDateDistanceFraction(lowerLimitDate, time, upperLimitDate));
                return position;
            }
            if (lowerLimit != null) {
                Position position = Position.createAfter(lowerLimit);
                return position;
            }
            if (upperLimit != null) {
                Position position = Position.createBefore(upperLimit);
                return position;
            }
            Position position = Position.initial();
            return position;
        }
        finally {
            cu.b();
            dateCu.b();
        }
    }

    protected void storePosition(EavEntityCu eav, long csid, C changeset) throws DbException, IOException {
        Position position = ((ChangeSetImpl)changeset).getPosition();
        if (position != null) {
            eav.updateLongArray(CommonSchema.ChangeSetInfo.A_POSITION, position.getValue());
            ac db = this.dbh.get();
            y cu = y.a().a(CommonSchema.E_POSITION_TO_CHANGESET);
            position.appendToCu(cu);
            cu.b(csid);
            db.b(cu);
            if (this.supportsCreatedOnBranch()) {
                for (String branch : ((ChangeSetImpl)changeset).getBranches()) {
                    long branchId = ((CommonStringTables)this.stringTables).branchDB.find(branch);
                    cu.f().a(CommonSchema.E_BRANCH_TO_POSITION).b(branchId);
                    position.appendToCu(cu);
                    db.b(cu);
                }
            }
            cu.b();
        }
    }

    public List<String> loadParentIds(String csId) throws DbException {
        return this.loadChangesetIds(csId, CommonSchema.E_CHANGESET_PARENTS);
    }

    public List<String> loadChildIds(String csId) throws DbException {
        return this.loadChangesetIds(csId, CommonSchema.E_CHANGESET_CHILDREN);
    }

    private List<String> loadChangesetIds(String csId, I entity) throws DbException {
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            cu.a(entity).b(csId);
            int pl = cu.e();
            ArrayList<String> csIds = new ArrayList<String>();
            while (db.a(cu, pl)) {
                csIds.add(cu.m(pl));
            }
            ArrayList<String> arrayList = csIds;
            return arrayList;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public Set<String> resolveParent(String initialParentCsid) {
        GraphIterator<String> ancestorIterator = GraphUtils.filteredGraphIterator(GraphUtils.iterateBreadthFirst(Collections.singleton(initialParentCsid), this.csIdToParentsCsIds, null), this.existsFilter);
        return this.collectFirstMatchingNodes(ancestorIterator);
    }

    public Set<String> resolveChild(String initialChildCsid) {
        GraphIterator<String> descendantsIterator = GraphUtils.filteredGraphIterator(GraphUtils.iterateBreadthFirst(Collections.singleton(initialChildCsid), this.csIdsToChildrenCsIds, null), this.existsFilter);
        return this.collectFirstMatchingNodes(descendantsIterator);
    }

    private Set<String> collectFirstMatchingNodes(GraphIterator<String> ancestorIterator) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        while (ancestorIterator.hasNext()) {
            builder.add(ancestorIterator.next());
            ancestorIterator.prune();
        }
        return builder.build();
    }

    @Override
    public Set<String> getAllAuthors() throws DbException {
        try {
            return new HashSet<String>((Collection)this.authors.get());
        }
        catch (LazyReference.InitializationException e2) {
            throw new DbException(e2);
        }
    }

    private Set<String> createAllAuthorsSet() throws DbException {
        Set<String> authors = Collections.newSetFromMap(new ConcurrentHashMap());
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            cu.a(CommonSchema.E_AUTHOR_TO_REVID);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                String author = cu.m(pl);
                authors.add(author);
                int p2 = cu.n(pl);
                cu.d(p2).j();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
        return authors;
    }

    @Override
    public void addTag(Tag tag) throws DbException {
        try {
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.find(tag.getChangesetId());
            EavEntityCu eav = this.makeEav(id);
            if (!eav.exists()) {
                return;
            }
            long tagid = ((CommonStringTables)this.stringTables).tagDB.add(tag.getName());
            eav.addNoDupLong(CommonSchema.ChangeSetInfo.A_TAGS, tagid);
            y cu = y.a().a(CommonSchema.E_TAG_HEADS);
            cu.b(tagid);
            int pl = cu.e();
            cu.b(tag.getChangesetId());
            this.dbh.get().e(cu, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public void removeTag(Tag tag) throws DbException {
        try {
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.find(tag.getChangesetId());
            EavEntityCu eav = this.makeEav(id);
            if (!eav.exists()) {
                return;
            }
            long tagid = ((CommonStringTables)this.stringTables).tagDB.find(tag.getName());
            if (tagid != -1L) {
                eav.deleteLong(CommonSchema.ChangeSetInfo.A_TAGS, tagid);
                y cu = y.a().a(CommonSchema.E_TAG_HEADS).b(tagid);
                this.dbh.get().c((Object)cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public Tag getTag(String tagName) throws DbException {
        try {
            ac db = this.dbh.get();
            long tagId = ((CommonStringTables)this.stringTables).tagDB.find(tagName);
            if (tagId == -1L) {
                return null;
            }
            y cu = y.a().a(CommonSchema.E_TAG_HEADS);
            cu.b(tagId);
            String result = null;
            int pl = cu.e();
            if (db.a(cu, pl)) {
                result = cu.m(pl);
            }
            return result != null ? new Tag(tagName, result) : null;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public Set<Tag> getAllTags() throws DbException {
        HashSet<Tag> result = new HashSet<Tag>();
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(CommonSchema.E_TAG_HEADS);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                long tagId = cu.v(pl);
                String tagName = ((CommonStringTables)this.stringTables).tagDB.get(tagId);
                String taggedCommit = cu.m(cu.w(pl));
                if (tagName != null) {
                    result.add(new Tag(tagName, taggedCommit));
                    continue;
                }
                log.warn((Object)("Could not resolve tag id " + tagId + " to a tag name"));
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    protected I getCreatedOnBranchIndexEntityClass() {
        if (this.supportsCreatedOnBranch()) {
            return CommonSchema.E_BRANCH_TO_POSITION;
        }
        return CommonSchema.E_BRANCH_TO_DESCENDANT_CS_POSITION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChangesetBranches(String csid, Iterable<String> addedBranches, Iterable<String> removedBranches) {
        block10: {
            try {
                long branchId;
                ac db = this.dbh.get();
                long id = ((CommonStringTables)this.stringTables).changeSetIdDB.find(csid);
                EavEntityCu eav = this.makeEav(id);
                if (!eav.exists()) {
                    return;
                }
                LongArrayList addedBranchIds = new LongArrayList();
                LongArrayList removedBranchIds = new LongArrayList();
                for (String addedBranch : addedBranches) {
                    branchId = ((CommonStringTables)this.stringTables).branchDB.add(addedBranch);
                    if (!eav.addNoDupLong(CommonSchema.ChangeSetInfo.A_ON_BRANCH, branchId)) continue;
                    addedBranchIds.add(branchId);
                }
                for (String removedBranch : removedBranches) {
                    branchId = ((CommonStringTables)this.stringTables).branchDB.add(removedBranch);
                    if (!eav.deleteLong(CommonSchema.ChangeSetInfo.A_ON_BRANCH, branchId)) continue;
                    removedBranchIds.add(branchId);
                }
                long[] posValue = eav.getLongArray(CommonSchema.ChangeSetInfo.A_POSITION);
                if (posValue == null) break block10;
                Position position = new Position(posValue);
                y cu = y.a().a(CommonSchema.E_BRANCH_TO_DESCENDANT_CS_POSITION);
                int cuLength = cu.e();
                try {
                    LongListIterator addedIterator = addedBranchIds.iterator();
                    while (addedIterator.hasNext()) {
                        cu.b(addedIterator.nextLong());
                        position.appendToCu(cu);
                        db.b(cu);
                        cu.d(cuLength);
                    }
                    LongListIterator removedIterator = removedBranchIds.iterator();
                    while (removedIterator.hasNext()) {
                        cu.b(removedIterator.nextLong());
                        position.appendToCu(cu);
                        db.c(cu);
                        cu.d(cuLength);
                    }
                }
                finally {
                    cu.b();
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
    }

    @Override
    public void markAsAncestorOfBranch(String csid, String branchName) throws DbException {
        this.updateChangesetBranches(csid, Collections.singleton(branchName), Collections.emptyList());
    }

    @Override
    public void unmarkAsAncestorOfBranch(String csid, String branchName) throws DbException {
        this.updateChangesetBranches(csid, Collections.emptyList(), Collections.singleton(branchName));
    }

    @Override
    public Set<String> unmarkAllAsAncestorOfBranch(String branchName) throws DbException {
        HashSet<String> modifiedCsIds = new HashSet<String>();
        long branchId = ((CommonStringTables)this.stringTables).branchDB.find(branchName);
        if (branchId > 0L) {
            try {
                ac db = this.dbh.get();
                y cu = y.a().a(CommonSchema.E_BRANCH_TO_DESCENDANT_CS_POSITION).b(branchId);
                int keyLength = cu.e();
                while (db.a(cu, keyLength)) {
                    this.repositoryStatus.throwOnStopRequested();
                    Position position = new Position(cu, keyLength);
                    db.c(cu);
                    y cu2 = y.a().a(CommonSchema.E_POSITION_TO_CHANGESET);
                    position.appendToCu(cu2);
                    int valueOffset = cu2.e();
                    if (!db.a(cu2, valueOffset)) continue;
                    long csidkey = cu2.v(valueOffset);
                    modifiedCsIds.add(this.getChangesetId(csidkey));
                    EavEntityCu eav = this.makeEav(csidkey);
                    eav.deleteLong(CommonSchema.ChangeSetInfo.A_ON_BRANCH, branchId);
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        return modifiedCsIds;
    }

    public void updateParentGraph(String csId, List<String> parentIds) throws DbException {
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            for (String parentId : parentIds) {
                cu.f().a(CommonSchema.E_CHANGESET_PARENTS).b(csId).b(parentId);
                db.b(cu);
                cu.f().a(CommonSchema.E_CHANGESET_CHILDREN).b(parentId).b(csId);
                db.b(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    @Override
    public C getLatestChangesetOnBranchUpTo(String branchName, String csId, boolean inclusive) throws DbException {
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            long branchId = ((CommonStringTables)this.stringTables).branchDB.find(branchName);
            Position position = this.getPositionForChangeset(csId);
            if (branchId > 0L && position != null) {
                cu.a(this.getCreatedOnBranchIndexEntityClass()).b(branchId);
                int valueOffset = cu.e();
                position.appendToCu(cu);
                if (inclusive) {
                    cu.j();
                }
                if (db.c(cu, valueOffset)) {
                    C c2 = this.getChangeSetAtPosition(new Position(cu, valueOffset));
                    return c2;
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return null;
    }

    private C getChangeSetAtPosition(Position pos) throws DbException {
        y cu = y.a().a(CommonSchema.E_POSITION_TO_CHANGESET);
        try {
            ac db = this.dbh.get();
            pos.appendToCu(cu);
            int valueOffset = cu.e();
            if (db.a(cu, valueOffset)) {
                long csid = cu.v(valueOffset);
                C c2 = this.loadLazy(this.getChangesetId(csid));
                return c2;
            }
            C c3 = null;
            return c3;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    public Position getPositionForChangeset(String cs) throws DbException {
        long csid = ((CommonStringTables)this.stringTables).changeSetIdDB.find(cs);
        return this.getPositionForChangeset(csid);
    }

    @Override
    public Position getPositionForChangeset(long csdbid) throws DbException {
        y cu = y.a().a(CommonSchema.ChangeSetInfo.ENTITY).b(csdbid).a(CommonSchema.ChangeSetInfo.A_POSITION);
        int valueOffset = cu.e();
        ac db = this.dbh.get();
        try {
            if (db.a(cu, valueOffset)) {
                Position position = new Position(cu, valueOffset);
                return position;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return null;
    }

    @Override
    public C getLatestChangesetOnBranch(String branchName) throws DbException {
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            long branchId = ((CommonStringTables)this.stringTables).branchDB.find(branchName);
            if (branchId > 0L) {
                cu.a(this.getCreatedOnBranchIndexEntityClass()).b(branchId);
                int valueOffset = cu.e();
                cu.j();
                if (db.c(cu, valueOffset)) {
                    C c2 = this.getChangeSetAtPosition(new Position(cu, valueOffset));
                    return c2;
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return null;
    }

    @Override
    public C getChangeSet(String csId) throws DbException {
        return this.loadLazy(csId);
    }

    @Override
    public ListIterable<C> getChangeSets() throws DbException {
        return this.getChangeSets(null);
    }

    @Override
    public ListIterable<C> getChangeSets(ChangeSet startPosition) throws DbException {
        y cu = y.a().a(CommonSchema.E_POSITION_TO_CHANGESET);
        int l2 = cu.e();
        if (startPosition != null) {
            startPosition.getPosition().appendToCu(cu);
        }
        return new InfDbIterable<C>(this.dbh, cu, l2){

            @Override
            public C getElement(y cu, int elementOffset) throws IOException, DbException {
                return CommonChangeSetDAO.this.getChangesetFromPostionToChangesetIndex(cu, elementOffset);
            }
        };
    }

    @Override
    public Iterable<C> getChangeSetsInState(final ChangeSetIndexingState state) throws DbException {
        y cu = y.a().a(CommonSchema.E_INDEXING_STATE_TO_CSID).b((long)state.getValue());
        int l2 = cu.e();
        return Iterables.filter((Iterable)new InfDbIterable<C>(this.dbh, cu, l2){

            @Override
            public C getElement(y cu, int elementOffset) throws IOException, DbException {
                String csid = cu.m(elementOffset);
                Object changeset = CommonChangeSetDAO.this.loadLazy(csid);
                if (changeset == null && log.isDebugEnabled()) {
                    log.debug((Object)String.format("Requested changeset with id: %s does not exist in given state: %d", csid, state.getValue()));
                }
                return changeset;
            }
        }, (Predicate)Predicates.notNull());
    }

    @Override
    public void syncChangeSetCountsPerState() {
        ConcurrentMap<ChangeSetIndexingState, AtomicInteger> counts = this.repositoryStatus.getIndexingStateCounts();
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            for (ChangeSetIndexingState state : ChangeSetIndexingState.values()) {
                int count = 0;
                cu.f().a(CommonSchema.E_INDEXING_STATE_TO_CSID).b((long)state.getValue());
                int csidOffset = cu.e();
                while (db.a(cu, csidOffset)) {
                    ++count;
                }
                ((AtomicInteger)counts.get((Object)state)).set(count);
            }
        }
        catch (IOException e2) {
            throw new DbException("Error getting state counts: " + e2.getMessage(), e2);
        }
        finally {
            cu.b();
        }
    }

    private C getChangesetFromPostionToChangesetIndex(y cu, int elementOffset) {
        int offset = elementOffset;
        while (cu.w(offset) < cu.e()) {
            offset = cu.w(offset);
        }
        long csDbId = cu.v(offset);
        return this.loadLazy(this.getChangesetId(csDbId));
    }

    @Override
    public ListIterable<C> getChangeSetsOnBranch(String branchName, ChangeSet startPosition) throws DbException {
        return this.getChangeSetsForBranch(branchName, startPosition, this.getCreatedOnBranchIndexEntityClass());
    }

    @Override
    public ListIterable<C> getChangeSetsInAncestryOfBranch(String branchName) throws DbException {
        return this.getChangeSetsForBranch(branchName, null, CommonSchema.E_BRANCH_TO_DESCENDANT_CS_POSITION);
    }

    private ListIterable<C> getChangeSetsForBranch(String branchName, ChangeSet startPosition, I indexEntity) throws DbException {
        long branchId = ((CommonStringTables)this.stringTables).branchDB.find(branchName);
        if (branchId > 0L) {
            y cu = y.a().a(indexEntity).b(branchId);
            int keyLength = cu.e();
            if (startPosition != null) {
                startPosition.getPosition().appendToCu(cu);
                try {
                    ac db = this.dbh.get();
                    boolean b2 = db.c(cu, keyLength);
                    if (b2) {
                        cu.j();
                    } else {
                        cu.d(keyLength);
                    }
                }
                catch (IOException e2) {
                    throw new DbException(e2);
                }
            }
            return new InfDbIterable<C>(this.dbh, cu, keyLength){

                @Override
                public C getElement(y cu, int elementOffset) throws IOException, DbException {
                    Position pos = new Position(cu, elementOffset);
                    ChangeSetImpl cs = CommonChangeSetDAO.this.getChangeSetAtPosition(pos);
                    return cs;
                }
            };
        }
        return ListIterable.UTILS.emptyListIterable();
    }

    @VisibleForTesting
    protected Set<String> clearOnBranchesIfRefWarped(Branch oldBranch, Branch newBranch) throws DbException {
        if (oldBranch != null && oldBranch.getLatestChangeSetId() != null && oldBranch.getState() != BranchState.REMOVED && !oldBranch.getLatestChangeSetId().equals(newBranch.getLatestChangeSetId())) {
            GraphIterator<String> it = this.iterateDescendants(oldBranch.getLatestChangeSetId());
            while (it.hasNext()) {
                String changesetId = (String)it.next();
                if (!changesetId.equals(newBranch.getLatestChangeSetId())) continue;
                return Collections.emptySet();
            }
            log.info((Object)("Branch " + oldBranch.getName() + " has been moved from " + oldBranch.getLatestChangeSetId() + " to " + newBranch.getLatestChangeSetId() + ", which is not a descendant of its old value. Rebuilding branch memberships for the branch"));
            return this.unmarkAllAsAncestorOfBranch(oldBranch.getName());
        }
        return Collections.emptySet();
    }

    public boolean contributesToBranch(String csId, long branchId) throws DbException {
        long csDbId = ((CommonStringTables)this.stringTables).changeSetIdDB.find(csId);
        ac db = this.dbh.get();
        y cu = y.a(CommonSchema.ChangeSetInfo.ENTITY).b(csDbId).a(CommonSchema.ChangeSetInfo.A_ON_BRANCH).b(branchId);
        try {
            boolean bl = db.a_(cu);
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    @Override
    public List<String> updateBranchAncestry(Branch oldBranch, Branch branch) throws DbException {
        Set<String> movedBranchAncestry = this.clearOnBranchesIfRefWarped(oldBranch, branch);
        ImmutableList.Builder modifiedCsIds = ImmutableList.builder();
        if (branch != null && branch.getLatestChangeSetId() != null) {
            GraphIterator<String> it = this.iterateAncestors(branch.getLatestChangeSetId());
            String branchName = branch.getName();
            long branchId = ((CommonStringTables)this.stringTables).branchDB.find(branchName);
            while (it.hasNext()) {
                String csId = (String)it.next();
                if (this.contributesToBranch(csId, branchId)) {
                    it.prune();
                    continue;
                }
                if (!movedBranchAncestry.remove(csId)) {
                    modifiedCsIds.add((Object)csId);
                }
                this.markAsAncestorOfBranch(csId, branchName);
            }
        }
        modifiedCsIds.addAll(movedBranchAncestry);
        return modifiedCsIds.build();
    }

    public GraphIterator<String> iterateAncestors(String csid) throws DbException {
        return this.iterateAncestors(Collections.singleton(csid));
    }

    public GraphIterator<String> iterateAncestors(Collection<String> csids) {
        return GraphUtils.filteredGraphIterator(GraphUtils.iterateBreadthFirst(csids, this.csIdToParentsCsIds, Functions.identity()), this.existsFilter);
    }

    public GraphIterator<String> iterateDescendants(String csid) throws DbException {
        return GraphUtils.filteredGraphIterator(GraphUtils.iterateBreadthFirst(Collections.singleton(csid), this.csIdsToChildrenCsIds, Functions.identity()), this.existsFilter);
    }

    private C getEarliest(List<String> csIds) throws DbException {
        return this.getEarliestOrLatest(csIds, false);
    }

    private C getLatest(List<String> csIds) throws DbException {
        return this.getEarliestOrLatest(csIds, true);
    }

    private C getEarliestOrLatest(List<String> csIds, boolean latest) throws DbException {
        ChangeSetImpl result = null;
        for (String csId : csIds) {
            C cs = this.load(csId);
            if (cs == null) {
                log.debug((Object)("ChangeSet " + csId + " not found"));
                continue;
            }
            if (result != null && (!latest || !((ChangeSetImpl)cs).isAfter(result)) && (latest || !result.isAfter((ChangeSet)cs))) continue;
            result = (ChangeSetImpl)cs;
        }
        return (C)result;
    }

    @Override
    public C getNextChangeSet(ChangeSet cs) {
        return this.getNextOrPreviousChangeSet(cs, true);
    }

    @Override
    public C getPreviousChangeSet(ChangeSet cs) {
        return this.getNextOrPreviousChangeSet(cs, false);
    }

    private C getNextOrPreviousChangeSet(ChangeSet cs, boolean next) {
        y cu = y.a().a(CommonSchema.E_POSITION_TO_CHANGESET);
        int l2 = cu.e();
        if (cs != null) {
            cs.getPosition().appendToCu(cu);
        } else if (!next) {
            cu.j();
        }
        ac db = this.dbh.get();
        try {
            while (next ? db.a(cu, l2) : db.c(cu, l2)) {
                C result = this.getChangesetFromPostionToChangesetIndex(cu, l2);
                if (cs != null && ((ChangeSetImpl)result).getId().equals(cs.getId())) continue;
                return result;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return null;
    }

    private C getTipChangeSet(String branch) {
        I indexEntity = this.getCreatedOnBranchIndexEntityClass();
        long branchId = ((CommonStringTables)this.stringTables).branchDB.find(branch);
        if (branchId > 0L) {
            y cu = y.a().a(indexEntity).b(branchId);
            int l2 = cu.e();
            cu.j();
            ac db = this.dbh.get();
            try {
                if (db.c(cu, l2)) {
                    Position pos = new Position(cu, l2);
                    return this.getChangeSetAtPosition(pos);
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        return null;
    }

    @Override
    public C getTipChangeSet(Set<String> branches) {
        if (branches == null || branches.isEmpty()) {
            return (C)this.getPreviousChangeSet(null);
        }
        ChangeSet result = null;
        for (String branch : branches) {
            C branchTip = this.getTipChangeSet(branch);
            if (branchTip == null || result != null && !((ChangeSetImpl)branchTip).isAfter(result)) continue;
            result = (ChangeSet)branchTip;
        }
        return (C)result;
    }

    @Override
    public long getDbId(String csid) throws DbException {
        return ((CommonStringTables)this.stringTables).changeSetIdDB.find(csid);
    }

    @Override
    public String getAuthor(long csdbid) {
        y cu = y.a().a(CommonSchema.ChangeSetInfo.ENTITY).b(csdbid).a(CommonSchema.ChangeSetInfo.A_AUTHOR);
        int valueOffset = cu.e();
        ac db = this.dbh.get();
        try {
            if (db.a(cu, valueOffset)) {
                String string = cu.m(valueOffset);
                return string;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return null;
    }

    @Override
    public List<String> getBranches(long csdbid) {
        try {
            EavEntityCu eav = this.makeEav(csdbid);
            if (!eav.exists()) {
                return null;
            }
            return eav.getStrings(((CommonStringTables)this.stringTables).branchDB, CommonSchema.ChangeSetInfo.A_BRANCHES);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public List<String> getBranchesContributedTo(long csdbid) {
        EavEntityCu eav = this.makeEav(csdbid);
        try {
            if (!eav.exists()) {
                return null;
            }
            return eav.getStrings(((CommonStringTables)this.stringTables).branchDB, CommonSchema.ChangeSetInfo.A_ON_BRANCH);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public Date getDateValue(long csdbid) {
        y cu = y.a().a(CommonSchema.ChangeSetInfo.ENTITY).b(csdbid).a(CommonSchema.ChangeSetInfo.A_DATE);
        int valueOffset = cu.e();
        ac db = this.dbh.get();
        try {
            if (db.a(cu, valueOffset)) {
                Date date = new Date(cu.v(valueOffset));
                return date;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return null;
    }

    @Override
    public ChangeSetIndexingState getIndexingState(String csid) {
        try {
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.add(csid);
            EavEntityCu eav = this.makeEav(id);
            long indexingStateValue = eav.getLong(CommonSchema.ChangeSetInfo.A_INDEXING_STATE, ChangeSetIndexingState.UNKNOWN.getValue());
            return ChangeSetIndexingState.getState((int)indexingStateValue);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public void setIndexingState(String csid, ChangeSetIndexingState indexingState) {
        try {
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.add(csid);
            EavEntityCu eav = this.makeEav(id);
            this.updateIndexingState(eav, csid, indexingState);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public void updateIndexingState(String csid, long handlerVersion, ChangeSetIndexingState newState) {
        try {
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.add(csid);
            EavEntityCu eav = this.makeEav(id);
            eav.updateKeyedValue(CommonSchema.ChangeSetInfo.A_INDEXING_STATE_VERSION, newState.getValue(), handlerVersion);
            this.updateIndexingState(eav, csid, newState);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void setIndexingStateVersion(String csid, ChangeSetIndexingState state, long handlerVersion) {
        try {
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.add(csid);
            EavEntityCu eav = this.makeEav(id);
            eav.updateKeyedValue(CommonSchema.ChangeSetInfo.A_INDEXING_STATE_VERSION, state.getValue(), handlerVersion);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public int getRevisionCount(String csid) {
        if (csid != null) {
            try {
                y cu = y.a();
                cu.a(CommonSchema.E_CSID_TO_REV_COUNT).b(csid);
                int cuLength = cu.e();
                if (this.dbh.get().a(cu, cuLength)) {
                    return (int)cu.v(cuLength);
                }
                return 0;
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        return 0;
    }

    @Override
    public void setRevisionCount(String csid, int count) {
        try {
            y cu = y.a();
            cu.a(CommonSchema.E_CSID_TO_REV_COUNT).b(csid);
            int countOffset = cu.e();
            cu.b((long)count);
            this.dbh.get().e(cu, countOffset);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public Long getChangesetHandlerVersion(String csid, ChangeSetIndexingState state) {
        try {
            long id = ((CommonStringTables)this.stringTables).changeSetIdDB.add(csid);
            EavEntityCu eav = this.makeEav(id);
            long key = state.getValue();
            return eav.getKeyValueMap(CommonSchema.ChangeSetInfo.A_INDEXING_STATE_VERSION).get(key);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected LongLinkedOpenHashSet getLongIndexKeysWithLimit(I entityClass, long start, long limit, boolean reverse) {
        LongLinkedOpenHashSet result = new LongLinkedOpenHashSet();
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(entityClass);
            int pl = cu.e();
            if (reverse) {
                cu.b(start + 1L).j();
            } else {
                cu.b(start - 1L).j();
            }
            while (reverse ? db.c(cu, pl) : db.a(cu, pl)) {
                long csid = cu.v(pl);
                result.add(csid);
                if ((long)result.size() < limit) continue;
                break;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return result;
    }

    @Override
    public FileRevisionDAO<F> getFileRevDAO() {
        return this.fileRevDAO;
    }

    @Override
    public boolean isCommitInBranch(long csDbId, String branchName) {
        long branchId = ((CommonStringTables)this.stringTables).branchDB.find(branchName);
        p branchAttr = this.supportsCreatedOnBranch() ? CommonSchema.ChangeSetInfo.A_BRANCHES : CommonSchema.ChangeSetInfo.A_ON_BRANCH;
        y cu = y.a();
        try {
            boolean bl = this.dbh.get().a_(cu.a(CommonSchema.ChangeSetInfo.ENTITY).b(csDbId).a(branchAttr).b(branchId));
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }

    @Override
    public Set<String> getChangeSetAncestors(String csId, int limit, @Nullable Iterable<Branch> excludedBranches, @Nullable AtomicReference<String> topmostBranchPointCsId) throws DbException {
        long startCsDbId = this.getDbId(csId);
        if (startCsDbId <= 0L) {
            return Collections.emptySet();
        }
        try {
            if (excludedBranches == null) {
                excludedBranches = Collections.emptyList();
            }
            Iterable excludedBranchStartCsDbIds = Iterables.transform((Iterable)Iterables.transform(excludedBranches, Branch.TO_LATEST_CHANGESET_ID), ((CommonStringTables)this.stringTables).changeSetIdDB.stringToId());
            AncestryWalker excludedBranchesAncestry = new AncestryWalker(BitSets.newLazyBitSet(), excludedBranchStartCsDbIds);
            long maxBranchPointCsDbId = -1L;
            SortedIntSet ancestryCsDbIds = BitSets.newLazyBitSet();
            LinkedList<Long> toDoCsDbIds = new LinkedList<Long>();
            toDoCsDbIds.add(startCsDbId);
            int count = 0;
            while (!toDoCsDbIds.isEmpty() && count < limit) {
                int csDbId = ((Long)toDoCsDbIds.poll()).intValue();
                int stopDbId = FishEyeSysProps.CSDBIDS_TOPOLOGICAL_ORDER && this.isCsDbIdsInTopologicalOrder() ? csDbId : 0;
                excludedBranchesAncestry.fillDownTo(stopDbId);
                if (excludedBranchesAncestry.get(csDbId)) {
                    if (maxBranchPointCsDbId >= (long)csDbId) continue;
                    maxBranchPointCsDbId = csDbId;
                    continue;
                }
                if (ancestryCsDbIds.get(csDbId)) continue;
                ancestryCsDbIds.set(csDbId);
                ++count;
                toDoCsDbIds.addAll((Collection<Long>)this.getExistingParentDbIds(csDbId));
            }
            if (topmostBranchPointCsId != null) {
                topmostBranchPointCsId.set(this.getChangesetId(maxBranchPointCsDbId));
            }
            Iterable ancestryCsIds = Iterables.transform((Iterable)Iterables.limit(BitSets.descendingIterable(ancestryCsDbIds), (int)limit), ((CommonStringTables)this.stringTables).changeSetIdDB.idToString());
            return ImmutableSet.copyOf((Iterable)ancestryCsIds);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected boolean isCsDbIdsInTopologicalOrder() {
        return true;
    }

    protected LongList getExistingParentDbIds(long csDbId) throws IOException {
        EavEntityCu eav = this.makeEav(csDbId);
        LongList parentDbIds = eav.getLongsOrdered(CommonSchema.ChangeSetInfo.A_PARENTS);
        LinkedHashSet<String> existingParentIds = null;
        LongArrayList nonExistingParentDbIds = null;
        for (Long parentDbId : parentDbIds) {
            if (this.exists(parentDbId)) continue;
            String parentId = this.getChangesetId(parentDbId);
            log.debug((Object)("getExistingParentDbIds found non existing csDbId " + parentDbId + "/" + parentId));
            if (existingParentIds == null) {
                existingParentIds = new LinkedHashSet<String>();
                nonExistingParentDbIds = new LongArrayList(parentDbIds.size());
            }
            nonExistingParentDbIds.add((Object)parentDbId);
            existingParentIds.addAll(this.resolveParent(parentId));
        }
        if (existingParentIds != null) {
            parentDbIds.removeAll(nonExistingParentDbIds);
            parentDbIds.addAll(Collections2.transform(existingParentIds, ((CommonStringTables)this.stringTables).changeSetIdDB.stringToId()));
        }
        return parentDbIds;
    }

    protected String getChangesetId(long changesetDbId) {
        return ((CommonStringTables)this.stringTables).changeSetIdDB.get(changesetDbId);
    }

    private class AncestryWalker {
        private final SortedIntSet foundCsDbIds;
        private int currentCsDbId;

        public AncestryWalker(SortedIntSet foundCsDbIds, Iterable<Long> startCsDbIds) {
            this.foundCsDbIds = foundCsDbIds;
            BitSets.set(foundCsDbIds, startCsDbIds);
            this.currentCsDbId = foundCsDbIds.length();
        }

        public void fillDownTo(long stopCsDbId) throws IOException {
            while ((long)this.currentCsDbId >= stopCsDbId) {
                int csId = this.foundCsDbIds.prevSetBit(this.currentCsDbId - 1);
                if (csId != -1) {
                    this.foundCsDbIds.set(csId);
                    BitSets.set(this.foundCsDbIds, (Iterable<? extends Number>)CommonChangeSetDAO.this.getExistingParentDbIds(csId));
                }
                this.currentCsDbId = csId;
            }
        }

        public boolean get(long csDbId) {
            return this.foundCsDbIds.get((int)csDbId);
        }
    }
}

