/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.rep.ChangesetProcessor;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.MutableChangeSet;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import java.util.ArrayList;
import java.util.HashSet;

public class ChangeSetAncestryProcessor
implements ChangesetProcessor {
    protected final ChangeSetDAO<?, ?> csDAO;

    public ChangeSetAncestryProcessor(ChangeSetDAO<?, ?> csDAO) {
        this.csDAO = csDAO;
    }

    @Override
    public boolean process(MutableChangeSet changeset) throws DbException {
        HashSet<String> parentIds = new HashSet<String>();
        for (String branch : changeset.getBranches()) {
            Object latestChange;
            Object parent = this.csDAO.getLatestChangesetOnBranchUpTo(branch, changeset.getId(), false);
            if (parent == null && (latestChange = this.csDAO.getLatestChangesetOnBranch(branch)) != null && !changeset.getId().equals(latestChange.getId())) {
                parent = latestChange;
            }
            if (parent == null) continue;
            parentIds.add(parent.getId());
        }
        if (!parentIds.isEmpty() && !parentIds.equals(new HashSet<String>(changeset.getParents()))) {
            changeset.setParents(new ArrayList<String>(parentIds));
            return true;
        }
        return false;
    }
}

