/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.UpgradeTask;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;

public abstract class BaseUpgradeTask
implements UpgradeTask {
    private boolean hasTaskRun(InternalRevisionCache cache) throws DbException {
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_UPGRADETASKS_COMPLETED).b(this.getTaskId());
            ac db = cache.getInfDb().get();
            boolean bl = db.a_(cu);
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public static void markTaskRun(String task, InternalRevisionCache cache) throws DbException {
        y cu = y.a();
        try {
            cu.a(CommonSchema.E_UPGRADETASKS_COMPLETED).b(task);
            ac db = cache.getInfDb().get();
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException("Error recording upgrade task as run", e2);
        }
        finally {
            y.c(cu);
        }
    }

    private void markTaskRun(InternalRevisionCache cache) throws DbException {
        BaseUpgradeTask.markTaskRun(this.getTaskId(), cache);
    }

    @Override
    public void upgrade(RepositoryEngine engine, RepositoryStatus status) throws DbException {
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        Integer targetedSchema = this.getTargetedSchemaVersion(cache.getRepositoryType());
        if (targetedSchema != null && targetedSchema < cache.getVersion()) {
            return;
        }
        if (!this.hasTaskRun(cache)) {
            try {
                Logs.APP_LOG.info((Object)("Starting upgrade task " + this.getTaskId() + " on " + cache.getRepositoryName()));
                this.doUpgrade(engine, status);
                this.markTaskRun(cache);
                cache.commit();
                Logs.APP_LOG.info((Object)("Completed upgrade task " + this.getTaskId() + " on " + cache.getRepositoryName()));
            }
            catch (Exception e2) {
                cache.rollback();
                throw new DbException("Error during upgrade task " + this.getTaskId() + " on " + cache.getRepositoryName(), e2);
            }
        }
    }

    protected void clearTable(ac db, I tableClass) throws DbException {
        try {
            db.c(tableClass);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected boolean cloneTable(ac db, I fromTable, I toTable) throws DbException {
        try {
            y toCu = y.a().a(toTable);
            if (!db.b(toCu, toCu.e())) {
                db.a(toTable, db, fromTable);
                return true;
            }
            return false;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected boolean moveTable(ac db, I fromTable, I toTable) throws DbException {
        if (this.cloneTable(db, fromTable, toTable)) {
            this.clearTable(db, fromTable);
            return true;
        }
        return false;
    }

    protected void clearAttribute(ac db, p attribute, I table) throws DbException {
        y csCu = null;
        try {
            csCu = y.a().a(table);
            int offset = csCu.e();
            while (db.a(csCu, offset)) {
                int entityIdLength = csCu.j(offset);
                csCu.d(entityIdLength);
                csCu.a(attribute);
                db.c((Object)csCu);
                csCu.d(entityIdLength);
                csCu.j();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            if (csCu != null) {
                y.c(csCu);
            }
        }
    }

    protected void moveAttribute(ac db, p fromAttribute, p toAttribute, I table) throws DbException {
        y fromCu = null;
        try {
            fromCu = y.a().a(table);
            int offset = fromCu.e();
            while (db.a(fromCu, offset)) {
                int idOffset = fromCu.j(offset);
                fromCu.d(idOffset);
                y toCu = y.b(fromCu).a(toAttribute);
                fromCu.a(fromAttribute);
                int toAttLength = toCu.e();
                int fromAttLength = fromCu.e();
                if (db.b(fromCu, fromAttLength) && !db.b(toCu, toAttLength)) {
                    fromCu.d(fromAttLength);
                    toCu.d(toAttLength);
                    db.a((Object)toCu, db, fromCu);
                    db.c((Object)fromCu);
                }
                fromCu.d(idOffset).j();
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            if (fromCu != null) {
                y.c(fromCu);
            }
        }
    }

    protected abstract int getTargetedSchemaVersion(ScmType var1);

    protected abstract String getTaskId();

    protected abstract void doUpgrade(RepositoryEngine var1, RepositoryStatus var2) throws DbException;
}

