/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.blame.RevIdToAuthorMap;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

class RevisionCacheBasedRevIdToAuthorMap
implements RevIdToAuthorMap {
    private static final Logger log = Logs.loggerFor(RevisionCacheBasedRevIdToAuthorMap.class);
    private final LoadingCache<Integer, Optional<String>> revIdToAuthorCache;

    RevisionCacheBasedRevIdToAuthorMap(final Supplier<RevisionCache> cache) {
        this.revIdToAuthorCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Integer, Optional<String>>(){

            public Optional<String> load(Integer revId) throws Exception {
                String authorOfRevision = ((RevisionCache)Preconditions.checkNotNull(cache.get(), (Object)"InternalRevisionCache not available yet")).getAuthorOfRevision(revId);
                if (authorOfRevision != null) {
                    return Optional.of((Object)authorOfRevision);
                }
                log.debug((Object)("No author found for revision " + revId));
                return Optional.absent();
            }
        });
    }

    @Override
    public Optional<String> getAuthor(int revId) {
        try {
            return (Optional)this.revIdToAuthorCache.get((Object)revId);
        }
        catch (ExecutionException e2) {
            throw new DbException(e2);
        }
    }
}

