/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.blame.HunkZeroBased;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.stream.Collectors;

public class HunkToHunkZeroBasedConverter {
    private static final int BASE = 1;

    public List<HunkZeroBased> convert(List<Hunk> hunks) {
        return hunks.stream().map(h2 -> this.convertSingleHunk((Hunk)h2)).collect(Collectors.toList());
    }

    @VisibleForTesting
    HunkZeroBased convertSingleHunk(Hunk hunk) {
        return new HunkZeroBased(hunk.getFrom() - 1 + this.oneIfLengthIsZero(hunk.getFromCount()), hunk.getFromCount(), hunk.getTo() - 1 + this.oneIfLengthIsZero(hunk.getToCount()), hunk.getToCount());
    }

    private int oneIfLengthIsZero(int hunkLength) {
        return hunkLength == 0 ? 1 : 0;
    }
}

