/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.blame.AuthorBlameException;
import com.cenqua.fisheye.rep.blame.BlameChunksCalculator;
import com.cenqua.fisheye.rep.blame.HunkZeroBased;
import java.util.LinkedList;
import java.util.List;

public final class FlatteningBlameChunksCalculator
implements BlameChunksCalculator {
    private final BlameChunksCalculator delegate;

    public FlatteningBlameChunksCalculator(BlameChunksCalculator delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<BlameChunk> applyHunks(List<BlameChunk> oldBlame, List<HunkZeroBased> hunks, int hunksRevId) throws AuthorBlameException {
        List<BlameChunk> blameChunks = this.delegate.applyHunks(oldBlame, hunks, hunksRevId);
        LinkedList<BlameChunk> combinedBlameChunks = new LinkedList<BlameChunk>();
        for (BlameChunk bc2 : blameChunks) {
            BlameChunk prev = combinedBlameChunks.peekLast();
            if (prev != null && prev.getRevId() == bc2.getRevId()) {
                prev.setLength(prev.getLength() + bc2.getLength());
                continue;
            }
            combinedBlameChunks.add(bc2);
        }
        return combinedBlameChunks;
    }
}

