/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.blame.AuthorBlameException;
import com.cenqua.fisheye.rep.blame.BlameAssertions;
import com.cenqua.fisheye.rep.blame.BlameChunksCalculator;
import com.cenqua.fisheye.rep.blame.HunkZeroBased;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public final class DefaultBlameChunksCalculator
implements BlameChunksCalculator {
    private static final Logger log = Logs.loggerFor(DefaultBlameChunksCalculator.class);

    @Override
    public List<BlameChunk> applyHunks(List<BlameChunk> oldBlame, List<HunkZeroBased> hunks, int hunksRevId) throws AuthorBlameException {
        HunkZeroBased hunk;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Applying hunks; oldBlame=" + oldBlame + ", hunks=" + hunks + ", hunksRevId=" + hunksRevId));
        }
        DefaultBlameChunksCalculator.assertNoHunksStartBelow0(hunks);
        DefaultBlameChunksCalculator.assertHunksDontOverlap(hunks);
        BlameAssertions.assertBlameStartsAt0(oldBlame);
        BlameAssertions.assertBlameChunksAreConsecutive(oldBlame);
        Iterator<HunkZeroBased> hunkIterator = hunks.iterator();
        CalculationContext context = new CalculationContext(oldBlame, hunksRevId);
        context.nextCurrentChunk();
        while (context.isCurrentChunk() && hunkIterator.hasNext()) {
            hunk = hunkIterator.next();
            context.copyChunksUpTo(hunk.getFrom());
            context.addChunkFromHunk(hunk);
            context.skipChunksUpTo(hunk.getFrom() + hunk.getFromCount());
        }
        if (context.isCurrentChunk()) {
            context.copyChunksUpTo(Integer.MAX_VALUE);
        } else {
            while (hunkIterator.hasNext()) {
                hunk = hunkIterator.next();
                if (hunk.getFromCount() > 0) {
                    DefaultBlameChunksCalculator.throwNewAuthorBlameException("Trying to remove/modify lines beyond the end of the original file", hunk, context);
                }
                context.addChunkFromHunk(hunk);
            }
        }
        return context.newChunks;
    }

    private static void assertNoHunksStartBelow0(List<HunkZeroBased> hunks) throws AuthorBlameException {
        for (HunkZeroBased hunk : hunks) {
            if (hunk.getFrom() >= 0 && hunk.getTo() >= 0) continue;
            throw new AuthorBlameException("Hunk(s) have 'from'/'to' values below 0; hunks=" + hunk);
        }
    }

    private static void assertHunksDontOverlap(List<HunkZeroBased> hunks) throws AuthorBlameException {
        Iterator<HunkZeroBased> hunkSanityCheckIterator = hunks.iterator();
        HunkZeroBased prev = (HunkZeroBased)Iterators.getNext(hunkSanityCheckIterator, null);
        while (prev != null) {
            HunkZeroBased current = (HunkZeroBased)Iterators.getNext(hunkSanityCheckIterator, null);
            if (current != null && (prev.getFrom() + prev.getFromCount() > current.getFrom() || prev.getTo() + prev.getToCount() > current.getTo())) {
                throw new AuthorBlameException("Hunks overlap or are out of order; prev=" + prev + ", current=" + current + ", remaining hunks=" + Iterators.toString(hunkSanityCheckIterator));
            }
            prev = current;
        }
    }

    private static void throwNewAuthorBlameException(String msg, @Nullable HunkZeroBased hunk, CalculationContext context) throws AuthorBlameException {
        throw new AuthorBlameException(msg + "; hunk=" + hunk + ", currentFromLine=" + context.currentFromLine + ", currentToLine=" + context.currentToLine + ", currentChunk=" + context.currentChunk + ", newChunks=" + context.newChunks + ", remainingChunks=" + Iterators.toString((Iterator)context.chunksIterator));
    }

    private static class CalculationContext {
        private final int hunksRevId;
        private final Iterator<BlameChunk> chunksIterator;
        private final List<BlameChunk> newChunks = new ArrayList<BlameChunk>();
        private BlameChunk currentChunk;
        private int currentFromLine;
        private int currentToLine;

        public CalculationContext(List<BlameChunk> oldBlame, int hunksRevId) {
            this.chunksIterator = oldBlame.iterator();
            this.hunksRevId = hunksRevId;
        }

        public void nextCurrentChunk() {
            this.currentChunk = (BlameChunk)Iterators.getNext(this.chunksIterator, null);
        }

        public boolean isCurrentChunk() {
            return this.currentChunk != null;
        }

        public void copyChunksUpTo(int end) throws AuthorBlameException {
            this.consumeChunksUpTo(this::addChunkFromCurrentChunk, end, false);
        }

        public void skipChunksUpTo(int end) throws AuthorBlameException {
            this.consumeChunksUpTo(this::moveLines, end, true);
        }

        private void consumeChunksUpTo(IntConsumer consumer, int end, boolean mustNotGoBeyondOldBlameEnd) throws AuthorBlameException {
            int endOfLastBlame = 0;
            while (this.isCurrentChunk()) {
                int currentChunkEnd;
                endOfLastBlame = currentChunkEnd = this.currentChunk.getStart() + this.currentChunk.getLength();
                if (currentChunkEnd >= end) {
                    consumer.accept(end - this.currentFromLine);
                    break;
                }
                consumer.accept(currentChunkEnd - this.currentFromLine);
                this.nextCurrentChunk();
            }
            if (mustNotGoBeyondOldBlameEnd && end > endOfLastBlame) {
                DefaultBlameChunksCalculator.throwNewAuthorBlameException("Run over the end of blame chunks", null, this);
            }
        }

        private void addChunkFromCurrentChunk(int chunkLength) {
            if (chunkLength != 0) {
                BlameChunk newChunk = new BlameChunk(this.currentToLine, this.currentFromLine, chunkLength, this.currentChunk.getRevId());
                this.newChunks.add(newChunk);
                this.moveLines(chunkLength);
            }
        }

        private void addChunkFromHunk(HunkZeroBased hunk) throws AuthorBlameException {
            if (hunk.getToCount() > 0) {
                BlameChunk newChunk = new BlameChunk(this.currentToLine, this.currentFromLine, hunk.getToCount(), this.hunksRevId);
                this.newChunks.add(newChunk);
            }
            if (hunk.getTo() != this.currentToLine) {
                DefaultBlameChunksCalculator.throwNewAuthorBlameException("Hunk 'to' line does not match current calculation context", hunk, this);
            }
            this.moveLines(hunk.getFromCount(), hunk.getToCount());
        }

        private void moveLines(int count) {
            this.moveLines(count, count);
        }

        private void moveLines(int fromCount, int toCount) {
            this.currentFromLine += fromCount;
            this.currentToLine += toCount;
        }
    }
}

