/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.blame.AuthorBlameException;
import com.cenqua.fisheye.util.SumMap;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;

class BlameAssertions {
    public static void assertBlameStartsAt0(List<BlameChunk> blame) throws AuthorBlameException {
        if (blame.size() > 0 && blame.get(0).getStart() != 0) {
            throw new AuthorBlameException("Blame does not start at line 0; blame=" + blame);
        }
    }

    public static void assertBlameChunksAreConsecutive(List<BlameChunk> blame) throws AuthorBlameException {
        Iterator<BlameChunk> blameIterator = blame.iterator();
        BlameChunk prev = (BlameChunk)Iterators.getNext(blameIterator, null);
        while (prev != null) {
            BlameChunk current = (BlameChunk)Iterators.getNext(blameIterator, null);
            if (current != null && prev.getStart() + prev.getLength() != current.getStart()) {
                throw new AuthorBlameException("Blame is not consistent; blame=" + blame);
            }
            prev = current;
        }
    }

    public static void assertNoBlameLinesAreNegative(FileRevision revision, SumMap<String> authorLinecount) throws AuthorBlameException {
        if (BlameAssertions.linecountHasNegative(authorLinecount)) {
            throw new AuthorBlameException("Negative author blame calculated: " + authorLinecount, revision);
        }
    }

    private static boolean linecountHasNegative(SumMap<String> authorLinecount) {
        for (int lines : authorLinecount.values()) {
            if (lines >= 0) continue;
            return true;
        }
        return false;
    }

    public static void assertBlameLinesEqualRevisionLines(FileRevision revision, Blame lines) throws AuthorBlameException {
        if (lines.getTotalLines() != revision.getLineCount()) {
            throw new AuthorBlameException(revision.getRevInfoKey() + ": " + "Revision's calculated number of blame lines differs from stored revision linecount: " + "blameLines=" + lines.getTotalLines() + ", revisionLinecount=" + revision.getLineCount(), revision);
        }
    }

    private BlameAssertions() {
    }
}

