/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetInsertion;
import com.atlassian.fisheye.bucket.Period;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.History;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.blame.AuthorBlameException;
import com.cenqua.fisheye.rep.blame.AuthorLinesCalculator;
import com.cenqua.fisheye.rep.blame.BlameAssertions;
import com.cenqua.fisheye.rep.blame.DefaultBlameChunksCalculator;
import com.cenqua.fisheye.rep.blame.FlatteningBlameChunksCalculator;
import com.cenqua.fisheye.rep.blame.HunkToHunkZeroBasedConverter;
import com.cenqua.fisheye.rep.blame.RevisionCacheBasedRevIdToAuthorMap;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.util.SumMap;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.log4j.Logger;

@NotThreadSafe
public class BaseBlameAndLinecountCalculator
implements BlameAndLinecountCalculator {
    private static final Logger log = Logs.loggerFor(BaseBlameAndLinecountCalculator.class);
    protected final RepositoryStatus status;
    private final HunkToHunkZeroBasedConverter hunkToHunkZeroBasedConverter;
    private final FlatteningBlameChunksCalculator blameChunksCalculator;
    private final AuthorLinesCalculator authorLinesCalculator;
    private int numFileRevsProcessed = 0;
    private int totalFileRevs = 0;
    private int recursionLevel = 0;
    private static final int MAX_RECURSION_LEVEL = 20;
    private final RepositoryEngine engine;
    protected ChangesetLinecountCalculator changesetLinecountCalculator = null;

    public BaseBlameAndLinecountCalculator(RepositoryEngine engine) {
        this.engine = engine;
        this.status = engine.getStatus();
        this.hunkToHunkZeroBasedConverter = new HunkToHunkZeroBasedConverter();
        this.blameChunksCalculator = new FlatteningBlameChunksCalculator(new DefaultBlameChunksCalculator());
        RevisionCacheBasedRevIdToAuthorMap revIdToAuthorCache = new RevisionCacheBasedRevIdToAuthorMap(this::getCache);
        this.authorLinesCalculator = new AuthorLinesCalculator(revIdToAuthorCache);
    }

    @Override
    public void calcBlame(boolean forceReindex) throws DbException {
        if (!FishEyeSysProps.BLAME_CALC_ENABLED) {
            this.status.setMessage("Line count and blame data calculation is disabled, skipping");
            return;
        }
        InfinityDbHandle infDb = this.getCache().getInfDb();
        try {
            this.status.setLocSlurpInProgress(true);
            this.status.setMessage("Generating line count data");
            this.indexRevisions(forceReindex);
            this.indexChangesets();
            this.status.setMessage("Finished generating line count data, " + this.numFileRevsProcessed + " file revisions processed");
        }
        catch (IOException e2) {
            throw new DbException("Error reading database in linecount slurp", e2);
        }
        finally {
            this.status.setLocSlurpInProgress(false);
        }
        try {
            infDb.commit();
        }
        catch (DbException e3) {
            log.error((Object)"Problem committing author linecount, rolling back", (Throwable)e3);
            try {
                infDb.rollback();
            }
            catch (IOException e1) {
                log.error((Object)"Problem rolling back author linecount", (Throwable)e1);
            }
        }
        catch (IOException e4) {
            throw new DbException(e4);
        }
    }

    private void indexChangesets() throws DbException {
        if (this.changesetLinecountCalculator != null) {
            this.getCache().visitChangesetIds(this.getBucketGraph().getLastChangesetIdIndexed(), new UniqueStringTable.Visitor(){

                @Override
                public boolean visit(long id, CharSequence str) throws DbException {
                    BaseBlameAndLinecountCalculator.this.changesetLinecountCalculator.indexChangeset(id, str);
                    BaseBlameAndLinecountCalculator.this.getBucketGraph().setLastChangesetIdIndexed(id);
                    return !BaseBlameAndLinecountCalculator.this.status.isStopRequested();
                }
            });
        }
    }

    private void indexRevisions(boolean forceReindex) throws DbException, IOException {
        y revidCursor = y.a().a(CommonSchema.RevInfo.ENTITY);
        int revidCursorPrefixLength = revidCursor.e();
        revidCursor.j();
        ac db = this.getCache().getInfDb().get();
        if (db.c(revidCursor, revidCursorPrefixLength)) {
            this.totalFileRevs = (int)revidCursor.v(revidCursorPrefixLength);
        }
        int lastIndexedRevId = this.getBucketGraph().getLastRevIdIndexed();
        this.numFileRevsProcessed = Math.max(0, lastIndexedRevId);
        revidCursor.d(revidCursorPrefixLength).b((long)lastIndexedRevId);
        while (db.a(revidCursor, revidCursorPrefixLength)) {
            if (this.status.isStopRequested()) {
                return;
            }
            int revid = (int)revidCursor.v(revidCursorPrefixLength);
            if (!this.getBucketGraph().isRevIdIndexed(revid)) {
                this.calculateAndStoreRevisionData(revid, forceReindex);
            }
            this.getBucketGraph().setRevIdIndexed(revid);
            int offsetAfterKey = revidCursor.w(revidCursorPrefixLength);
            revidCursor.d(offsetAfterKey);
            revidCursor.ak(revidCursorPrefixLength);
        }
    }

    protected void calculateAndStoreRevisionData(int revId, boolean forceReindex) {
        FileRevision revision = this.getCache().getFileRevision(revId);
        if (!forceReindex && this.getCache().hasBlameSpans(revision.getRevInfoKey())) {
            log.debug((Object)("Already got blame spans for " + revId + ". Skipping calculation."));
            return;
        }
        List<ParameterSetInsertion> newData = this.calculateRevisionData(revision);
        for (ParameterSetInsertion data : newData) {
            this.getBucketGraph().addRevision(data);
        }
        this.logIndexingProgress();
    }

    protected List<ParameterSetInsertion> calculateRevisionData(FileRevision revision) throws DbException {
        if (revision.isBinaryOrOversize()) {
            log.debug((Object)("Skipping revision " + revision + " as it is binary/oversize."));
            return Collections.emptyList();
        }
        if (this.getCache().isStoreDiffs()) {
            return this.calcBlame(revision);
        }
        return this.calcSimpleLoc(revision);
    }

    protected ParameterSetInsertion getParameterSetInsertion(Path path, String branch, Date date, SumMap<String> linecountByAuthor, String commitAuthor, boolean isTrunklike, int revcount, long subBranchId) throws DbException {
        int bucket = new Period(date, this.getBucketGraph().getTimeZone()).getBucket();
        return new ParameterSetInsertion(path, branch, bucket, linecountByAuthor, commitAuthor, revcount, isTrunklike, subBranchId);
    }

    private List<ParameterSetInsertion> calcSimpleLoc(FileRevision rev) throws DbException {
        SumMap<String> map = new SumMap<String>((Object2IntMap<String>)new Object2IntOpenHashMap());
        String author = this.getCache().isAuthorLocEnabled() ? rev.getAuthor() : "__ALL_AUTHORS__";
        long subBranchId = this.getCache().getSubBranchId(rev.getChangeSetId());
        ArrayList<ParameterSetInsertion> data = new ArrayList<ParameterSetInsertion>();
        if (this.getCache().getRepositoryType() == ScmType.CVS) {
            map.put(author, rev.getLineCount());
            for (String branch : rev.getBranchPoints()) {
                data.add(this.getParameterSetInsertion(rev.getPath(), branch, this.getRevDate(rev), map, author, this.isCvsTrunk(rev, branch), 0, subBranchId));
            }
        }
        map.clear();
        map.put(rev.getAuthor(), rev.getLinesAdded() - rev.getLinesRemoved());
        data.add(this.getParameterSetInsertion(rev.getPath(), rev.getBranch(), this.getRevDate(rev), map, author, rev.isTrunkLike(), 1, subBranchId));
        return data;
    }

    private History getHistory(RevInfoKey rk, boolean withScmFallback) throws DbException {
        try {
            List<BlameChunk> blameSpans = this.getCache().getBlame(rk, withScmFallback).orElse(new Blame()).getChunks();
            return this.prepareHistory(blameSpans);
        }
        catch (AuthorBlameException | IOException e2) {
            throw new DbException(e2);
        }
    }

    @Nonnull
    private History prepareHistory(List<BlameChunk> blameSpans) throws AuthorBlameException {
        Blame lines = new Blame(blameSpans);
        SumMap<String> authorLinecount = this.authorLinesCalculator.getAuthorLinecount(blameSpans);
        return new History(authorLinecount, lines, this.getCache());
    }

    @Override
    public History getHistory(RevInfoKey revInfoKey) throws DbException {
        return this.getHistory(revInfoKey, false);
    }

    @Override
    public History getHistoryWithFallback(RevInfoKey revInfoKey) throws DbException {
        return this.getHistory(revInfoKey, true);
    }

    protected List<ParameterSetInsertion> calcBlame(FileRevision rev) throws DbException {
        if (rev.isDir() || this.engine.getPathMatcher().isTag(rev.getPath())) {
            return Collections.emptyList();
        }
        if (rev.isDead() && rev.getAncestors().isEmpty()) {
            this.getCache().setBlameSpans(rev.getRevInfoKey(), Collections.emptyList());
            return this.insertAuthorBlameRevision(rev, SumMap.getInstance(""), SumMap.getInstance(""));
        }
        if (rev.getAncestors().size() > 1) {
            return this.calcBlameFromScm(rev);
        }
        try {
            return this.calcBlameBasedOnAncestor(rev);
        }
        catch (AuthorBlameException e2) {
            String errorMsg = "Problems calculating blame for " + rev.getPath() + "@" + rev.getRevision() + ", ";
            if (FishEyeSysProps.BLAME_SCM_FALLBACK_ENABLED) {
                log.debug((Object)(errorMsg + "will fetch from repository instead"), (Throwable)e2);
                return this.calcBlameFromScm(rev);
            }
            log.debug((Object)(errorMsg + "blame won't be calculated"), (Throwable)e2);
            return this.calcSimpleLoc(rev);
        }
    }

    private List<ParameterSetInsertion> calcBlameBasedOnAncestor(FileRevision rev) throws DbException, AuthorBlameException {
        History ancestorHistory = null;
        CommonFileRevisionInput ancestor = null;
        if (!rev.getAncestors().isEmpty()) {
            ancestor = this.getCache().getFileRevision(rev.getAncestors().get(0));
            ancestorHistory = ancestor == null || ancestor.isDead() || ancestor.getLineCount() == 0 ? null : this.getHistoryRecursively((FileRevision)ancestor);
        }
        History revHistory = this.isNewlyAdded(rev) || ancestor == null || ancestor.isDead() || ancestor.getLineCount() == 0 ? this.getInitialHistory(rev) : (this.isDirectDescendentAndNotACopy(rev) ? this.getAuthDiff(rev, ancestorHistory, rev.getHunks()) : (ancestor.getLineCount() == rev.getLineCount() ? this.getAuthDiff(rev, this.getHistory(ancestor.getRevInfoKey()), Collections.emptyList()) : this.getInitialHistory(rev)));
        FileRevision diffRevision = this.determineDiffRevision(rev, (FileRevision)ancestor);
        History diffRevisionHistory = ancestor != null && diffRevision != null && diffRevision.getRevID() == ancestor.getRevID() ? ancestorHistory : (diffRevision == null ? null : this.getHistoryRecursively(diffRevision));
        SumMap<String> diffRevisionLinecount = diffRevisionHistory == null ? null : diffRevisionHistory.getAuthorLinecount();
        SumMap<String> diffAdjust = SumMap.getDifference(revHistory.getAuthorLinecount(), diffRevisionLinecount);
        RevInfoKey infoKey = rev.getRevInfoKey();
        this.getCache().setBlameSpans(infoKey, revHistory.getBlame());
        int total = diffAdjust.getTotal();
        if (total != rev.getLinesAdded() - rev.getLinesRemoved()) {
            throw new AuthorBlameException("Possible error adjusting author linecount for " + rev.getRevInfoKey() + " " + rev.getRevID() + ": Diff adds to " + total + " instead of " + (rev.getLinesAdded() - rev.getLinesRemoved()) + ": " + diffAdjust, rev);
        }
        return this.insertAuthorBlameRevision(rev, diffAdjust, revHistory.getAuthorLinecount());
    }

    @Nullable
    protected FileRevision determineDiffRevision(@Nonnull FileRevision revision, @Nullable FileRevision ancestor) {
        if (revision.getPredecessor() != null) {
            return this.getCache().getFileRevision(revision.getPredecessor());
        }
        if (this.isDirectDescendentAndNotACopy(revision)) {
            return ancestor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private History getHistoryRecursively(FileRevision ancestor) throws AuthorBlameException {
        RevInfoKey ancestorKey = ancestor.getRevInfoKey();
        List<BlameChunk> ancestorBlame = this.getCache().getBlameSpans(ancestorKey);
        if (ancestorBlame.isEmpty() && !this.getCache().hasBlameSpans(ancestorKey)) {
            if (this.recursionLevel > 20) {
                throw new AuthorBlameException("Failed to recursively fetch blame", ancestor);
            }
            try {
                ++this.recursionLevel;
                log.debug((Object)("Got no blame spans for " + ancestor + ", trying to recursively calculate the blame (" + this.recursionLevel + ")"));
                this.calculateAndStoreRevisionData(ancestor.getRevID(), false);
                ancestorBlame = this.getCache().getBlameSpans(ancestorKey);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Blame for " + ancestor + " after recursion is " + ancestorBlame));
                }
            }
            finally {
                --this.recursionLevel;
            }
        }
        return this.prepareHistory(ancestorBlame);
    }

    private List<ParameterSetInsertion> calcBlameFromScm(FileRevision rev) throws DbException {
        try {
            RevInfoKey predecessor;
            SumMap<String> authorLinecount = new SumMap<String>((Object2IntMap<String>)new Object2IntOpenHashMap());
            if (!(rev.isDead() || rev.isDir() || rev.isBinaryOrOversize())) {
                Blame blame = this.getCache().getBlameFallback(rev.getRevInfoKey());
                HashMap revisionToAuthor = Maps.newHashMap();
                HashMap revisionToRevid = Maps.newHashMap();
                for (BlameChunk span : blame.getChunks()) {
                    String author = (String)revisionToAuthor.get(span.getRevision());
                    Integer revid = (Integer)revisionToRevid.get(span.getRevision());
                    if (author == null) {
                        revid = span.getRevId();
                        if (revid <= 0) {
                            Path path = span.getInfo().getPath();
                            if (path == null) {
                                path = rev.getPath();
                            }
                            revid = this.getCache().getRevId(new RevInfoKey(path, span.getRevision()));
                        }
                        if (revid != -1) {
                            author = this.getCache().getAuthorOfRevision(revid);
                            revisionToAuthor.put(span.getRevision(), author);
                            revisionToRevid.put(span.getRevision(), revid);
                        } else {
                            log.warn((Object)("BaseLineCountCalulator#calcBlameFromScm: Could not find revision " + span.getRevision() + " for file " + rev.getPath()));
                        }
                    }
                    if (author != null) {
                        authorLinecount.addValue(author, span.getLength());
                    } else {
                        authorLinecount.addValue(rev.getAuthor(), span.getLength());
                    }
                    span.setRevId(revid);
                }
                this.getCache().setBlameSpans(rev.getRevInfoKey(), blame.getChunks());
                int blameLines = blame.getTotalLines();
                if (rev.getLineCount() != blameLines) {
                    log.debug((Object)("Updating revision linecount based on scm blame. Was " + rev.getLineCount() + ", now " + blameLines));
                    this.getCache().getCommonRevInfoDAO().updateLineCount(rev.getRevID(), blameLines, rev.getLinesAdded(), rev.getLinesRemoved(), rev.getLineCountState());
                }
            }
            History predecessorHistory = (predecessor = rev.getDiffRevision()) == null ? null : this.getHistory(predecessor);
            SumMap<String> predecessorLinecount = predecessorHistory == null ? null : predecessorHistory.getAuthorLinecount();
            SumMap<String> diffAdjust = SumMap.getDifference(authorLinecount, predecessorLinecount);
            return this.insertAuthorBlameRevision(rev, diffAdjust, authorLinecount);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private boolean isDirectDescendentAndNotACopy(FileRevision rev) {
        return !rev.isAdded() && rev.getAncestorLink() != null && (rev.getAncestorLink().isDirect() || rev.getAncestorLink().isBranchPoint());
    }

    private boolean isNewlyAdded(FileRevision rev) {
        return rev.getAncestorLink() == null;
    }

    private boolean isCvsTrunk(FileRevision branchPoint, String newBranch) {
        if (branchPoint.isTrunkLike()) {
            return false;
        }
        return newBranch.equals("MAIN");
    }

    private List<ParameterSetInsertion> insertAuthorBlameRevision(FileRevision rev, SumMap<String> authDiff, SumMap<String> authTotal) throws DbException {
        long subBranchId = this.getCache().getSubBranchId(rev.getChangeSetId());
        ArrayList<ParameterSetInsertion> data = new ArrayList<ParameterSetInsertion>();
        data.add(this.getParameterSetInsertion(rev.getPath(), rev.getBranch(), this.getRevDate(rev), authDiff, rev.getAuthor(), rev.isTrunkLike(), 1, subBranchId));
        if (this.getCache().getRepositoryType() == ScmType.CVS) {
            for (String branch : rev.getBranchPoints()) {
                data.add(this.getParameterSetInsertion(rev.getPath(), branch, this.getRevDate(rev), authTotal, rev.getAuthor(), this.isCvsTrunk(rev, branch), 0, subBranchId));
            }
        }
        return data;
    }

    private void logIndexingProgress() {
        ++this.numFileRevsProcessed;
        if (this.numFileRevsProcessed % 500 == 0) {
            this.status.setMessage("Generated line count data for " + this.numFileRevsProcessed + (this.totalFileRevs > 0 ? " of " + this.totalFileRevs : "") + " file revisions");
        }
    }

    protected Date getRevDate(FileRevision rev) {
        return new Date(rev.getDate());
    }

    private History getInitialHistory(FileRevision rev) throws AuthorBlameException {
        ImmutableList initialBlame;
        int count = rev.getLineCount();
        SumMap<String> authorLineCount = SumMap.getTreeInstance();
        if (count > 0) {
            authorLineCount.put(rev.getAuthor(), count);
            initialBlame = ImmutableList.of((Object)new BlameChunk(0, 0, count, rev.getRevID()));
        } else {
            initialBlame = ImmutableList.of();
        }
        Blame lines = new Blame((List<BlameChunk>)initialBlame);
        return new History(authorLineCount, lines, this.getCache());
    }

    private History getAuthDiff(FileRevision revision, History ancestorHistory, List<Hunk> hunks) throws DbException, AuthorBlameException {
        Blame lines;
        SumMap<String> authorLinecount;
        if (revision.isDead()) {
            authorLinecount = SumMap.getTreeInstance();
            lines = new Blame();
        } else {
            List<BlameChunk> blameChunks = this.applyHunks(ancestorHistory.getBlame(), hunks, revision.getRevID());
            authorLinecount = this.authorLinesCalculator.getAuthorLinecount(blameChunks);
            lines = new Blame(blameChunks);
        }
        BlameAssertions.assertBlameLinesEqualRevisionLines(revision, lines);
        BlameAssertions.assertNoBlameLinesAreNegative(revision, authorLinecount);
        return new History(authorLinecount, lines, this.getCache());
    }

    @VisibleForTesting
    List<BlameChunk> applyHunks(List<BlameChunk> oldBlame, List<Hunk> hunks, int hunksRevId) throws AuthorBlameException {
        return this.blameChunksCalculator.applyHunks(oldBlame, this.hunkToHunkZeroBasedConverter.convert(hunks), hunksRevId);
    }

    public InternalRevisionCache<? extends ChangeSet> getCache() {
        return this.engine.getInternalRevisionCache();
    }

    public BucketGraph getBucketGraph() {
        return this.engine.getBucketGraph();
    }

    protected static interface ChangesetLinecountCalculator {
        public void indexChangeset(long var1, CharSequence var3) throws DbException;
    }
}

