/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.blame.AuthorBlameException;
import com.cenqua.fisheye.rep.blame.BlameAssertions;
import com.cenqua.fisheye.rep.blame.RevIdToAuthorMap;
import com.cenqua.fisheye.util.SumMap;
import com.google.common.base.Optional;
import java.util.List;

public class AuthorLinesCalculator {
    private final RevIdToAuthorMap authorCache;

    public AuthorLinesCalculator(RevIdToAuthorMap authorCache) {
        this.authorCache = authorCache;
    }

    public SumMap<String> getAuthorLinecount(List<BlameChunk> blameChunks) throws AuthorBlameException {
        BlameAssertions.assertBlameStartsAt0(blameChunks);
        BlameAssertions.assertBlameChunksAreConsecutive(blameChunks);
        SumMap<String> sumMap = SumMap.getInstance();
        for (BlameChunk blameChunk : blameChunks) {
            Optional<String> author = this.authorCache.getAuthor(blameChunk.getRevId());
            if (!author.isPresent()) continue;
            sumMap.addValue((String)author.get(), blameChunk.getLength());
        }
        return sumMap;
    }
}

