/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.activity;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.StringObfuscator;
import com.atlassian.utils.process.StringOutputHandler;
import com.cenqua.fisheye.rep.activity.ActivityLog;
import com.cenqua.fisheye.util.RecentHistory;
import com.google.common.base.Strings;
import java.util.IdentityHashMap;
import java.util.Map;

public class ActivityLogMonitor
implements ProcessMonitor {
    private RecentHistory history;
    private Map<ExternalProcess, ActivityLog> activities = new IdentityHashMap<ExternalProcess, ActivityLog>();
    private StringObfuscator obfuscator;

    public ActivityLogMonitor(RecentHistory history, StringObfuscator obfuscator) {
        this.history = history;
        this.obfuscator = obfuscator;
    }

    private String getActivityName(ExternalProcess process) {
        if (this.obfuscator != null) {
            return this.obfuscator.obfuscate(process.getCommandLine());
        }
        return process.getCommandLine();
    }

    public void onBeforeStart(ExternalProcess process) {
        String name = this.getActivityName(process);
        ActivityLog activity = new ActivityLog(name);
        this.activities.put(process, activity);
        this.history.add(activity);
    }

    public void onAfterFinished(ExternalProcess process) {
        ActivityLog activity = this.activities.remove(process);
        if (activity != null) {
            if (process.getHandler().succeeded()) {
                activity.finished();
            } else {
                String message = this.getErrorMessage(process);
                activity.finishedWithError(message);
            }
            this.history.archive(activity);
        }
    }

    private String getErrorMessage(ExternalProcess process) {
        ProcessException e2;
        OutputHandler errHandler;
        PluggableProcessHandler phandler;
        String message = null;
        ProcessHandler handler = process.getHandler();
        if (handler instanceof PluggableProcessHandler && (message = (phandler = (PluggableProcessHandler)handler).getError()) == null && (errHandler = phandler.getErrorHandler()) instanceof StringOutputHandler) {
            message = ((StringOutputHandler)errHandler).getOutput();
        }
        if (Strings.isNullOrEmpty(message) && (e2 = handler.getException()) != null) {
            message = e2.getMessage();
        }
        if (Strings.isNullOrEmpty(message)) {
            message = "Exit code " + handler.getExitCode();
        }
        return message;
    }
}

