/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.activity;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

public class ActivityLog
implements Comparable<ActivityLog> {
    private static AtomicLong seq = new AtomicLong(0L);
    private long id;
    private String activity;
    private String message;
    private boolean error = false;
    private Date startTime;
    private Long duration;

    public ActivityLog(String activity) {
        this(activity, new Date());
    }

    public ActivityLog(String activity, Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("startTime cannot be null");
        }
        this.activity = activity;
        this.startTime = startTime;
        this.id = seq.getAndIncrement();
    }

    public void finished() {
        this.duration = System.currentTimeMillis() - this.startTime.getTime();
    }

    public void finishedWithError(String error) {
        this.finished();
        this.message = error;
        this.error = true;
    }

    public boolean isFinished() {
        return this.duration != null;
    }

    public boolean isError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public String getActivity() {
        return this.activity;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    @Override
    public int compareTo(ActivityLog other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        return this.startTime.getTime() > other.startTime.getTime() ? -1 : (this.startTime.getTime() < other.startTime.getTime() ? 1 : (this.id > other.id ? -1 : (this.id < other.id ? 1 : 0)));
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ActivityLog that = (ActivityLog)o2;
        if (this.error != that.error) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.activity != null ? !this.activity.equals(that.activity) : that.activity != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return this.startTime.equals(that.startTime);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.activity != null ? this.activity.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.error ? 1 : 0);
        result = 31 * result + this.startTime.hashCode();
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ActivityLog{activity='" + this.activity + '\'' + ", message='" + this.message + '\'' + ", error=" + this.error + ", startTime=" + this.startTime + ", duration=" + this.duration + '}';
    }
}

