/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern STARTS_NUMERICAL_PATTERN = Pattern.compile("^(\\d+).*");
    private List<Integer> version = new ArrayList<Integer>(5);
    private String versionString = null;

    public Version(Integer ... versionElems) {
        for (Integer i2 : versionElems) {
            this.version.add(i2);
        }
    }

    public Version(String versionStr) {
        String[] components;
        for (String comp : components = versionStr.split("[\\.\\-]")) {
            try {
                this.version.add(Integer.valueOf(comp));
            }
            catch (NumberFormatException e2) {
                Matcher matcher = STARTS_NUMERICAL_PATTERN.matcher(comp);
                if (!matcher.matches()) break;
                this.version.add(Integer.valueOf(matcher.group(1)));
                break;
            }
        }
    }

    public String toString() {
        if (this.versionString == null) {
            StringBuilder versionBuilder = new StringBuilder();
            String sep = "";
            for (Integer i2 : this.version) {
                versionBuilder.append(sep).append(i2);
                sep = ".";
            }
            this.versionString = versionBuilder.toString();
        }
        return this.versionString;
    }

    @Override
    public int compareTo(Version o2) {
        int maxIndex = Math.max(o2.version.size(), this.version.size());
        for (int i2 = 0; i2 < maxIndex; ++i2) {
            int otherV;
            int thisV = i2 < this.version.size() ? this.version.get(i2) : 0;
            int n2 = otherV = i2 < o2.version.size() ? o2.version.get(i2) : 0;
            if (thisV < otherV) {
                return -1;
            }
            if (thisV <= otherV) continue;
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

