/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.csindex.RecentChangesSearcher2;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositorySearcher;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpecificRepositorySearcher
extends RepositorySearcher {
    private final ChangesetCommentManager changesetCommentManager;
    private final CommitterUserMappingManager committerMappingManager;
    private final UserManager userManager;
    private final RepositoryManager repositoryManager;
    private final CommitterUserMappingManager committerUserMappingManager;

    @Autowired
    public SpecificRepositorySearcher(ChangesetCommentManager changesetCommentManager, CommitterUserMappingManager committerMappingManager, UserManager userManager, RepositoryManager repositoryManager, CommitterUserMappingManager committerUserMappingManager) {
        this.changesetCommentManager = changesetCommentManager;
        this.committerMappingManager = committerMappingManager;
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
        this.committerUserMappingManager = committerUserMappingManager;
    }

    @Override
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        ActivityItemList results;
        if (!params.isRepConstrained()) {
            throw new IllegalStateException("Specific Repository Searcher called with no rep constraint");
        }
        try {
            results = this.findActivityItemsForRep(params, user);
        }
        catch (DbException e2) {
            results = new ActivityItemList(e2);
        }
        catch (RepositoryHandle.StateException e3) {
            results = new ActivityItemList((Exception)((Object)e3));
        }
        return results;
    }

    public ActivityItemList findActivityItemsForRep(ActivityItemSearchParams itemParams, Principal user) throws DbException, RepositoryHandle.StateException {
        String repName = itemParams.getRepFilter();
        RecentChangesParams2 params = itemParams.generateChangelogParams(itemParams.getRepFilter());
        long t0 = System.currentTimeMillis();
        ArrayList<ChangeSetHolder> results = new ArrayList<ChangeSetHolder>();
        RepositoryHandle repository = this.repositoryManager.getRepository(repName);
        if (repository.isRunning() && this.userManager.hasPermissionToAccess(user, repository)) {
            RepositoryEngine engine = repository.acquireEngine();
            long t1 = System.currentTimeMillis();
            Path contextPath = !itemParams.isDownStream() && itemParams.getPaths().size() == 1 ? itemParams.getPaths().get(0) : Path.ROOT;
            RevisionCache<? extends ChangeSet> cache = engine.getRevisionCache();
            String defaultBranch = cache.getDefaultBranch();
            RepositoryConfig repositoryConfig = repository.getCfg();
            ChangeSetHolder.Context c2 = new ChangeSetHolder.Context(new WaybackSpec(), cache.isCaseSensitive(), 5, contextPath, repository.getName(), repositoryConfig.getRepositoryType(), defaultBranch);
            RecentChangesSearcher2 searcher = new RecentChangesSearcher2(engine);
            List<ChangeSet> changesets = searcher.findRecentChangeSets(params);
            for (ChangeSet cs : changesets) {
                ChangeSetHolder cai = new ChangeSetHolder(cs, c2, repositoryConfig.isSupportsBranchFilter(), this.committerUserMappingManager);
                cai.setComments(this.changesetCommentManager.getCommentsForChangeset(cs.getRepName(), cs.getId()));
                results.add(cai);
            }
            long t2 = System.currentTimeMillis();
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)("SpecificRepositorySearcher.findRecentChangeSets() retrieved " + results.size() + " changesets from " + repository.getName() + " in " + (t2 - t1) + "ms"));
            }
            this.optimiseResults(params.isTowardsFuture() ? SearchSortOrder.TOWARDS_FUTURE : SearchSortOrder.TOWARDS_PAST, params.getMaxReturn(), results);
        }
        long t3 = System.currentTimeMillis();
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)("SpecificRepositorySearcher.findRecentChangeSets() retrieved all changesets in " + (t3 - t0) + "ms"));
        }
        return new ActivityItemList(results);
    }

    @Override
    protected RecentChangesParams2 buildParams(ActivityItemSearchParams itemParams) throws DbException {
        RecentChangesParams2 changesParams = super.buildParams(itemParams);
        changesParams.setMaxReturn(itemParams.getMaxItems());
        this.constructCommitterQuery(itemParams.getCommitters(), changesParams);
        if (itemParams.getUserFilter() != null) {
            List<String> committers = this.committerMappingManager.getAllCommittersForUserInRep(itemParams.getRepFilter(), itemParams.getUserFilter());
            this.constructCommitterQuery(committers, changesParams);
        }
        this.constructPathQuery(itemParams.getPaths(), changesParams);
        return changesParams;
    }

    private void constructPathQuery(List<Path> paths, RecentChangesParams2 params) {
        for (Path path : paths) {
            params.addAnyPath(path);
        }
    }

    private void constructCommitterQuery(List<String> committers, RecentChangesParams2 params) {
        for (String committer : committers) {
            params.addAnyCommiter(committer);
        }
    }
}

