/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.SortedMap;

public abstract class SortedMapFileHistory
implements FileHistory {
    private final TreeMultimap<Long, FileRevision> revisions;
    private final Path path;

    public SortedMapFileHistory(Path path, TreeMultimap<Long, FileRevision> revisions) {
        this.path = path;
        this.revisions = revisions;
    }

    private FileRevision getFirst() {
        if (this.revisions.isEmpty()) {
            return null;
        }
        NavigableSet fileRevisions = this.revisions.get(this.revisions.asMap().firstKey());
        return fileRevisions == null || fileRevisions.isEmpty() ? null : (FileRevision)fileRevisions.first();
    }

    private FileRevision getLast() {
        if (this.revisions.isEmpty()) {
            return null;
        }
        long lastKey = (Long)this.revisions.asMap().lastKey();
        return (FileRevision)this.revisions.get((Object)lastKey).last();
    }

    @Override
    public boolean isBinary() {
        FileRevision last = this.getLast();
        return last != null && last.isBinary();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public MinMaxLongRange getDateRange() {
        FileRevision last = this.getLast();
        long now = System.currentTimeMillis();
        long firstDate = last == null ? now : this.getFirst().getDate();
        long lastDate = last == null ? now : last.getDate();
        return new MinMaxLongRange(firstDate, lastDate);
    }

    @Override
    public Collection<FileRevision> getRevisions() {
        return this.revisions.values();
    }

    @Override
    public List<FileRevision> getRevisionsSorted() {
        ArrayList<FileRevision> revs = new ArrayList<FileRevision>(this.getRevisions());
        Collections.sort(revs, FileRevision.OLDEST_FIRST_COMPARATOR);
        Collections.reverse(revs);
        return revs;
    }

    @Override
    public FileRevision getRevision(String rev) {
        Long changeSetId;
        if (rev == null) {
            return null;
        }
        try {
            changeSetId = Long.valueOf(rev);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        NavigableSet fileRevisions = this.revisions.get((Object)changeSetId);
        return fileRevisions == null || fileRevisions.isEmpty() ? null : (FileRevision)fileRevisions.first();
    }

    @Override
    public List<FileRevision> getRevisionsForRev(String rev) {
        NavigableSet fileRevisions = this.revisions.get((Object)Long.valueOf(rev));
        return fileRevisions == null ? null : ImmutableList.copyOf((Collection)fileRevisions);
    }

    @Override
    public String getHead() throws DbException {
        ArrayList csids = new ArrayList(this.revisions.keySet());
        ListIterator i2 = csids.listIterator(csids.size());
        while (i2.hasPrevious()) {
            Long key = (Long)i2.previous();
            for (FileRevision revision : this.revisions.get((Object)key)) {
                if (!revision.getPath().equals(this.getPath())) continue;
                return revision.getRevision();
            }
        }
        return null;
    }

    @Override
    public List<String> getRevisions(String br) {
        HashSet<String> addedRevs = new HashSet<String>();
        ArrayList<String> branchRevisions = new ArrayList<String>();
        for (FileRevision revision : this.revisions.values()) {
            String csid = revision.getChangeSetId();
            if (!br.equals(revision.getBranch()) || addedRevs.contains(csid)) continue;
            branchRevisions.add(csid);
            addedRevs.add(csid);
        }
        return branchRevisions;
    }

    @Override
    public List<FileRevision> getNonBranchRevisions() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getBranches() {
        HashSet<String> branches = new HashSet<String>();
        for (FileRevision revision : this.revisions.values()) {
            branches.add(revision.getBranch());
            branches.addAll(revision.getBranchPoints());
        }
        return branches;
    }

    @Override
    public String getBranchPoint(String branch) {
        for (FileRevision info : this.revisions.values()) {
            if (!info.getBranchPoints().contains(branch)) continue;
            return info.getRevision();
        }
        return null;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        pw.println("History for :" + this.path);
        for (FileRevision revision : this.revisions.values()) {
            pw.println(revision);
        }
        pw.println("-----");
        pw.flush();
        return writer.toString();
    }

    @Override
    public boolean containsRevision(String revision) {
        if (revision == null) {
            return false;
        }
        try {
            return this.revisions.containsKey((Object)Long.valueOf(revision));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Override
    public String getFirstRevisionOnBranch(String branch) {
        List<FileRevision> branchRevisions = this.getBranchRevisions(branch);
        if (branchRevisions.isEmpty()) {
            return null;
        }
        FileRevision firstOnBranch = branchRevisions.get(0);
        return firstOnBranch.getChangeSetId();
    }

    private List<FileRevision> getBranchRevisions(String branch) {
        ArrayList<FileRevision> branchRevisions = new ArrayList<FileRevision>();
        for (FileRevision fileRevision : this.revisions.values()) {
            if (!fileRevision.getBranch().equals(branch)) continue;
            branchRevisions.add(fileRevision);
        }
        return branchRevisions;
    }

    public TreeMultimap<Long, FileRevision> getRevisionMap() {
        return this.revisions;
    }

    public static void addFileAncestry(BaseRevisionCache cache, TreeMultimap<Long, FileRevision> ancestry, RevInfoKey key, boolean includeDead, boolean physicalOnly) throws DbException {
        RevInfoKey firstRevKey;
        long rev = Long.parseLong(key.getRev());
        if (ancestry.containsKey((Object)rev)) {
            return;
        }
        SortedMapFileHistory history = (SortedMapFileHistory)cache.getFileHistory(key.getPath(), physicalOnly);
        SortedMap revisionMap = history.getRevisionMap().asMap().headMap(rev + 1L);
        if (revisionMap.isEmpty()) {
            return;
        }
        Collection firstList = (Collection)revisionMap.get(revisionMap.firstKey());
        FileRevision firstRevision = (FileRevision)firstList.iterator().next();
        if (!firstRevision.isAdded() && !(firstRevKey = firstRevision.getRevInfoKey()).equals(key)) {
            SortedMapFileHistory.addFileAncestry(cache, ancestry, firstRevKey, false, physicalOnly);
        }
        for (Long csid : revisionMap.keySet()) {
            Collection csidRevisions = (Collection)revisionMap.get(csid);
            for (FileRevision fileRevision : csidRevisions) {
                AncestorLink ancestorLink;
                if (!fileRevision.isDead() || includeDead) {
                    if (ancestry.containsKey((Object)csid)) {
                        if (!ancestry.get((Object)csid).contains(fileRevision)) {
                            ancestry.put((Object)csid, (Object)fileRevision);
                        }
                    } else {
                        ancestry.put((Object)csid, (Object)fileRevision);
                    }
                }
                if ((ancestorLink = fileRevision.getAncestorLink()) == null || ancestorLink.isDirect()) continue;
                IntListIterator intListIterator = ancestorLink.getRevids().iterator();
                while (intListIterator.hasNext()) {
                    int arevid = (Integer)intListIterator.next();
                    RevInfoKey ancestorKey = cache.getKey(arevid);
                    if (ancestorKey == null || ancestorKey.equals(key)) continue;
                    SortedMapFileHistory.addFileAncestry(cache, ancestry, ancestorKey, false, physicalOnly);
                }
            }
        }
    }
}

