/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;

public class RevListCache<V> {
    private Long2ObjectSortedMap<V> revMap = new Long2ObjectAVLTreeMap();

    public long getStartRevision() {
        if (this.revMap.isEmpty()) {
            return -1L;
        }
        return this.revMap.firstLongKey();
    }

    public long getEndRevision() {
        if (this.revMap.isEmpty()) {
            return -1L;
        }
        return this.revMap.lastLongKey();
    }

    public void add(Long2ObjectMap<V> revisions) {
        this.revMap.putAll(revisions);
    }

    public void removeUpto(long newStart) {
        if (!this.revMap.isEmpty()) {
            Long2ObjectSortedMap headMap = this.revMap.headMap(Long.valueOf(newStart));
            headMap.clear();
        }
    }

    public boolean isEmpty() {
        return this.revMap.isEmpty();
    }

    public long getBlockEnd(long blockSize) {
        if (this.isEmpty()) {
            return -1L;
        }
        long lastValueKey = (long)this.revMap.size() < blockSize ? this.revMap.lastLongKey() : this.revMap.keySet().toLongArray()[(int)(blockSize - 1L)];
        return lastValueKey;
    }

    public Long2ObjectSortedMap<V> getRevisions() {
        return this.revMap;
    }
}

